/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.time.Duration;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.ScheduledTask;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.repository.PresenceCollectorRepository;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="ghostbuster", parent=PubSubComponent.class, active=true)
public class Ghostbuster
extends ScheduledTask {
    private static final Logger log = Logger.getLogger(Ghostbuster.class.getCanonicalName());
    @ConfigField(desc="Time after which presence is considered stale and ping should be send")
    private Duration staleTime = Duration.ofHours(1L);
    @ConfigField(desc="Limit of pings send in a single batch")
    private int batchSize = 1000;
    @Inject(bean="service")
    private PubSubComponent pubSubComponent;
    @Inject
    private PresenceCollectorRepository presenceCollectorRepository;

    public Ghostbuster() {
        super(Duration.ofMinutes(10L), Duration.ofMinutes(5L));
    }

    public void run() {
        try {
            long border = System.currentTimeMillis() - this.staleTime.toMillis();
            this.presenceCollectorRepository.expiredUserResourceEntriesStream(border).filter(userResourceEntry -> this.shouldPing(userResourceEntry.getJid())).sorted(Comparator.comparing(PresenceCollectorRepository.UserResourceEntry::getLastSeen)).limit(this.batchSize).forEach(this::ping);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e, () -> "Problem on executing ghostbuster");
        }
    }

    public void ping(final PresenceCollectorRepository.UserResourceEntry entry) {
        String id = UUID.randomUUID().toString();
        Element ping = new Element("iq", new String[]{"type", "id"}, new String[]{"get", id});
        ping.addChild((XMLNodeIfc)new Element("ping", new String[]{"xmlns"}, new String[]{"urn:xmpp:ping"}));
        Packet packet = Packet.packetInstance((Element)ping, (JID)JID.jidInstanceNS((BareJID)entry.getServiceJid()), (JID)entry.getJid());
        packet.setXMLNS("jabber:client");
        log.log(Level.FINEST, "for " + entry.getServiceJid() + " sending ping to " + entry.getJid());
        this.pubSubComponent.addOutPacketWithTimeout(packet, new ReceiverTimeoutHandler(){

            public void timeOutExpired(Packet data) {
                log.log(Level.FINEST, "for " + entry.getServiceJid() + " ping to " + entry.getJid() + " timed out");
                Ghostbuster.this.markAsGone(entry, Authorization.REMOTE_SERVER_TIMEOUT);
            }

            public void responseReceived(Packet data, Packet response) {
                if (response.getType() == StanzaType.error) {
                    Authorization errorReason = Optional.ofNullable(response.getElemChild("error")).map(errorEl -> errorEl.findChild(el -> el.getXMLNS() == null || "urn:ietf:params:xml:ns:xmpp-stanzas".equals(el.getXMLNS()))).map(Element::getName).map(Authorization::getByCondition).orElse(Authorization.INTERNAL_SERVER_ERROR);
                    switch (errorReason) {
                        case FEATURE_NOT_IMPLEMENTED: {
                            Ghostbuster.this.markAsSeen(entry);
                            break;
                        }
                        default: {
                            Ghostbuster.this.markAsGone(entry, errorReason);
                            break;
                        }
                    }
                } else {
                    Ghostbuster.this.markAsSeen(entry);
                }
            }
        }, 1L, TimeUnit.MINUTES);
    }

    protected void markAsSeen(PresenceCollectorRepository.UserResourceEntry entry) {
        log.log(Level.FINEST, "for " + entry.getServiceJid() + " marking " + entry.getJid() + " as available now");
        entry.markAsSeen();
    }

    protected void markAsGone(PresenceCollectorRepository.UserResourceEntry entry, Authorization reason) {
        log.log(Level.FINEST, () -> "for " + entry.getServiceJid() + " marking " + entry.getJid() + " last seen " + entry.getLastSeen() + " as gone due to ping response: " + reason.getCondition());
        this.presenceCollectorRepository.remove(entry.getServiceJid(), entry.getJid());
    }

    protected boolean shouldPing(JID jid) {
        return true;
    }
}

