/*
 * Decompiled with CFR 0.152.
 */
package tigase.cert;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Optional;
import tigase.cert.CertificateUtil;

public class CertificateEntry {
    private Certificate[] chain = null;
    private PrivateKey privateKey = null;
    private KeyPair keyPair = null;

    public CertificateEntry() {
    }

    public CertificateEntry(Certificate[] chain, KeyPair keyPair) {
        this.chain = chain;
        this.keyPair = keyPair;
        this.privateKey = keyPair.getPrivate();
    }

    public CertificateEntry(Certificate[] chain, PrivateKey privateKey) {
        this.chain = chain;
        this.privateKey = privateKey;
        this.keyPair = new KeyPair(chain[0].getPublicKey(), privateKey);
    }

    public Certificate[] getCertChain() {
        return this.chain;
    }

    public void setCertChain(Certificate[] chain) {
        this.chain = chain;
        if (this.privateKey != null) {
            this.keyPair = new KeyPair(chain[0].getPublicKey(), this.privateKey);
        }
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        if (this.chain != null) {
            this.keyPair = new KeyPair(this.chain[0].getPublicKey(), privateKey);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean basic) {
        StringBuilder sb = new StringBuilder(4096);
        for (Certificate cert : this.chain) {
            if (basic) {
                CertificateUtil.getCertificateBasicInfo(sb, cert);
                continue;
            }
            sb.append(cert.toString());
        }
        return "Private key: " + (this.privateKey != null ? "present" : "MISSING!!! \n\n\n") + "\n" + sb;
    }

    public Optional<KeyPair> getKeyPair() {
        return Optional.ofNullable(this.keyPair);
    }

    public Optional<Certificate> getCertificate() {
        return this.chain != null && this.chain.length > 0 ? Optional.of(this.chain[0]) : Optional.empty();
    }
}

