/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb.muc;

import com.mongodb.MongoNamespace;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Updates;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import tigase.annotations.TigaseDeprecated;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.util.RepositoryVersionAware;
import tigase.db.util.SchemaLoader;
import tigase.kernel.beans.config.ConfigField;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.mongodb.MongoRepositoryVersionAware;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.history.AbstractHistoryProvider;
import tigase.muc.history.ExtendedMAMRepository;
import tigase.server.Packet;
import tigase.util.Version;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.QueryImpl;

@Repository.Meta(supportedUris={"mongodb:.*"})
@Repository.SchemaId(id="muc-history", name="Tigase MUC Component (History)", external=false)
@RepositoryVersionAware.SchemaVersion
public class MongoHistoryProvider
extends AbstractHistoryProvider<MongoDataSource>
implements MongoRepositoryVersionAware,
ExtendedMAMRepository {
    private static final int DEF_BATCH_SIZE = 100;
    private static final String HASH_ALG = "SHA-256";
    private static final String HISTORY_COLLECTION = "tig_muc_room_history";
    private static final String HISTORY_COLLECTION_OLD = "muc_history";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected MongoCollection<Document> historyCollection;
    @ConfigField(desc="Batch size", alias="batch-size")
    private int batchSize = 100;
    private MongoDatabase db;

    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @TigaseDeprecated(removeIn="3.0.0", note="Use method with `stableId`", since="2.4.0")
    @Deprecated
    public void addMessage(Room room, Element message, String body, JID senderJid, String senderNickname, Date time) {
        this.addMessage(room, message, body, senderJid, senderNickname, time, UUID.randomUUID().toString());
    }

    public void addMessage(Room room, Element message, String body, JID senderJid, String senderNickname, Date time, String stableId) {
        try {
            byte[] rid = this.generateId(room.getRoomJID());
            Document dto = new Document("room_jid_id", (Object)rid).append("room_jid", (Object)room.getRoomJID().toString()).append("event_type", (Object)1).append("sender_jid", (Object)senderJid.toString()).append("sender_nickname", (Object)senderNickname).append("stable_id", (Object)UUID.fromString(stableId)).append("body", (Object)body).append("public_event", (Object)room.getConfig().isLoggingEnabled());
            if (time != null) {
                dto.append("timestamp", (Object)time);
            }
            if (message != null) {
                dto.append("msg", (Object)message.toString());
            }
            this.historyCollection.insertOne((Object)dto);
        }
        catch (Exception ex) {
            this.log.log(Level.WARNING, "Can't add MUC message to database", ex);
            throw new RuntimeException(ex);
        }
    }

    public void addSubjectChange(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
    }

    public ExtendedMAMRepository.Item getItem(BareJID owner, final String stableId) throws RepositoryException {
        try {
            byte[] rid = this.generateId(owner);
            Document result = (Document)this.historyCollection.find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"room_jid_id", (Object)rid), Filters.eq((String)"stable_id", (Object)UUID.fromString(stableId))})).projection(Projections.include((String[])new String[]{"msg", "timestamp", "sender_jid"})).first();
            if (result == null) {
                return null;
            }
            String msgStr = result.getString((Object)"msg");
            final Element msg = this.parseMessage(msgStr);
            final Date timestamp = result.getDate((Object)"timestamp");
            final String msgSenderJid = result.getString((Object)"sender_jid");
            return new ExtendedMAMRepository.Item(){

                public String getId() {
                    return stableId;
                }

                public Element getMessage() {
                    return msg;
                }

                public Date getTimestamp() {
                    return timestamp;
                }

                public JID getSenderJID() {
                    if (msgSenderJid != null) {
                        return JID.jidInstanceNS((String)msgSenderJid);
                    }
                    return null;
                }
            };
        }
        catch (Exception ex) {
            this.log.log(Level.WARNING, "Can't retrieve MUC message to database", ex);
            throw new RuntimeException(ex);
        }
    }

    public void updateMessage(BareJID owner, String stableId, Element msg, String body) throws RepositoryException {
        try {
            byte[] rid = this.generateId(owner);
            this.historyCollection.updateOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"room_jid_id", (Object)rid), Filters.eq((String)"stable_id", (Object)UUID.fromString(stableId))}), Updates.combine((Bson[])new Bson[]{Updates.set((String)"body", (Object)body), Updates.set((String)"msg", (Object)msg.toString())}));
        }
        catch (Exception ex) {
            this.log.log(Level.WARNING, "Can't update MUC message in database", ex);
            throw new RuntimeException(ex);
        }
    }

    protected byte[] calculateHash(String user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(HASH_ALG);
            return md.digest(user.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    private Packet createMessage(BareJID roomJid, JID senderJID, Document dto, boolean addRealJids) throws TigaseStringprepException {
        String sender_nickname = (String)dto.get((Object)"sender_nickname");
        String msg = (String)dto.get((Object)"msg");
        String body = (String)dto.get((Object)"body");
        String sender_jid = (String)dto.get((Object)"sender_jid");
        Date timestamp = (Date)dto.get((Object)"timestamp");
        UUID stableId = (UUID)dto.get((Object)"stable_id");
        return this.createMessage(roomJid, senderJID, sender_nickname, msg, body, sender_jid, addRealJids, timestamp, stableId.toString());
    }

    public void destroy() {
    }

    protected byte[] generateId(BareJID user) throws TigaseDBException {
        return this.calculateHash(user.toString().toLowerCase());
    }

    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, PacketWriter writer) {
        Affiliation recipientAffiliation = room.getAffiliation(senderJID.getBareJID()).getAffiliation();
        boolean addRealJids = room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.nonanonymous || room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.semianonymous && (recipientAffiliation == Affiliation.owner || recipientAffiliation == Affiliation.admin);
        try {
            int limit;
            if (maxchars != null && maxchars == 0) {
                return;
            }
            byte[] rid = this.generateId(room.getRoomJID());
            int maxMessages = room.getConfig().getMaxHistory();
            int n = limit = maxstanzas != null ? Math.min(maxMessages, maxstanzas) : maxMessages;
            if (since == null && seconds != null && maxstanzas == null) {
                since = new Date(new Date().getTime() - (long)(seconds * 1000));
            }
            Document crit = new Document("room_jid_id", (Object)rid);
            if (since != null) {
                crit.append("timestamp", (Object)new Document("$gte", (Object)since));
                Document order = new Document("timestamp", (Object)1);
                FindIterable cursor = this.historyCollection.find((Bson)crit).batchSize(this.batchSize).limit(limit).sort((Bson)order);
                for (Document dto : cursor) {
                    Packet packet = this.createMessage(room.getRoomJID(), senderJID, dto, addRealJids);
                    writer.write(packet);
                }
            } else {
                Document order = new Document("timestamp", (Object)-1);
                FindIterable cursor = this.historyCollection.find((Bson)crit).batchSize(this.batchSize).limit(limit).sort((Bson)order);
                ArrayList<Packet> results = new ArrayList<Packet>();
                for (Document dto : cursor) {
                    Packet packet = this.createMessage(room.getRoomJID(), senderJID, dto, addRealJids);
                    results.add(packet);
                }
                Collections.reverse(results);
                writer.write(results);
            }
        }
        catch (Exception ex) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.log(Level.SEVERE, "Can't get history", ex);
            }
            throw new RuntimeException(ex);
        }
    }

    private Long getItemPosition(String msgId, Bson filter) throws ComponentException {
        if (msgId == null) {
            return null;
        }
        try {
            Document dto = (Document)this.historyCollection.find(Filters.and((Bson[])new Bson[]{filter, Filters.eq((String)"stable_id", (Object)UUID.fromString(msgId))})).projection(Projections.include((String[])new String[]{"timestamp"})).first();
            if (dto == null) {
                return null;
            }
            return this.historyCollection.countDocuments(Filters.and((Bson[])new Bson[]{filter, Filters.lt((String)"timestamp", (Object)dto.getDate((Object)"timestamp"))}));
        }
        catch (NumberFormatException ex) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "Not found message with id = " + msgId);
        }
    }

    public boolean isPersistent(Room room) {
        return true;
    }

    public Query newQuery() {
        return new QueryImpl();
    }

    public void queryItems(Query query, MAMRepository.ItemHandler itemHandler) throws TigaseDBException, ComponentException {
        try {
            byte[] rid = this.generateId(query.getComponentJID().getBareJID());
            ArrayList<Bson> filters = new ArrayList<Bson>();
            filters.add(Filters.eq((String)"room_jid_id", (Object)rid));
            if (query.getStart() != null) {
                filters.add(Filters.gte((String)"timestamp", (Object)query.getStart()));
            }
            if (query.getEnd() != null) {
                filters.add(Filters.lte((String)"timestamp", (Object)query.getEnd()));
            }
            if (query.getWith() != null) {
                filters.add(Filters.eq((String)"sender_nickname", (Object)query.getWith().toString()));
            }
            Bson filter = Filters.and(filters);
            long count = this.historyCollection.countDocuments(filter);
            Long after = this.getItemPosition(query.getRsm().getAfter(), filter);
            Long before = this.getItemPosition(query.getRsm().getBefore(), filter);
            AbstractHistoryProvider.calculateOffsetAndPosition((Query)query, (int)((int)count), (Integer)(before == null ? null : Integer.valueOf(before.intValue())), after == null ? null : Integer.valueOf(after.intValue()));
            Document order = new Document("timestamp", (Object)1);
            FindIterable cursor = this.historyCollection.find(filter).sort((Bson)order).skip(query.getRsm().getIndex().intValue()).limit(query.getRsm().getMax());
            for (Document dto : cursor) {
                String sender_nickname = (String)dto.get((Object)"sender_nickname");
                String msg = (String)dto.get((Object)"msg");
                String body = (String)dto.get((Object)"body");
                final Date timestamp = (Date)dto.get((Object)"timestamp");
                final UUID stableId = (UUID)dto.get((Object)"stable_id");
                final String msgSenderJid = dto.getString((Object)"sender_jid");
                final Element msgEl = this.createMessageElement(query.getComponentJID().getBareJID(), query.getQuestionerJID(), sender_nickname, msg, body, stableId.toString());
                ExtendedMAMRepository.Item item = new ExtendedMAMRepository.Item(){

                    public String getId() {
                        return stableId.toString();
                    }

                    public Element getMessage() {
                        return msgEl;
                    }

                    public Date getTimestamp() {
                        return timestamp;
                    }

                    public JID getSenderJID() {
                        if (msgSenderJid != null) {
                            return JID.jidInstanceNS((String)msgSenderJid);
                        }
                        return null;
                    }
                };
                itemHandler.itemFound(query, (MAMRepository.Item)item);
            }
        }
        catch (Exception ex) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.log(Level.SEVERE, "Can't get history", ex);
            }
            throw new RuntimeException(ex);
        }
    }

    public void removeHistory(Room room) {
        try {
            byte[] rid = this.generateId(room.getRoomJID());
            Document crit = new Document("room_jid_id", (Object)rid);
            this.db.getCollection(HISTORY_COLLECTION).deleteMany((Bson)crit);
        }
        catch (Exception ex) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.log(Level.SEVERE, "Can't remove history", ex);
            }
            throw new RuntimeException(ex);
        }
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists(this.db, HISTORY_COLLECTION)) {
            if (Helper.collectionExists(this.db, HISTORY_COLLECTION_OLD)) {
                this.db.getCollection(HISTORY_COLLECTION_OLD).renameCollection(new MongoNamespace(this.db.getName(), HISTORY_COLLECTION));
            } else {
                this.db.createCollection(HISTORY_COLLECTION);
            }
        }
        this.historyCollection = this.db.getCollection(HISTORY_COLLECTION);
        this.historyCollection.createIndex((Bson)new Document("room_jid_id", (Object)1));
        this.historyCollection.createIndex((Bson)new Document("room_jid_id", (Object)1).append("timestamp", (Object)1));
        this.historyCollection.createIndex((Bson)new Document("room_jid_id", (Object)1).append("stable_id", (Object)1));
    }

    public SchemaLoader.Result updateSchema(Optional<Version> oldVersion, Version newVersion) throws TigaseDBException {
        List<Bson> aggregationQuery = Arrays.asList(Aggregates.group((Object)"$room_jid_id", (BsonField[])new BsonField[]{Accumulators.first((String)"room_jid", (Object)"$room_jid")}));
        for (Document doc : this.historyCollection.aggregate(aggregationQuery).batchSize(100)) {
            byte[] newRoomJidId;
            String roomJid = (String)doc.get((Object)"room_jid");
            byte[] oldRoomJidId = ((Binary)doc.get((Object)"_id")).getData();
            if (Arrays.equals(oldRoomJidId, newRoomJidId = this.calculateHash(roomJid.toString().toLowerCase()))) continue;
            this.historyCollection.updateMany((Bson)new Document("room_jid_id", (Object)oldRoomJidId), (Bson)new Document("$set", (Object)new Document("room_jid_id", (Object)newRoomJidId)));
        }
        for (Document doc : this.historyCollection.find(Filters.exists((String)"stable_id", (boolean)false)).projection(Projections.include((String[])new String[]{"_id"})).batchSize(100)) {
            this.historyCollection.updateOne(Filters.eq((String)"_id", (Object)doc.getObjectId((Object)"_id")), Updates.set((String)"stable_id", (Object)UUID.randomUUID()));
        }
        return SchemaLoader.Result.ok;
    }
}

