/*
 * Decompiled with CFR 0.152.
 */
package tigase.mongodb;

import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.DeleteResult;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import tigase.db.DBInitException;
import tigase.db.NonAuthUserRepository;
import tigase.db.Repository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.util.RepositoryVersionAware;
import tigase.db.util.SchemaLoader;
import tigase.kernel.beans.config.ConfigField;
import tigase.mongodb.Helper;
import tigase.mongodb.MongoDataSource;
import tigase.mongodb.MongoRepositoryVersionAware;
import tigase.server.Packet;
import tigase.server.amp.db.MsgRepository;
import tigase.util.Version;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Repository.Meta(supportedUris={"mongodb:.*"})
@Repository.SchemaId(id="server-offline-message", name="Tigase XMPP Server (Offline Messages)", external=false)
@RepositoryVersionAware.SchemaVersion
public class MongoMsgRepository
extends MsgRepository<ObjectId, MongoDataSource>
implements MongoRepositoryVersionAware {
    private static final Logger log = Logger.getLogger(MongoMsgRepository.class.getCanonicalName());
    private static final String JID_HASH_ALG = "SHA-256";
    private static final int DEF_BATCH_SIZE = 100;
    private static final String MSG_HISTORY_COLLECTION = "tig_offline_messages";
    private static final TimestampHelper dt = new TimestampHelper();
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @ConfigField(desc="Batch size", alias="batch-size")
    private int batchSize = 100;
    private MongoDatabase db;
    private MongoCollection<Document> msgHistoryCollection;

    private byte[] calculateHash(String user) throws TigaseDBException {
        try {
            MessageDigest md = MessageDigest.getInstance(JID_HASH_ALG);
            return md.digest(user.getBytes(UTF8));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new TigaseDBException("Should not happen!!", (Throwable)ex);
        }
    }

    protected void deleteMessage(ObjectId dbId) {
        try {
            this.msgHistoryCollection.deleteOne((Bson)new Document("_id", (Object)dbId));
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }

    public int deleteMessagesToJID(List<String> db_ids, XMPPResourceConnection session) throws UserNotFoundException {
        int count = 0;
        BareJID to = null;
        try {
            to = session.getBareJID();
            byte[] toHash = this.generateId(to);
            Bson crit = Filters.eq((String)"to_hash", (Object)toHash);
            if (db_ids == null || db_ids.size() == 0) {
                this.msgHistoryCollection.deleteMany(crit);
            } else {
                crit = Filters.and((Bson[])new Bson[]{crit, Filters.in((String)"_id", (Iterable)db_ids.stream().map(id -> new ObjectId(id)).collect(Collectors.toList()))});
                DeleteResult result = this.msgHistoryCollection.deleteMany(crit);
                count = (int)result.getDeletedCount();
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", ex);
        }
        return count;
    }

    private byte[] generateId(BareJID user) throws TigaseDBException {
        return this.calculateHash(user.toString().toLowerCase());
    }

    public Element getMessageExpired(long time, boolean delete) {
        MsgRepository.MsgDBItem item;
        if (this.expiredQueue.size() == 0) {
            this.loadExpiredQueue(1000);
        } else {
            item = (MsgRepository.MsgDBItem)this.expiredQueue.peek();
            if (item != null && this.earliestOffline < item.expired.getTime()) {
                this.loadExpiredQueue(item.expired);
            }
        }
        item = (MsgRepository.MsgDBItem)this.expiredQueue.poll();
        if (item == null) {
            return null;
        }
        if (delete) {
            this.deleteMessage((ObjectId)item.db_id);
        }
        return item.msg;
    }

    public Map<Enum, Long> getMessagesCount(JID to) throws UserNotFoundException {
        HashMap<Enum, Long> result = new HashMap<Enum, Long>(MsgRepository.MSG_TYPES.values().length);
        try {
            byte[] toHash = this.generateId(to.getBareJID());
            Document crit = new Document("to_hash", (Object)toHash);
            for (MsgRepository.MSG_TYPES type : MsgRepository.MSG_TYPES.values()) {
                long count = this.msgHistoryCollection.countDocuments((Bson)crit.append("msg_type", (Object)type.toString()));
                if (count <= 0L) continue;
                result.put((Enum)type, count);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", ex);
        }
        return result;
    }

    public List<Element> getMessagesList(JID to) throws UserNotFoundException {
        LinkedList<Element> result = new LinkedList<Element>();
        try {
            byte[] toHash = this.generateId(to.getBareJID());
            Document crit = new Document("to_hash", (Object)toHash);
            FindIterable cursor = this.msgHistoryCollection.find((Bson)crit).projection(Projections.include((String[])new String[]{"_id", "from", "msg_type"})).sort(Sorts.ascending((String[])new String[]{"ts"})).batchSize(this.batchSize);
            for (Document it : cursor) {
                String msgId = it.getObjectId((Object)"_id").toHexString();
                String sender = null;
                if (it.containsKey((Object)"from")) {
                    sender = (String)it.get((Object)"from");
                }
                MsgRepository.MSG_TYPES messageType = MsgRepository.MSG_TYPES.none;
                if (it.containsKey((Object)"msg_type")) {
                    messageType = MsgRepository.MSG_TYPES.valueOf((String)((String)it.get((Object)"msg_type")));
                }
                if (msgId == null || messageType == null || messageType == MsgRepository.MSG_TYPES.none || sender == null) continue;
                Element item = new Element("item", new String[]{"jid", "node", "type", "name"}, new String[]{to.getBareJID().toString(), msgId, messageType.name(), sender});
                result.add(item);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem retrieving itmes from DB: ", ex);
        }
        return result;
    }

    @Deprecated
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        try {
            if (params != null) {
                this.batchSize = params.containsKey("batch-size") ? Integer.parseInt(params.get("batch-size")) : 100;
            }
            if (this.db == null) {
                MongoDataSource ds = new MongoDataSource();
                ds.initRepository(resource_uri, params);
                this.setDataSource(ds);
            }
            super.initRepository(resource_uri, params);
        }
        catch (MongoException ex) {
            throw new DBInitException("Could not connect to MongoDB server using URI = " + resource_uri, (Throwable)ex);
        }
    }

    protected void loadExpiredQueue(int max) {
        try {
            FindIterable cursor = this.msgHistoryCollection.find((Bson)new Document("expire-at", (Object)new Document("$lt", (Object)new Date()))).sort((Bson)new Document("expire-at", (Object)1)).batchSize(this.batchSize).limit(max);
            DomBuilderHandler domHandler = new DomBuilderHandler();
            for (Document it : cursor) {
                if (this.expiredQueue.size() < 1000) {
                    String msg_str = (String)it.get((Object)"message");
                    this.parser.parse((SimpleHandler)domHandler, msg_str.toCharArray(), 0, msg_str.length());
                    Queue elems = domHandler.getParsedElements();
                    Element msg = (Element)elems.poll();
                    if (msg == null) {
                        log.log(Level.INFO, "Something wrong, loaded offline message from DB but parsed no XML elements: {0}", msg_str);
                        continue;
                    }
                    Date ts = (Date)it.get((Object)"ts");
                    MsgRepository.MsgDBItem item = new MsgRepository.MsgDBItem((Object)((ObjectId)it.get((Object)"_id")), msg, ts);
                    this.expiredQueue.offer(item);
                    continue;
                }
                break;
            }
        }
        catch (MongoException ex) {
            log.log(Level.WARNING, "Problem getting offline messages from db: ", ex);
        }
        this.earliestOffline = Long.MAX_VALUE;
    }

    protected void loadExpiredQueue(Date expired) {
        try {
            if (this.expiredQueue.size() > 100000) {
                this.expiredQueue.clear();
                this.awaitingInExpiredQueue.set(0);
            }
            FindIterable cursor = this.msgHistoryCollection.find((Bson)new Document("expire-at", (Object)new Document("$lt", (Object)expired))).sort((Bson)new Document("expire-at", (Object)1)).batchSize(this.batchSize);
            DomBuilderHandler domHandler = new DomBuilderHandler();
            int counter = 0;
            for (Document it : cursor) {
                if (counter++ < 1000) {
                    String msg_str = (String)it.get((Object)"message");
                    this.parser.parse((SimpleHandler)domHandler, msg_str.toCharArray(), 0, msg_str.length());
                    Queue elems = domHandler.getParsedElements();
                    Element msg = (Element)elems.poll();
                    if (msg == null) {
                        log.log(Level.INFO, "Something wrong, loaded offline message from DB but parsed no XML elements: {0}", msg_str);
                        continue;
                    }
                    Date ts = (Date)it.get((Object)"ts");
                    MsgRepository.MsgDBItem item = new MsgRepository.MsgDBItem((Object)((ObjectId)it.get((Object)"_id")), msg, ts);
                    this.expiredQueue.offer(item);
                    continue;
                }
                break;
            }
        }
        catch (MongoException ex) {
            log.log(Level.WARNING, "Problem getting offline messages from db: ", ex);
        }
        this.earliestOffline = Long.MAX_VALUE;
    }

    public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete) throws UserNotFoundException {
        return this.loadMessagesToJID(session, delete, null);
    }

    public Queue<Element> loadMessagesToJID(XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        return this.loadMessagesToJID(null, session, delete, proc);
    }

    public Queue<Element> loadMessagesToJID(List<String> db_ids, XMPPResourceConnection session, boolean delete, MsgRepository.OfflineMessagesProcessor proc) throws UserNotFoundException {
        Queue<Element> result = null;
        BareJID to = null;
        try {
            to = session.getBareJID();
            byte[] toHash = this.generateId(to);
            Bson crit = Filters.eq((String)"to_hash", (Object)toHash);
            if (db_ids != null && !db_ids.isEmpty()) {
                crit = Filters.and((Bson[])new Bson[]{crit, Filters.in((String)"_id", (Iterable)db_ids.stream().map(id -> new ObjectId(id)).collect(Collectors.toList()))});
            }
            FindIterable cursor = this.msgHistoryCollection.find(crit).sort(Sorts.ascending((String[])new String[]{"ts"})).batchSize(this.batchSize);
            ArrayList<Document> list = new ArrayList<Document>();
            for (Document it2 : cursor) {
                if (it2.containsKey((Object)"expire-at") && ((Date)it2.get((Object)"expire-at")).getTime() < System.currentTimeMillis()) continue;
                list.add(it2);
            }
            result = this.parseLoadedMessages(proc, list);
            result.stream().map(it -> it.getAttributeStaticStr("id")).forEach(it -> System.out.println((String)it));
            if (delete) {
                this.msgHistoryCollection.deleteMany(crit);
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", ex);
        }
        return result;
    }

    private Queue<Element> parseLoadedMessages(MsgRepository.OfflineMessagesProcessor proc, List<Document> list) {
        StringBuilder sb = new StringBuilder(1000);
        Queue<Object> result = new LinkedList<Element>();
        if (proc != null) {
            for (Document it : list) {
                String msg = (String)it.get((Object)"message");
                String msgId = null;
                if (it.containsKey((Object)"ts")) {
                    msgId = dt.format((Date)it.get((Object)"ts"));
                }
                if (msg == null) continue;
                DomBuilderHandler domHandler = new DomBuilderHandler();
                this.parser.parse((SimpleHandler)domHandler, msg.toCharArray(), 0, msg.length());
                Queue parsedElements = domHandler.getParsedElements();
                Element msgEl = (Element)parsedElements.poll();
                if (msgEl == null || msgId == null) continue;
                proc.stamp(msgEl, msgId);
                result.add(msgEl);
            }
        } else {
            result = new LinkedList();
            for (Document it : list) {
                sb.append(it.get((Object)"message"));
            }
            if (sb.length() > 0) {
                DomBuilderHandler domHandler = new DomBuilderHandler();
                this.parser.parse((SimpleHandler)domHandler, sb.toString().toCharArray(), 0, sb.length());
                result = domHandler.getParsedElements();
            }
        }
        return result;
    }

    public void setDataSource(MongoDataSource dataSource) {
        this.db = dataSource.getDatabase();
        if (!Helper.collectionExists(this.db, MSG_HISTORY_COLLECTION)) {
            if (Helper.collectionExists(this.db, "msg_history")) {
                this.db.getCollection("msg_history").renameCollection(new MongoNamespace(this.db.getName(), MSG_HISTORY_COLLECTION));
            } else {
                this.db.createCollection(MSG_HISTORY_COLLECTION);
            }
        }
        this.msgHistoryCollection = this.db.getCollection(MSG_HISTORY_COLLECTION);
        this.msgHistoryCollection.createIndex((Bson)new Document("ts", (Object)1));
        this.msgHistoryCollection.createIndex((Bson)new Document("to_hash", (Object)1));
    }

    public boolean storeMessage(JID from, JID to, Date expired, Element msg, NonAuthUserRepository userRepo) throws UserNotFoundException {
        try {
            MsgRepository.MSG_TYPES valueOf;
            byte[] fromHash = this.generateId(from.getBareJID());
            byte[] toHash = this.generateId(to.getBareJID());
            Document crit = new Document("from_hash", (Object)fromHash).append("to_hash", (Object)toHash).append("from", (Object)from.getBareJID().toString()).append("to", (Object)to.getBareJID().toString());
            long count = this.msgHistoryCollection.countDocuments((Bson)crit);
            long msgs_store_limit = this.getMsgsStoreLimit(to.getBareJID(), userRepo);
            if (msgs_store_limit <= count) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Message store limit ({0}) exceeded for message: {1}", new Object[]{msgs_store_limit, Packet.elemToString((Element)msg)});
                }
                return false;
            }
            Document dto = crit;
            if (expired != null) {
                dto = new Document((Map)crit);
                dto.append("expire-at", (Object)expired);
                crit.append("expire-at", (Object)new Document("$lt", (Object)new Date()));
            }
            dto.append("ts", (Object)new Date());
            try {
                String name = msg.getName();
                valueOf = MsgRepository.MSG_TYPES.valueOf((String)name);
            }
            catch (IllegalArgumentException e) {
                valueOf = MsgRepository.MSG_TYPES.none;
            }
            dto.append("msg_type", (Object)valueOf.toString());
            dto.append("message", (Object)msg.toString());
            this.msgHistoryCollection.insertOne((Object)dto);
            if (expired != null) {
                if (expired.getTime() < this.earliestOffline) {
                    this.earliestOffline = expired.getTime();
                }
                if (this.awaitingInExpiredQueue.get() == 0) {
                    this.loadExpiredQueue(1);
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", ex);
        }
        return true;
    }

    public SchemaLoader.Result updateSchema(Optional<Version> oldVersion, Version newVersion) throws TigaseDBException {
        for (Document doc : this.msgHistoryCollection.find().batchSize(1000).projection(Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{"_id", "from", "from_hash", "to", "to_hash"})}))) {
            String from = (String)doc.get((Object)"from");
            String to = (String)doc.get((Object)"to");
            byte[] oldToHash = Optional.ofNullable((Binary)doc.get((Object)"to_hash")).map(Binary::getData).orElse(new byte[0]);
            byte[] oldFromHash = Optional.ofNullable((Binary)doc.get((Object)"from_hash")).map(Binary::getData).orElse(new byte[0]);
            byte[] newToHash = this.calculateHash(to.toLowerCase());
            byte[] newFromHash = this.calculateHash(from.toLowerCase());
            if (Arrays.equals(oldFromHash, newFromHash) && Arrays.equals(oldToHash, newToHash)) continue;
            Document update = new Document("from_hash", (Object)newFromHash).append("to_hash", (Object)newToHash);
            this.msgHistoryCollection.updateOne((Bson)new Document("_id", doc.get((Object)"_id")), (Bson)new Document("$set", (Object)update));
        }
        return SchemaLoader.Result.ok;
    }
}

