/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Optional;
import tigase.xml.Element;

public class Encryption {
    private final String cryptoSuite;
    private final String keyParams;
    private final Optional<String> sessionParams;
    private final String tag;

    public static Encryption from(Element el) {
        if ("crypto".equals(el.getName())) {
            String cryptoSuite = el.getAttributeStaticStr("crypto-suite");
            String keyParams = el.getAttributeStaticStr("key-params");
            Optional<String> sessionParams = Optional.ofNullable(el.getAttributeStaticStr("session-params"));
            String tag = el.getAttributeStaticStr("tag");
            if (cryptoSuite == null || keyParams == null || tag == null) {
                return null;
            }
            return new Encryption(cryptoSuite, keyParams, sessionParams, tag);
        }
        return null;
    }

    public Encryption(String cryptoSuite, String keyParams, Optional<String> sessionParams, String tag) {
        this.cryptoSuite = cryptoSuite;
        this.keyParams = keyParams;
        this.sessionParams = sessionParams;
        this.tag = tag;
    }

    public String getCryptoSuite() {
        return this.cryptoSuite;
    }

    public String getKeyParams() {
        return this.keyParams;
    }

    public Optional<String> getSessionParams() {
        return this.sessionParams;
    }

    public String getTag() {
        return this.tag;
    }

    public Element toElement() {
        Element el = new Element("crypto");
        el.setAttribute("crypto-suite", this.cryptoSuite);
        el.setAttribute("key-params", this.keyParams);
        this.sessionParams.ifPresent(sessionParams -> el.setAttribute("session-params", sessionParams));
        el.setAttribute("tag", this.tag);
        return el;
    }

    public String toSDP() {
        StringBuilder sb = new StringBuilder("a=crypto:").append(this.tag).append(" ").append(this.cryptoSuite).append(" ").append(this.keyParams);
        this.sessionParams.ifPresent(it -> sb.append(" ").append((String)it));
        return sb.toString();
    }
}

