/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.ComponentException;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.IPresenceRepository;
import tigase.meet.MeetComponent;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="presenceCollectorRepository", parent=MeetComponent.class, active=true)
public class PresenceCollectorRepository
implements IPresenceRepository {
    private static final Logger log = Logger.getLogger(PresenceCollectorRepository.class.getCanonicalName());
    private ConcurrentHashMap<BareJID, MeetPresences> meetParticipantPresences = new ConcurrentHashMap();
    @Inject
    private EventBus eventBus;

    public void addJid(BareJID meetJid, JID jid) throws ComponentException {
        MeetPresences meetPresences = this.meetParticipantPresences.get(meetJid);
        if (meetPresences == null) {
            log.log(Level.FINEST, () -> "not marking " + jid + " as available for " + meetJid + " - meet doesn't exist!");
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "There is no meeting for this JID");
        }
        meetPresences.addJid(jid);
    }

    public void removeJid(BareJID meetJid, JID jid) throws ComponentException {
        MeetPresences meetPresences = this.meetParticipantPresences.get(meetJid);
        if (meetPresences == null) {
            log.log(Level.FINEST, () -> "not marking " + jid + " as unavailable for " + meetJid + " - meet doesn't exist!");
            throw new ComponentException(Authorization.ITEM_NOT_FOUND, "There is no meeting for this JID");
        }
        meetPresences.removeJid(jid);
        this.eventBus.fire((Object)new IPresenceRepository.UserDisappearedEvent(meetJid, jid));
    }

    @Override
    public boolean isAvailable(BareJID meetJid, JID jid) {
        MeetPresences meetPresences = this.meetParticipantPresences.get(meetJid);
        if (meetPresences == null) {
            return false;
        }
        return meetPresences.isAvailable(jid);
    }

    public void meetCreated(BareJID meetJid) {
        log.log(Level.FINEST, () -> "creating presence store for " + meetJid);
        this.meetParticipantPresences.put(meetJid, new MeetPresences());
    }

    public void meetDestroyed(BareJID meetJid) {
        log.log(Level.FINEST, () -> "destroying presence store for " + meetJid);
        this.meetParticipantPresences.remove(meetJid);
    }

    private class MeetPresences {
        private final CopyOnWriteArraySet<JID> availableJids = new CopyOnWriteArraySet();

        private MeetPresences() {
        }

        public void addJid(JID jid) {
            this.availableJids.add(jid);
        }

        public void removeJid(JID jid) {
            this.availableJids.remove(jid);
        }

        public boolean isAvailable(JID jid) {
            return this.availableJids.contains(jid);
        }
    }
}

