/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import tigase.component.exceptions.ComponentException;
import tigase.meet.AbstractMeet;
import tigase.meet.MeetRepository;
import tigase.meet.Participation;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;
import tigase.util.common.TimerTask;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class Meet
extends AbstractMeet<Participation> {
    public static final BareJID ALLOW_EVERYONE = BareJID.bareJIDInstanceNS((String)"*");
    private Set<BareJID> allowed = new CopyOnWriteArraySet<BareJID>();
    private final ConcurrentHashMap<JID, Participation> participationByJid = new ConcurrentHashMap();
    private final MeetRepository repository;
    private final BareJID jid;
    private TimerTask timeoutTask;

    public Meet(MeetRepository repository, JanusConnection janusConnection, Object roomId, BareJID jid) {
        super(janusConnection, roomId);
        this.repository = repository;
        this.jid = jid;
        this.timeoutTask = this.repository.scheduleJoinTimeoutTask(this);
    }

    public BareJID getJid() {
        return this.jid;
    }

    public void allow(BareJID jid) {
        this.allowed.add(jid);
    }

    public void deny(BareJID jid) {
        this.allowed.remove(jid);
        this.participationByJid.entrySet().stream().filter(e -> jid.equals((Object)((JID)e.getKey()).getBareJID())).map(e -> (Participation)e.getValue()).forEach(participation -> participation.leave(null));
    }

    public boolean isPublic() {
        return this.isAllowed(ALLOW_EVERYONE);
    }

    public boolean isAllowed(BareJID jid) {
        return this.allowed.contains(ALLOW_EVERYONE) || this.allowed.contains(jid);
    }

    public CompletableFuture<Participation> join(JID jid) {
        if (this.participationByJid.contains(jid)) {
            return CompletableFuture.failedFuture(new ComponentException(Authorization.CONFLICT));
        }
        return this.join(jid.getBareJID().toString(), (publisher, subscriber) -> new Participation(this, jid, (LocalPublisher)publisher, (LocalSubscriber)subscriber)).whenComplete((participation, ex) -> {
            if (ex == null) {
                this.participationByJid.put(participation.getJid(), (Participation)participation);
                this.cancelTimeoutTask();
            }
        });
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return ((CompletableFuture)super.destroy().thenAccept(x -> this.repository.destroyed(this.jid))).thenAccept(x -> this.cancelTimeoutTask());
    }

    public Participation getParticipation(JID jid) {
        return this.participationByJid.get(jid);
    }

    @Override
    public void left(Participation participation) {
        this.participationByJid.remove(participation.getJid());
        if (this.participationByJid.isEmpty()) {
            this.destroy();
        }
    }

    public boolean hasParticipants() {
        return !this.participationByJid.isEmpty();
    }

    public int getParticipantsCount() {
        return this.participationByJid.size();
    }

    private synchronized void cancelTimeoutTask() {
        TimerTask timerTask = this.timeoutTask;
        this.timeoutTask = null;
        if (timerTask != null) {
            timerTask.cancel();
        }
    }
}

