/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import tigase.meet.AbstractParticipation;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusSession;
import tigase.meet.janus.videoroom.JanusVideoRoomPlugin;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;
import tigase.xmpp.jid.BareJID;

public abstract class AbstractMeet<T extends AbstractParticipation> {
    public static final BareJID ALLOW_EVERYONE = BareJID.bareJIDInstanceNS((String)"*");
    private final Object roomId;
    private final JanusConnection janusConnection;

    public AbstractMeet(JanusConnection janusConnection, Object roomId) {
        this.janusConnection = janusConnection;
        this.roomId = roomId;
    }

    public Object getRoomId() {
        return this.roomId;
    }

    public JanusConnection getJanusConnection() {
        return this.janusConnection;
    }

    protected CompletableFuture<T> join(String displayName, BiFunction<LocalPublisher, LocalSubscriber, T> participationConstructor) {
        return this.janusConnection.createSession().thenCompose(session -> this.createParticipation((JanusSession)session, displayName, participationConstructor).whenComplete((x, ex1) -> {
            if (ex1 != null) {
                session.destroy();
            }
        }));
    }

    protected CompletableFuture<T> createParticipation(JanusSession session, String displayName, BiFunction<LocalPublisher, LocalSubscriber, T> participationConstructor) {
        CompletionStage localPublisherFuture = session.attachPlugin(JanusVideoRoomPlugin.class).thenCompose(plugin -> plugin.createPublisher(this.roomId, displayName));
        CompletionStage localSubscriberFuture = session.attachPlugin(JanusVideoRoomPlugin.class).thenApply(plugin -> plugin.createSubscriber(this.roomId));
        return ((CompletableFuture)localPublisherFuture).thenCombineAsync(localSubscriberFuture, participationConstructor);
    }

    public CompletableFuture<Void> destroy() {
        return ((CompletableFuture)this.janusConnection.createSession().thenCompose(session -> ((CompletableFuture)session.attachPlugin(JanusVideoRoomPlugin.class).thenCompose(plugin -> plugin.destroyRoom(this.roomId))).whenComplete((x, ex) -> {
            if (ex != null) {
                session.destroy();
            }
        }))).thenAccept(x -> this.janusConnection.close());
    }

    public abstract void left(T var1);

    public String toString() {
        return "AbstractMeet{roomId=" + this.roomId + ", janusConnection=" + this.janusConnection + "}";
    }
}

