/*
 * Decompiled with CFR 0.152.
 */
package tigase.extras.bcstarttls;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.KeyExchangeAlgorithm;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import tigase.extras.bcstarttls.Credentials;
import tigase.extras.bcstarttls.CredentialsProvider;
import tigase.extras.bcstarttls.HandshakeCompletedListener;

public class DefaultTls13Server
extends DefaultTlsServer {
    private static final Logger log = Logger.getLogger(DefaultTls13Server.class.getName());
    private final Collection<X500Name> acceptedIssuers;
    private final CredentialsProvider credentialsProvider;
    private final BcTlsCrypto crypto;
    private final HandshakeCompletedListener handshakeCompletedListener;
    private final boolean needClientAuth;
    private final boolean wantClientAuth;
    private List<X500Name> m_clientTrustedIssuers = null;
    private List<Integer> m_peerSigSchemes = null;
    private TlsCredentials m_selectedCredentials = null;
    private Certificate peerCertificate;

    private static boolean matchesIssuers(List<X500Name> issuers, X500Name name) {
        for (X500Name issuer : issuers) {
            if (!name.equals((Object)issuer)) continue;
            return true;
        }
        return false;
    }

    public DefaultTls13Server(BcTlsCrypto crypto, boolean needClientAuth, boolean wantClientAuth, Collection<X500Name> acceptedIssuers, CredentialsProvider credentialsProvider, HandshakeCompletedListener handshakeCompletedListener) {
        super((TlsCrypto)crypto);
        this.crypto = crypto;
        this.handshakeCompletedListener = handshakeCompletedListener;
        this.credentialsProvider = credentialsProvider;
        this.needClientAuth = needClientAuth;
        this.wantClientAuth = wantClientAuth;
        this.acceptedIssuers = acceptedIssuers;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        if (!this.needClientAuth && !this.wantClientAuth) {
            return null;
        }
        short[] certificateTypes = new short[]{1, 2, 64};
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)this.context.getServerVersion())) {
            serverSigAlgs = TlsUtils.getDefaultSupportedSignatureAlgorithms((TlsContext)this.context);
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        if (this.acceptedIssuers != null) {
            certificateAuthorities.addAll(this.acceptedIssuers);
        }
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    public TlsCredentials getCredentials() throws IOException {
        if (this.m_selectedCredentials != null) {
            return this.m_selectedCredentials;
        }
        throw new TlsFatalAlert(80);
    }

    public Certificate getLocalCertificates() {
        return this.credentialsProvider.getCredentials(this.context).getCertificate();
    }

    public int getSelectedCipherSuite() throws IOException {
        Vector clientSigAlgs = this.context.getSecurityParameters().getClientSigAlgs();
        this.m_peerSigSchemes = clientSigAlgs.stream().map(SignatureScheme::from).collect(Collectors.toList());
        return super.getSelectedCipherSuite();
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        this.peerCertificate = clientCertificate;
    }

    public void notifyHandshakeComplete() throws IOException {
        byte[] tlsExporter;
        byte[] tlsUnique;
        super.notifyHandshakeComplete();
        try {
            tlsUnique = this.context.exportChannelBinding(1);
        }
        catch (Exception e) {
            tlsUnique = null;
        }
        try {
            tlsExporter = this.context.exportChannelBinding(3);
        }
        catch (Exception e) {
            tlsExporter = null;
        }
        try {
            log.log(Level.SEVERE, "Handshake complete. tlsUnique=" + (tlsUnique != null) + "; tlsExporter=" + (tlsExporter != null) + "; peerCertificate=" + (this.peerCertificate != null));
            this.handshakeCompletedListener.onHandshakeComplete(this.peerCertificate, tlsUnique, tlsExporter);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Cannot handle handshakeCompleted handler", e);
            throw new TlsFatalAlert(80);
        }
    }

    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        super.processClientExtensions(clientExtensions);
        Vector v = TlsExtensionsUtils.getCertificateAuthoritiesExtension((Hashtable)clientExtensions);
        if (v == null) {
            return;
        }
        this.m_clientTrustedIssuers = v.stream().toList();
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() {
        Credentials credentials = this.credentialsProvider.getCredentials(this.context);
        return new BcDefaultTlsCredentialedDecryptor(this.crypto, credentials.getCertificate(), credentials.getPrivateKey());
    }

    protected TlsCredentialedSigner getRSASignerCredentials() {
        TlsCryptoParameters crpP = new TlsCryptoParameters((TlsContext)this.context);
        SignatureAndHashAlgorithm alg = new SignatureAndHashAlgorithm(2, 1);
        Credentials credentials = this.credentialsProvider.getCredentials(this.context);
        return new BcDefaultTlsCredentialedSigner(crpP, this.crypto, credentials.getPrivateKey(), credentials.getCertificate(), alg);
    }

    protected boolean selectCipherSuite(int cipherSuite) throws IOException {
        TlsCredentials cipherSuiteCredentials = null;
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm((int)cipherSuite);
        if (!KeyExchangeAlgorithm.isAnonymous((int)keyExchangeAlgorithm) && null == (cipherSuiteCredentials = this.selectCredentials(keyExchangeAlgorithm))) {
            return false;
        }
        boolean result = super.selectCipherSuite(cipherSuite);
        if (result) {
            this.m_selectedCredentials = cipherSuiteCredentials;
        }
        return result;
    }

    private TlsCredentials createCredentialedSigner13(SignatureAndHashAlgorithm signatureScheme) {
        if (this.crypto == null) {
            throw new RuntimeException("Crypto in not BcTlsCrypto");
        }
        log.finest(() -> "selected peer sig schema " + signatureScheme);
        Credentials credentials = this.credentialsProvider.getCredentials(this.context);
        return new BcDefaultTlsCredentialedSigner(new TlsCryptoParameters((TlsContext)this.context), this.crypto, credentials.getPrivateKey(), credentials.getCertificate(), signatureScheme);
    }

    private boolean isSuitableCredentials(SignatureAndHashAlgorithm algorithm) throws IOException {
        Credentials credentials = this.credentialsProvider.getCredentials(this.context);
        Certificate certificate = credentials.getCertificate();
        if (certificate.isEmpty()) {
            return false;
        }
        int algId = SignatureScheme.from((SignatureAndHashAlgorithm)algorithm);
        if (!(SignatureScheme.isRSAPSS((int)algId) && credentials.getPrivateKey() instanceof RSAKeyParameters || SignatureScheme.isECDSA((int)algId) && credentials.getPrivateKey() instanceof ECKeyParameters)) {
            return false;
        }
        if (!certificate.getCertificateAt(0).supportsSignatureAlgorithm(SignatureScheme.getSignatureAlgorithm((int)algId))) {
            return false;
        }
        if (this.m_clientTrustedIssuers == null || this.m_clientTrustedIssuers.isEmpty()) {
            return true;
        }
        TlsCertificate[] chain = certificate.getCertificateList();
        int pos = chain.length;
        while (--pos >= 0) {
            X500Name issuer = BcTlsCertificate.convert((BcTlsCrypto)this.crypto, (TlsCertificate)chain[pos]).getCertificate().getIssuer();
            if (!DefaultTls13Server.matchesIssuers(this.m_clientTrustedIssuers, issuer)) continue;
            return true;
        }
        BcTlsCertificate eeCert = BcTlsCertificate.convert((BcTlsCrypto)this.crypto, (TlsCertificate)chain[0]);
        BasicConstraints basicConstraints = BasicConstraints.getInstance((Object)eeCert);
        return basicConstraints != null && basicConstraints.getPathLenConstraint().longValue() > 0L && DefaultTls13Server.matchesIssuers(this.m_clientTrustedIssuers, eeCert.getCertificate().getSubject());
    }

    private TlsCredentials selectCredentials(int keyExchangeAlgorithm) throws IOException {
        return switch (keyExchangeAlgorithm) {
            case 0 -> this.selectServerCredentials13();
            case 5, 19 -> this.getRSASignerCredentials();
            case 3 -> this.getDSASignerCredentials();
            case 17 -> this.getECDSASignerCredentials();
            case 1 -> this.getRSAEncryptionCredentials();
            default -> null;
        };
    }

    private TlsCredentials selectServerCredentials13() throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(() -> "selecting peer sig schema from " + this.m_peerSigSchemes.stream().map(SignatureScheme::getSignatureAndHashAlgorithm).toList());
        }
        SignatureAndHashAlgorithm best = null;
        for (int peerSigScheme : this.m_peerSigSchemes) {
            SignatureAndHashAlgorithm current = SignatureScheme.getSignatureAndHashAlgorithm((int)peerSigScheme);
            if (current == null || !this.isSuitableCredentials(current)) continue;
            best = current;
        }
        if (best != null) {
            return this.createCredentialedSigner13(best);
        }
        return null;
    }
}

