/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.MUCComponent;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.ExtendedMAMRepository;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:message-moderate:0", parent=MUCComponent.class, active=true)
public class MessageModerationModule
extends AbstractMucModule {
    public static final String XMLNS = "urn:xmpp:message-moderate:0";
    public static final String ID = "urn:xmpp:message-moderate:0";
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"apply-to", (String)"urn:xmpp:fasten:0")).add((Criteria)ElementCriteria.name((String)"moderate", (String)"urn:xmpp:message-moderate:0"));
    private static final String[] FEATURES = new String[]{"urn:xmpp:message-moderate:0"};
    @Inject
    private IMucRepository mucRepository;
    @Inject
    private ExtendedMAMRepository mamRepository;
    @Inject
    private GroupchatMessageModule groupchatMessageModule;
    private final TimestampHelper timestampHelper = new TimestampHelper();

    public String[] getFeatures() {
        return FEATURES;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        try {
            if (packet.getType() != StanzaType.set) {
                throw new MUCException(Authorization.BAD_REQUEST, "Invalid packet type.");
            }
            Room room = this.getRoom(packet.getStanzaTo().getBareJID());
            String nickname = room.getOccupantsNickname(packet.getStanzaFrom());
            if (nickname == null) {
                throw new MUCException(Authorization.FORBIDDEN, "You need to be a room occupant");
            }
            if (room.getRole(nickname) != Role.moderator) {
                throw new MUCException(Authorization.FORBIDDEN, "You do not allowed to moderate this room.");
            }
            Element applyTo = packet.getElemChild("apply-to", "urn:xmpp:fasten:0");
            String id = applyTo.getAttributeStaticStr("id");
            if (id == null) {
                throw new MUCException(Authorization.BAD_REQUEST, "Missing stanza id to apply to");
            }
            Element moderate = applyTo.getChildStaticStr("moderate", "urn:xmpp:message-moderate:0");
            Element retract = moderate.getChildStaticStr("retract", "urn:xmpp:message-retract:0");
            if (retract == null) {
                throw new MUCException(Authorization.BAD_REQUEST, "Unknown operation.");
            }
            String reason = moderate.getChildCData(el -> "reason".equals(el.getName()));
            ExtendedMAMRepository.Item item = this.mamRepository.getItem(room.getRoomJID(), id);
            if (item == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "No message with " + id + " to moderate");
            }
            Element message = item.getMessage();
            if (message == null) {
                throw new MUCException(Authorization.UNEXPECTED_REQUEST, "Missing message in the archive");
            }
            Element originalOccupantId = message.findChild(el -> el.getName() == "occupant-id" && el.getXMLNS() == "urn:xmpp:occupant-id:0");
            message.setChildren(Collections.emptyList());
            if (originalOccupantId != null) {
                message.addChild((XMLNodeIfc)originalOccupantId);
            }
            message.withElement("moderated", "urn:xmpp:message-moderate:0", moderated -> {
                moderated.setAttribute("by", JID.jidInstanceNS((BareJID)room.getRoomJID(), (String)nickname).toString());
                moderated.withElement("retracted", "urn:xmpp:message-retract:0", retracted -> retracted.setAttribute("stamp", this.timestampHelper.format(new Date())));
                if (reason != null) {
                    moderated.addChild((XMLNodeIfc)new Element("reason", reason));
                }
            });
            this.mamRepository.updateMessage(room.getRoomJID(), id, message, null);
            Element moderationMessage = new Element("message", new String[]{"id", "type"}, new String[]{UUID.randomUUID().toString(), "groupchat"});
            moderationMessage.withElement("apply-to", "urn:xmpp:fasten:0", applyToResult -> applyToResult.withAttribute("id", id).withElement("moderated", "urn:xmpp:message-moderate:0", moderated -> {
                moderated.setAttribute("by", JID.jidInstanceNS((BareJID)room.getRoomJID(), (String)nickname).toString());
                moderated.addChild((XMLNodeIfc)retract.clone());
                if (reason != null) {
                    moderated.addChild((XMLNodeIfc)new Element("reason", reason));
                }
            }));
            String moderationMsgStableId = UUID.randomUUID().toString();
            this.groupchatMessageModule.addMessageToHistory(room, moderationMessage, null, packet.getStanzaFrom(), null, new Date(), moderationMsgStableId);
            moderationMessage.addChild((XMLNodeIfc)new Element("stanza-id", new String[]{"xmlns", "id", "by"}, new String[]{"urn:xmpp:sid:0", moderationMsgStableId, room.getRoomJID().toString()}));
            this.groupchatMessageModule.sendMessagesToAllOccupants(room, JID.jidInstance((BareJID)room.getRoomJID()), Packet.packetInstance((Element)moderationMessage));
            this.write(packet.okResult((Element)null, 0));
        }
        catch (RepositoryException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Room getRoom(BareJID roomJID) throws MUCException, RepositoryException {
        Room room = this.mucRepository.getRoom(roomJID);
        if (room == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND, "Room does not exist.");
        }
        return room;
    }
}

