/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.util.Date;
import tigase.component.PacketWriter;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.beans.MDRepositoryBean;
import tigase.db.beans.MDRepositoryBeanWithStatistics;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.muc.MUCComponent;
import tigase.muc.Room;
import tigase.muc.history.DerbySqlHistoryProvider;
import tigase.muc.history.ExtendedMAMRepository;
import tigase.muc.history.HistoryProvider;
import tigase.muc.history.MemoryHistoryProvider;
import tigase.muc.history.MySqlHistoryProvider;
import tigase.muc.history.NoneHistoryProvider;
import tigase.muc.history.PostgreSqlHistoryProvider;
import tigase.muc.history.SqlserverSqlHistoryProvider;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.BasicComponent;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;
import tigase.xmpp.mam.QueryImpl;

@Bean(name="historyProviderPool", parent=MUCComponent.class, active=true)
public class HistoryProviderMDBean
extends MDRepositoryBeanWithStatistics<HistoryProvider>
implements HistoryProvider,
ExtendedMAMRepository {
    @ConfigField(desc="Use domain without component name to lookup for repository", alias="map-component-to-bare-domain")
    private boolean mapComponentToBareDomain = false;

    public HistoryProviderMDBean() {
        super(new Class[]{HistoryProvider.class, ExtendedMAMRepository.class});
    }

    public boolean belongsTo(Class<? extends BasicComponent> component) {
        return MUCComponent.class.isAssignableFrom(component);
    }

    public Class<?> getDefaultBeanClass() {
        return HistoryProviderConfigBean.class;
    }

    @Override
    public ExtendedMAMRepository.Item getItem(BareJID owner, String stableId) throws RepositoryException {
        HistoryProvider historyProvider = this.getRepository(owner.getDomain());
        if (historyProvider instanceof ExtendedMAMRepository) {
            return ((ExtendedMAMRepository)((Object)historyProvider)).getItem(owner, stableId);
        }
        throw new RepositoryException("Feature not implemented!");
    }

    @Override
    public void updateMessage(BareJID owner, String stableId, Element msg, String body) throws RepositoryException {
        HistoryProvider historyProvider = this.getRepository(owner.getDomain());
        if (!(historyProvider instanceof ExtendedMAMRepository)) {
            throw new RepositoryException("Feature not implemented!");
        }
        ((ExtendedMAMRepository)((Object)historyProvider)).updateMessage(owner, stableId, msg, body);
    }

    public void setDataSource(DataSource dataSource) {
    }

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
        this.getRepository(room).addJoinEvent(room, date, senderJID, nickName);
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
        this.getRepository(room).addLeaveEvent(room, date, senderJID, nickName);
    }

    @Override
    public void addMessage(Room room, Element message, String body, JID senderJid, String senderNickname, Date time, String stableId) {
        this.getRepository(room).addMessage(room, message, body, senderJid, senderNickname, time, stableId);
    }

    @Override
    public void addMessage(Room room, Element message, String body, JID senderJid, String senderNickname, Date time) {
        this.getRepository(room).addMessage(room, message, body, senderJid, senderNickname, time);
    }

    @Override
    public void addSubjectChange(Room room, Element message, String subject, JID senderJid, String senderNickname, Date time) {
        this.getRepository(room).addSubjectChange(room, message, subject, senderJid, senderNickname, time);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, PacketWriter writer) {
        this.getRepository(room).getHistoryMessages(room, senderJID, maxchars, maxstanzas, seconds, since, writer);
    }

    @Override
    public boolean isPersistent(Room room) {
        return this.getRepository(room).isPersistent(room);
    }

    @Override
    public void removeHistory(Room room) {
        this.getRepository(room).removeHistory(room);
    }

    public void queryItems(Query query, MAMRepository.ItemHandler itemHandler) throws RepositoryException, ComponentException {
        HistoryProvider historyProvider = this.getRepository(query.getComponentJID().getDomain());
        if (!(historyProvider instanceof MAMRepository)) {
            throw new ComponentException(Authorization.FEATURE_NOT_IMPLEMENTED);
        }
        ((MAMRepository)historyProvider).queryItems(query, itemHandler);
    }

    public Query newQuery() {
        return new QueryImpl();
    }

    protected HistoryProvider getRepository(Room room) {
        return this.getRepository(room.getRoomJID().getDomain());
    }

    protected HistoryProvider getRepository(String domain) {
        int idx;
        if (this.mapComponentToBareDomain && (idx = domain.indexOf(".")) > 0) {
            domain = domain.substring(idx + 1);
        }
        return (HistoryProvider)super.getRepository(domain);
    }

    protected Class<? extends HistoryProvider> findClassForDataSource(DataSource dataSource) throws DBInitException {
        return DataSourceHelper.getDefaultClass(HistoryProvider.class, (String)dataSource.getResourceUri());
    }

    public static class HistoryProviderConfigBean
    extends MDRepositoryBean.MDRepositoryConfigBean<HistoryProvider> {
        protected Class<?> getRepositoryClassName() throws DBInitException, ClassNotFoundException {
            String cls = this.getCls();
            if (cls == null) {
                cls = "default";
            }
            switch (cls) {
                case "memory": {
                    return MemoryHistoryProvider.class;
                }
                case "none": {
                    return NoneHistoryProvider.class;
                }
                case "default": {
                    return super.getRepositoryClassName();
                }
                default: {
                    return ModulesManagerImpl.getInstance().forName(cls);
                }
                case "mysql": {
                    return MySqlHistoryProvider.class;
                }
                case "postgresql": {
                    return PostgreSqlHistoryProvider.class;
                }
                case "sqlserver": {
                    return SqlserverSqlHistoryProvider.class;
                }
                case "derby": 
            }
            return DerbySqlHistoryProvider.class;
        }
    }
}

