/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.logging.Level;
import tigase.component.PacketWriter;
import tigase.db.DataRepository;
import tigase.muc.Room;
import tigase.muc.history.AbstractHistoryProvider;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

public abstract class AbstractJDBCHistoryProvider
extends AbstractHistoryProvider<DataRepository> {
    public static final String ADD_MESSAGE_QUERY_KEY = "ADD_MESSAGE_QUERY_KEY";
    public static final String DELETE_MESSAGES_QUERY_KEY = "DELETE_MESSAGES_QUERY_KEY";
    public static final String GET_MESSAGES_MAXSTANZAS_QUERY_KEY = "GET_MESSAGES_MAXSTANZAS_QUERY_KEY";
    public static final String GET_MESSAGES_SINCE_QUERY_KEY = "GET_MESSAGES_SINCE_QUERY_KEY";
    protected DataRepository dataRepository;

    public void setDataSource(DataRepository dataSource) {
        this.dataRepository = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(Room room, Element message, String body, JID senderJid, String senderNickname, Date time) {
        PreparedStatement st = null;
        try {
            PreparedStatement preparedStatement = st = this.dataRepository.getPreparedStatement(null, ADD_MESSAGE_QUERY_KEY);
            synchronized (preparedStatement) {
                st.setString(1, room.getRoomJID().toString());
                st.setLong(2, time == null ? null : Long.valueOf(time.getTime()));
                st.setString(3, senderJid.toString());
                st.setString(4, senderNickname);
                st.setString(5, body);
                st.setBoolean(6, room.getConfig().isLoggingEnabled());
                st.setString(7, message == null ? null : message.toString());
                st.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "Can't add MUC message to database", e);
            throw new RuntimeException(e);
        }
        finally {
            this.dataRepository.release(null, null);
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, PacketWriter writer) {
        block27: {
            String roomJID = room.getRoomJID().toString();
            int maxMessages = room.getConfig().getMaxHistory();
            try {
                PreparedStatement st;
                ResultSet rs;
                block30: {
                    PreparedStatement st2;
                    block29: {
                        PreparedStatement st3;
                        block28: {
                            PreparedStatement st4;
                            rs = null;
                            if (since == null) break block28;
                            if (this.log.isLoggable(Level.FINEST)) {
                                this.log.finest("Using SINCE selector: roomJID=" + roomJID + ", since=" + since.getTime() + " (" + since + ")");
                            }
                            PreparedStatement preparedStatement = st4 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), GET_MESSAGES_SINCE_QUERY_KEY);
                            synchronized (preparedStatement) {
                                try {
                                    st4.setString(1, roomJID);
                                    st4.setLong(2, since.getTime());
                                    st4.setInt(3, maxMessages);
                                    rs = st4.executeQuery();
                                    this.processResultSet(room, senderJID, writer, rs);
                                }
                                catch (Throwable throwable) {
                                    this.dataRepository.release(null, rs);
                                    throw throwable;
                                }
                                this.dataRepository.release(null, rs);
                                break block27;
                            }
                        }
                        if (maxstanzas == null) break block29;
                        if (this.log.isLoggable(Level.FINEST)) {
                            this.log.finest("Using MAXSTANZAS selector: roomJID=" + roomJID + ", maxstanzas=" + maxstanzas);
                        }
                        PreparedStatement preparedStatement = st3 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), GET_MESSAGES_MAXSTANZAS_QUERY_KEY);
                        synchronized (preparedStatement) {
                            try {
                                st3.setString(1, roomJID);
                                st3.setInt(2, Math.min(maxstanzas, maxMessages));
                                rs = st3.executeQuery();
                                this.processResultSet(room, senderJID, writer, rs);
                            }
                            catch (Throwable throwable) {
                                this.dataRepository.release(null, rs);
                                throw throwable;
                            }
                            this.dataRepository.release(null, rs);
                            break block27;
                        }
                    }
                    if (seconds == null) break block30;
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Using SECONDS selector: roomJID=" + roomJID + ", seconds=" + seconds);
                    }
                    PreparedStatement preparedStatement = st2 = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), GET_MESSAGES_SINCE_QUERY_KEY);
                    synchronized (preparedStatement) {
                        try {
                            st2.setString(1, roomJID);
                            st2.setLong(2, new Date().getTime() - (long)(seconds * 1000));
                            st2.setInt(3, maxMessages);
                            rs = st2.executeQuery();
                            this.processResultSet(room, senderJID, writer, rs);
                        }
                        catch (Throwable throwable) {
                            this.dataRepository.release(null, rs);
                            throw throwable;
                        }
                        this.dataRepository.release(null, rs);
                        break block27;
                    }
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Using DEFAULT selector: roomJID=" + roomJID);
                }
                PreparedStatement preparedStatement = st = this.dataRepository.getPreparedStatement(senderJID.getBareJID(), GET_MESSAGES_MAXSTANZAS_QUERY_KEY);
                synchronized (preparedStatement) {
                    try {
                        st.setString(1, roomJID);
                        st.setInt(2, maxMessages);
                        rs = st.executeQuery();
                        this.processResultSet(room, senderJID, writer, rs);
                    }
                    catch (Throwable throwable) {
                        this.dataRepository.release(null, rs);
                        throw throwable;
                    }
                    this.dataRepository.release(null, rs);
                }
            }
            catch (Exception e) {
                if (this.log.isLoggable(Level.SEVERE)) {
                    this.log.log(Level.SEVERE, "Can't get history", e);
                }
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public final boolean isPersistent(Room room) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHistory(Room room) {
        PreparedStatement st = null;
        try {
            PreparedStatement preparedStatement = st = this.dataRepository.getPreparedStatement(null, DELETE_MESSAGES_QUERY_KEY);
            synchronized (preparedStatement) {
                st.setString(1, room.getRoomJID().toString());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Removing history of room " + room.getRoomJID() + " from database.");
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Executing " + st.toString());
                }
                st.executeUpdate();
            }
        }
        catch (SQLException e) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.log(Level.WARNING, "Can't delete MUC messages from database", e);
            }
            throw new RuntimeException(e);
        }
        finally {
            this.dataRepository.release(null, null);
        }
    }

    protected void processResultSet(Room room, JID senderJID, PacketWriter writer, ResultSet rs) throws SQLException, TigaseStringprepException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Select messages for " + senderJID + " from room " + room.getRoomJID());
        }
        boolean addRealJids = this.isAllowedToSeeJIDs(senderJID.getBareJID(), room);
        while (rs.next()) {
            String msgSenderNickname = rs.getString("sender_nickname");
            Date msgTimestamp = new Date(rs.getLong("timestamp"));
            String msgSenderJid = rs.getString("sender_jid");
            String body = rs.getString("body");
            String msg = rs.getString("msg");
            Packet m = this.createMessage(room.getRoomJID(), senderJID, msgSenderNickname, msg, body, msgSenderJid, addRealJids, msgTimestamp, null);
            writer.write(m);
        }
    }
}

