/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.mix.IMixComponent;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.MixLogic;
import tigase.mix.modules.RoomPresenceModule;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.rsm.RSM;

@Bean(name="disco", parent=IMixComponent.class, active=true)
public class DiscoveryModule
extends tigase.pubsub.modules.DiscoveryModule {
    private static final Set<String> FEATURES = Set.of("urn:xmpp:mix:core:1", "urn:xmpp:mix:core:1#searchable", "http://jabber.org/protocol/disco#items", "http://jabber.org/protocol/disco#info", "http://jabber.org/protocol/commands");
    private static final Set<String> FEATURES_WITH_CREATE = Set.of("urn:xmpp:mix:core:1", "urn:xmpp:mix:core:1#searchable", "urn:xmpp:mix:core:1#create-channel", "http://jabber.org/protocol/disco#items", "http://jabber.org/protocol/commands", "http://jabber.org/protocol/disco#info");
    @ConfigField(desc="Allow disco#items for nodes without node attribute set")
    private boolean allowDiscoitems = false;
    @Inject
    private MixLogic mixLogic;
    @Inject
    private IMixRepository mixRepository;
    @Inject
    private IPubSubRepository pubSubRepository;
    @Inject(nullAllowed=true)
    private RoomPresenceModule roomPresenceModule;
    @Inject(nullAllowed=true)
    private AdHocCommandModule adHocCommandModule;

    public Set<String> getAvailableFeatures(BareJID serviceJID, String node, BareJID senderJID) {
        if (serviceJID.getLocalpart() == null) {
            return this.mixLogic.isChannelCreationAllowed(serviceJID, senderJID) ? FEATURES_WITH_CREATE : FEATURES;
        }
        return super.getAvailableFeatures(serviceJID, node, senderJID);
    }

    protected void processDiscoInfo(Packet packet, JID jid, String node, JID senderJID) throws ComponentException, RepositoryException {
        if (node == null && jid.getLocalpart() != null && this.mixRepository.getChannelConfiguration(jid.getBareJID()) == null) {
            throw new ComponentException(Authorization.ITEM_NOT_FOUND);
        }
        super.processDiscoInfo(packet, jid, node, senderJID);
    }

    protected Packet prepareDiscoInfoResponse(Packet packet, JID jid, String node, JID senderJID) {
        if (node == null && jid.getLocalpart() != null) {
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            Packet resultIq = packet.okResult(resultQuery, 0);
            Element mixIdentity = new Element("identity", new String[]{"category", "type"}, new String[]{"conference", "mix"});
            Optional<Element> mucIdentity = Optional.ofNullable(this.roomPresenceModule).map(x -> new Element("identity", new String[]{"category", "type"}, new String[]{"conference", "text"}));
            try {
                Optional.ofNullable(this.mixRepository.getChannelName(jid.getBareJID())).filter(s -> !s.isEmpty()).ifPresent(name -> {
                    mixIdentity.setAttribute("name", name);
                    mucIdentity.ifPresent(identity -> identity.setAttribute("name", name));
                });
            }
            catch (RepositoryException ex) {
                this.log.log(Level.FINEST, "Could not retrieve info for channel " + jid.toString(), ex);
            }
            resultQuery.addChild((XMLNodeIfc)mixIdentity);
            mucIdentity.ifPresent(arg_0 -> ((Element)resultQuery).addChild(arg_0));
            for (String f : this.getAvailableFeatures(jid.getBareJID(), node, senderJID.getBareJID())) {
                resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{f}));
            }
            Element form = this.component.getDiscoExtensionsForm(jid.getDomain());
            if (form != null) {
                resultQuery.addChild((XMLNodeIfc)form);
            }
            return resultIq;
        }
        return super.prepareDiscoInfoResponse(packet, jid, node, senderJID);
    }

    protected List<Element> prepareDiscoItems(JID serviceJID, String nodeName, JID senderJID, RSM rsm) throws ComponentException, RepositoryException {
        if (serviceJID.getLocalpart() == null) {
            List channels = this.getRepository().getServices(BareJID.bareJIDInstanceNS((String)serviceJID.getDomain()), Boolean.valueOf(true));
            if (rsm != null) {
                int i;
                int count = channels.size();
                Integer begin = 0;
                Integer end = count;
                if (rsm.getAfter() != null) {
                    for (i = 0; i < channels.size(); ++i) {
                        if (!rsm.getAfter().equals(((BareJID)channels.get(i)).toString())) continue;
                        begin = i + 1;
                        break;
                    }
                }
                if (rsm.hasBefore()) {
                    if (rsm.getBefore() != null) {
                        for (i = begin.intValue(); i < channels.size(); ++i) {
                            if (!rsm.getBefore().equals(((BareJID)channels.get(i)).toString())) continue;
                            end = i + 1;
                            break;
                        }
                        if (begin < end) {
                            limit = Math.min(rsm.getMax(), end - begin);
                            end = begin + limit;
                        }
                    } else if (begin < count) {
                        limit = Math.min(rsm.getMax(), end - begin);
                        begin = end - limit;
                    }
                }
                channels = begin < end ? channels.subList(begin, end) : Collections.emptyList();
                if (rsm != null && !channels.isEmpty()) {
                    rsm.setResults(Integer.valueOf(count), ((BareJID)channels.get(0)).toString(), ((BareJID)channels.get(channels.size() - 1)).toString());
                    rsm.setIndex(begin);
                }
            }
            return channels.stream().map(channelJID -> {
                Element el = new Element("item", new String[]{"jid"}, new String[]{channelJID.toString()});
                try {
                    Optional.ofNullable(this.mixRepository.getChannelName((BareJID)channelJID)).filter(s -> !s.isEmpty()).ifPresent(name -> el.setAttribute("name", name));
                }
                catch (RepositoryException ex) {
                    this.log.log(Level.FINEST, "could not retrieve channel " + channelJID.toString() + " name", ex);
                }
                return el;
            }).collect(Collectors.toList());
        }
        if (nodeName == null) {
            if (!this.allowDiscoitems) {
                return Collections.emptyList();
            }
            return super.prepareDiscoItems(serviceJID, null, senderJID, rsm);
        }
        if ("mix".equals(nodeName)) {
            return super.prepareDiscoItems(serviceJID, null, senderJID, rsm);
        }
        return super.prepareDiscoItems(serviceJID, nodeName, senderJID, rsm);
    }
}

