/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.modules;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.IMixComponent;
import tigase.mix.model.ChannelConfiguration;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.IParticipant;
import tigase.mix.model.JIDVisibility;
import tigase.mix.model.MixAction;
import tigase.mix.model.MixLogic;
import tigase.mix.model.RoomPresenceRepository;
import tigase.mix.modules.RoomPresenceModule;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IExtenedMAMPubSubRepository;
import tigase.pubsub.utils.executors.Executor;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;

@Bean(name="channelGroupChatMessageModule", parent=IMixComponent.class, active=true)
public class ChannelGroupChatMessageModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_LEAVE = ElementCriteria.nameType((String)"message", (String)"groupchat");
    private static final String[] FEATURES = new String[]{"urn:xmpp:mix:core:1"};
    @Inject
    private MixLogic mixLogic;
    @Inject
    private IMixRepository mixRepository;
    @Inject
    private PublishItemModule publishItemModule;
    @Inject(nullAllowed=true)
    private RoomPresenceRepository roomPresenceRepository;
    @Inject
    private EventBus eventBus;
    @Inject(nullAllowed=true)
    private RoomPresenceModule roomPresenceModule;
    private final TimestampHelper timestampHelper = new TimestampHelper();

    public String[] getFeatures() {
        return FEATURES;
    }

    public Criteria getModuleCriteria() {
        return CRIT_LEAVE;
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        if (packet.getStanzaTo().getLocalpart() == null) {
            throw new PubSubException(Authorization.BAD_REQUEST);
        }
        BareJID channelJID = packet.getStanzaTo().getBareJID();
        BareJID senderJID = packet.getStanzaFrom().getBareJID();
        try {
            IParticipant participant;
            if (this.roomPresenceRepository != null && this.roomPresenceRepository.isParticipant(channelJID, packet.getStanzaFrom())) {
                participant = this.mixRepository.getParticipant(channelJID, this.mixLogic.generateTempParticipantId(channelJID, packet.getStanzaFrom()));
            } else {
                this.mixLogic.checkPermission(channelJID, senderJID, MixAction.publish);
                participant = this.mixRepository.getParticipant(channelJID, senderJID);
            }
            if (participant == null) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            Element retract = packet.getElemChild("retract", "urn:xmpp:mix:misc:0");
            String retractionId = null;
            if (retract != null) {
                boolean isAllowed;
                if (!(this.getRepository() instanceof IExtenedMAMPubSubRepository)) {
                    throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, "Retraction of messages is not supported!");
                }
                retractionId = retract.getAttributeStaticStr("id");
                if (retractionId == null) {
                    throw new PubSubException(Authorization.BAD_REQUEST, "Missing required `id` attribute in `retract` element!");
                }
                ChannelConfiguration config2 = this.mixRepository.getChannelConfiguration(channelJID);
                if (config2.isUserMessageRetraction()) {
                    throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, "Feature not implemented!");
                }
                switch (config2.getAdministratorMessageRetractionRights()) {
                    case owners: {
                        boolean bl = config2.getOwners().contains(senderJID);
                        break;
                    }
                    case admins: {
                        boolean bl;
                        if (config2.getOwners().contains(senderJID) || config2.getAdministrators().contains(senderJID)) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        boolean bl = isAllowed = false;
                    }
                }
                if (!isAllowed) {
                    throw new PubSubException(Authorization.NOT_ALLOWED, "You are not allowed to retract messages in this channel!");
                }
            }
            Element message = packet.getElement().clone();
            String uuid = UUID.randomUUID().toString();
            message.setAttribute("id", uuid);
            message.removeAttribute("to");
            message.setAttribute("from", JID.jidInstanceNS((BareJID)channelJID, (String)participant.getParticipantId()).toString());
            Element mix = new Element("mix");
            mix.setXMLNS("urn:xmpp:mix:core:1");
            if (participant.getNick() != null) {
                mix.withElement("nick", null, participant.getNick());
            }
            if (participant.getRealJid() != null && Optional.ofNullable(this.mixRepository.getChannelConfiguration(channelJID)).filter(config -> config.getJidVisibility() == JIDVisibility.visible).isPresent()) {
                mix.withElement("jid", null, participant.getRealJid().toString());
            }
            message.addChild((XMLNodeIfc)mix);
            message.addChild((XMLNodeIfc)new Element("stanza-id", new String[]{"xmlns", "id", "by"}, new String[]{"urn:xmpp:sid:0", uuid, channelJID.toString()}));
            if (retractionId != null) {
                MAMRepository.Item item = ((IExtenedMAMPubSubRepository)this.getRepository()).getMAMItem(channelJID, "urn:xmpp:mix:nodes:messages", retractionId);
                if (item == null) {
                    throw new PubSubException(Authorization.ITEM_NOT_FOUND, "Message to retract was not found!");
                }
                Element retracted = item.getMessage();
                retracted.setChildren(List.of(new Element("retracted", new String[]{"xmlns", "by", "time"}, new String[]{"urn:xmpp:mix:misc:0", senderJID.toString(), this.timestampHelper.formatWithMs(new Date())})));
                ((IExtenedMAMPubSubRepository)this.getRepository()).updateMAMItem(channelJID, "urn:xmpp:mix:nodes:messages", retractionId, retracted);
            }
            this.getRepository().addMAMItem(channelJID, "urn:xmpp:mix:nodes:messages", uuid, message, null);
            this.eventBus.fire((Object)new PublishItemModule.BroadcastNotificationEvent(this.config.getComponentName(), channelJID, "urn:xmpp:mix:nodes:messages", message));
            this.publishItemModule.broadcastNotification(Executor.Priority.normal, channelJID, "urn:xmpp:mix:nodes:messages", message);
            if (this.roomPresenceModule != null) {
                if (retractionId != null) {
                    Element retraction = message.clone();
                    retraction.setChildren(List.of(new Element("apply-to", new String[]{"id", "xmlns"}, new String[]{retractionId, "urn:xmpp:fasten:0"}).withElement("moderated", "urn:xmpp:moderate:0", moderatedEl -> {
                        moderatedEl.setAttribute("by", JID.jidInstanceNS((BareJID)channelJID, (String)participant.getNick()).toString());
                        moderatedEl.withElement("retract", retractEl -> retractEl.setXMLNS("urn:xmpp:message-retract:0"));
                    })));
                    this.roomPresenceModule.broadcastMessage(channelJID, participant.getNick(), retraction);
                } else {
                    this.roomPresenceModule.broadcastMessage(channelJID, participant.getNick(), message.clone());
                }
            }
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

