/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.model;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum JIDVisibility {
    visible("jid-mandatory-visible", "JID Visible"),
    maybeVisible("jid-optionally-visible", "JID Maybe Visible"),
    hidden("jid-hidden", "JID Hidden");

    public static JIDVisibility[] ALL_VALUES;
    private static Map<String, JIDVisibility> ALL_VALUES_MAP;
    private final String value;
    private final String label;

    public static String[] getOptionValues() {
        return (String[])Arrays.stream(ALL_VALUES).map(JIDVisibility::getValue).toArray(String[]::new);
    }

    public static String[] getOptionLabels() {
        return (String[])Arrays.stream(ALL_VALUES).map(JIDVisibility::getLabel).toArray(String[]::new);
    }

    public static JIDVisibility parse(String str) {
        JIDVisibility result = ALL_VALUES_MAP.get(str);
        if (result == null) {
            throw new IllegalArgumentException("No enum constant " + JIDVisibility.class.getCanonicalName() + "." + str);
        }
        return result;
    }

    private JIDVisibility(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    static {
        ALL_VALUES = (JIDVisibility[])EnumSet.allOf(JIDVisibility.class).toArray(JIDVisibility[]::new);
        ALL_VALUES_MAP = Arrays.stream(ALL_VALUES).collect(Collectors.toMap(JIDVisibility::getValue, Function.identity()));
    }
}

