/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.model;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import tigase.mix.model.ChannelNodePermission;
import tigase.mix.model.JIDVisibility;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.Command;
import tigase.server.DataForm;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class ChannelConfiguration {
    private static final TimestampHelper timestampHelper = new TimestampHelper();
    private static final String[] NODES_PRESENT_OPTIONS = new String[]{"participants", "presence", "information", "allowed", "banned", "jidmap-visible", "avatar"};
    private BareJID lastChangeMadeBy;
    private Set<BareJID> owners = new HashSet<BareJID>();
    private Set<BareJID> administrators = new HashSet<BareJID>();
    private Date endOfLife;
    private String[] nodesPresent = new String[0];
    private ChannelNodePermission messagesNodeSubscription = ChannelNodePermission.participants;
    private ChannelNodePermission presenceNodeSubscription = ChannelNodePermission.participants;
    private ChannelNodePermission participantsNodeSubscription = ChannelNodePermission.participants;
    private ChannelNodePermission informationNodeSubscription = ChannelNodePermission.participants;
    private ChannelNodePermission allowedNodeSubscription = ChannelNodePermission.admins;
    private ChannelNodePermission bannedNodeSubscription = ChannelNodePermission.admins;
    private ChannelNodePermission configurationNodeAccess = ChannelNodePermission.owners;
    private ChannelNodePermission informationNodeUpdateRights = ChannelNodePermission.admins;
    private ChannelNodePermission avatarNodesUpdateRights = ChannelNodePermission.admins;
    private boolean openPresence = false;
    private boolean participantsMustProvidePresence = false;
    private boolean userMessageRetraction = false;
    private ChannelNodePermission administratorMessageRetractionRights = ChannelNodePermission.owners;
    private boolean participantAdditionByInvitation = false;
    private JIDVisibility jidVisibility = JIDVisibility.visible;
    private boolean privateMessages = true;
    private boolean mandatoryNicks = true;

    public static void updateLastChangeMadeBy(Element item, JID publisherJID) {
        Element form = item.getChild("x", "jabber:x:data");
        Element lastChangeMadeByField = form.findChild(el -> el.getName() == "field" && "Last Change Made By".equals(el.getAttributeStaticStr("var")));
        if (lastChangeMadeByField != null) {
            List oldValues = lastChangeMadeByField.findChildren(el -> el.getName() == "value");
            if (oldValues != null) {
                oldValues.forEach(arg_0 -> ((Element)lastChangeMadeByField).removeChild(arg_0));
            }
            lastChangeMadeByField.addChild((XMLNodeIfc)new Element("value", publisherJID.getBareJID().toString()));
        } else {
            DataForm.addFieldValue((Element)form, (String)"Last Change Made By", (String)publisherJID.getBareJID().toString(), (String)"jid-single");
        }
    }

    public ChannelConfiguration() {
    }

    public ChannelConfiguration(Element el) throws PubSubException {
        Element form = el.getChild("x", "jabber:x:data");
        if (form == null || !"urn:xmpp:mix:admin:0".equals(DataForm.getFieldValue((Element)form, (String)"FORM_TYPE"))) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "This is not a valid configuration form!");
        }
        this.applyFrom(form);
    }

    public BareJID getLastChangeMadeBy() {
        return this.lastChangeMadeBy;
    }

    public void setLastChangeMadeBy(BareJID jid) {
        this.lastChangeMadeBy = jid;
    }

    public Set<BareJID> getOwners() {
        return this.owners;
    }

    public void setOwners(Set<BareJID> owners) {
        this.owners = owners == null || owners.isEmpty() ? Collections.emptySet() : owners;
    }

    public boolean isOwner(BareJID jid) {
        return this.owners.contains(jid);
    }

    public boolean isAdministrator(BareJID jid) {
        return this.administrators.contains(jid);
    }

    public Set<BareJID> getAdministrators() {
        return this.administrators;
    }

    public void setAdministrators(Set<BareJID> administrators) {
        this.administrators = administrators == null || administrators.isEmpty() ? Collections.emptySet() : administrators;
    }

    public String[] getNodesPresent() {
        return this.nodesPresent;
    }

    public void setNodesPresent(String[] nodesPresent) {
        this.nodesPresent = nodesPresent;
    }

    public ChannelNodePermission getMessagesNodeSubscription() {
        return this.messagesNodeSubscription;
    }

    public ChannelNodePermission getParticipantsNodeSubscription() {
        return this.participantsNodeSubscription;
    }

    public ChannelNodePermission getInformationNodeSubscription() {
        return this.informationNodeSubscription;
    }

    public ChannelNodePermission getConfigurationNodeAccess() {
        return this.configurationNodeAccess;
    }

    public ChannelNodePermission getInformationNodeUpdateRights() {
        return this.informationNodeUpdateRights;
    }

    public ChannelNodePermission getAvatarNodesUpdateRights() {
        return this.avatarNodesUpdateRights;
    }

    public JIDVisibility getJidVisibility() {
        return this.jidVisibility;
    }

    public boolean isUserMessageRetraction() {
        return this.userMessageRetraction;
    }

    public ChannelNodePermission getAdministratorMessageRetractionRights() {
        return this.administratorMessageRetractionRights;
    }

    public Element toElement(String id) {
        Element item = new Element("item");
        item.setAttribute("id", id);
        item.addChild((XMLNodeIfc)this.toFormElement());
        return item;
    }

    public Element toFormElement() {
        return new DataForm.Builder(Command.DataType.result).withFields(builder -> {
            builder.addField(DataForm.FieldType.Hidden, "FORM_TYPE").setValue("urn:xmpp:mix:admin:0").build();
            builder.addField(DataForm.FieldType.JidSingle, "Last Change Made By").setValue(this.lastChangeMadeBy.toString()).build();
            builder.addField(DataForm.FieldType.JidMulti, "Owner").setRequired(true).setValues((String[])this.owners.stream().map(BareJID::toString).toArray(String[]::new)).build();
            builder.addField(DataForm.FieldType.JidMulti, "Administrator").setValues((String[])this.administrators.stream().map(BareJID::toString).toArray(String[]::new)).build();
            builder.addField(DataForm.FieldType.TextSingle, "End of Life").setValue(Optional.ofNullable(this.endOfLife).map(arg_0 -> ((TimestampHelper)timestampHelper).format(arg_0)).orElse("")).build();
            builder.addField(DataForm.FieldType.ListMulti, "Nodes Present").setOptions(NODES_PRESENT_OPTIONS).setValues(this.nodesPresent).build();
            builder.addField(DataForm.FieldType.ListSingle, "Messages Node Subscription").setOptions((String[])ChannelNodePermission.MESSAGE_NODE_SUBSCRIPTIONS.stream().map(Enum::name).toArray(String[]::new)).setValue(this.messagesNodeSubscription.name()).build();
            builder.addField(DataForm.FieldType.ListSingle, "Presence Node Subscription").setOptions((String[])ChannelNodePermission.PRESENCE_NODE_SUBSCRIPTIONS.stream().map(Enum::name).toArray(String[]::new)).setValue(this.presenceNodeSubscription.name()).build();
            builder.addField(DataForm.FieldType.ListSingle, "Participants Node Subscription").setOptions((String[])ChannelNodePermission.PARTICIPANTS_NODE_SUBSCRIPTIONS.stream().map(Enum::name).toArray(String[]::new)).setValue(this.participantsNodeSubscription.name()).build();
            builder.addField(DataForm.FieldType.ListSingle, "Information Node Subscription").setOptions((String[])ChannelNodePermission.INFORMATION_NODE_SUBSCRIPTIONS.stream().map(Enum::name).toArray(String[]::new)).setValue(this.informationNodeSubscription.name()).build();
            builder.addField(DataForm.FieldType.ListSingle, "Allowed Node Subscription").setOptions((String[])ChannelNodePermission.ALLOWED_NODE_SUBSCRIPTIONS.stream().map(Enum::name).toArray(String[]::new)).setValue(this.allowedNodeSubscription.name()).build();
            builder.addField(DataForm.FieldType.ListSingle, "Banned Node Subscription").setOptions((String[])ChannelNodePermission.BANNED_NODE_SUBSCRIPTIONS.stream().map(Enum::name).toArray(String[]::new)).setValue(this.bannedNodeSubscription.name()).build();
            builder.addField(DataForm.FieldType.ListSingle, "Configuration Node Access").setOptions((String[])ChannelNodePermission.CONFIGURATION_NODE_ACCESS.stream().map(Enum::name).toArray(String[]::new)).setValue(this.configurationNodeAccess.name()).build();
            builder.addField(DataForm.FieldType.ListSingle, "Information Node Update Rights").setOptions((String[])ChannelNodePermission.INFORMATION_NODE_UPDATE_RIGHTS.stream().map(Enum::name).toArray(String[]::new)).setValue(this.informationNodeUpdateRights.name()).build();
            builder.addField(DataForm.FieldType.ListSingle, "Avatar Nodes Update Rights").setOptions((String[])ChannelNodePermission.AVATAR_NODES_UPDATE_RIGHTS.stream().map(Enum::name).toArray(String[]::new)).setValue(this.avatarNodesUpdateRights.name()).build();
            builder.addField(DataForm.FieldType.Boolean, "Open Presence").setValue(Boolean.valueOf(this.openPresence)).build();
            builder.addField(DataForm.FieldType.Boolean, "Participants Must Provide Presence").setValue(Boolean.valueOf(this.participantsMustProvidePresence)).build();
            builder.addField(DataForm.FieldType.Boolean, "User Message Retraction").setValue(Boolean.valueOf(this.userMessageRetraction)).build();
            builder.addField(DataForm.FieldType.ListSingle, "Administrator Message Retraction Rights").setOptions((String[])ChannelNodePermission.ADMINISTRATOR_MESSAGE_RETRACTION_RIGHTS.stream().map(Enum::name).toArray(String[]::new)).setValue(this.administratorMessageRetractionRights.name()).build();
            builder.addField(DataForm.FieldType.Boolean, "Participation Addition by Invitation from Participant").setValue(Boolean.valueOf(this.participantAdditionByInvitation)).build();
            builder.addField(DataForm.FieldType.ListSingle, "JID Visibility").setOptions(JIDVisibility.getOptionValues(), JIDVisibility.getOptionLabels()).setValue(this.jidVisibility.getValue()).build();
            builder.addField(DataForm.FieldType.Boolean, "Private Messages").setValue(Boolean.valueOf(this.privateMessages)).build();
            builder.addField(DataForm.FieldType.Boolean, "Mandatory Nicks").setValue(Boolean.valueOf(this.mandatoryNicks)).build();
        }).build();
    }

    public boolean isNickMandator() {
        return this.mandatoryNicks;
    }

    public boolean arePrivateMessagesAllowed() {
        return this.privateMessages;
    }

    public ChannelConfiguration apply(Element form) throws PubSubException {
        ChannelConfiguration result = new ChannelConfiguration();
        result.applyFrom(form);
        return result;
    }

    protected void applyFrom(Element form) throws PubSubException {
        if (form == null) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "This is not a valid configuration form!");
        }
        if (form.getName() != "x" && form.getXMLNS() != "jabber:x:data") {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "This is not a valid data form form!");
        }
        this.lastChangeMadeBy = ChannelConfiguration.getBareJIDFromField(form, "Last Change Made By", this.lastChangeMadeBy);
        this.owners = ChannelConfiguration.getListOfBareJIDsFromField(form, "Owner", this.owners);
        this.administrators = ChannelConfiguration.getListOfBareJIDsFromField(form, "Administrator", this.administrators);
        this.endOfLife = ChannelConfiguration.getDateFromField(form, "End of Life", this.endOfLife);
        this.nodesPresent = ChannelConfiguration.getFieldValues(form, "Nodes Present", this.nodesPresent);
        HashSet<String> allowedNodes = new HashSet<String>(Arrays.asList(NODES_PRESENT_OPTIONS));
        for (String node : this.nodesPresent) {
            if (allowedNodes.contains(node)) continue;
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Unacceptable value '" + node + "' for present nodes");
        }
        this.messagesNodeSubscription = ChannelConfiguration.getPermissionFromField(form, "Messages Node Subscription", ChannelNodePermission.MESSAGE_NODE_SUBSCRIPTIONS, this.messagesNodeSubscription);
        this.presenceNodeSubscription = ChannelConfiguration.getPermissionFromField(form, "Presence Node Subscription", ChannelNodePermission.PRESENCE_NODE_SUBSCRIPTIONS, this.presenceNodeSubscription);
        this.participantsNodeSubscription = ChannelConfiguration.getPermissionFromField(form, "Participants Node Subscription", ChannelNodePermission.PARTICIPANTS_NODE_SUBSCRIPTIONS, this.participantsNodeSubscription);
        this.informationNodeSubscription = ChannelConfiguration.getPermissionFromField(form, "Information Node Subscription", ChannelNodePermission.INFORMATION_NODE_SUBSCRIPTIONS, this.informationNodeSubscription);
        this.allowedNodeSubscription = ChannelConfiguration.getPermissionFromField(form, "Allowed Node Subscription", ChannelNodePermission.ALLOWED_NODE_SUBSCRIPTIONS, this.allowedNodeSubscription);
        this.bannedNodeSubscription = ChannelConfiguration.getPermissionFromField(form, "Banned Node Subscription", ChannelNodePermission.BANNED_NODE_SUBSCRIPTIONS, this.bannedNodeSubscription);
        this.configurationNodeAccess = ChannelConfiguration.getPermissionFromField(form, "Configuration Node Access", ChannelNodePermission.CONFIGURATION_NODE_ACCESS, this.configurationNodeAccess);
        this.informationNodeUpdateRights = ChannelConfiguration.getPermissionFromField(form, "Information Node Update Rights", ChannelNodePermission.INFORMATION_NODE_UPDATE_RIGHTS, this.informationNodeUpdateRights);
        this.avatarNodesUpdateRights = ChannelConfiguration.getPermissionFromField(form, "Avatar Nodes Update Rights", ChannelNodePermission.AVATAR_NODES_UPDATE_RIGHTS, this.avatarNodesUpdateRights);
        this.openPresence = ChannelConfiguration.getBoolFromField(form, "Open Presence", this.openPresence);
        this.participantsMustProvidePresence = ChannelConfiguration.getBoolFromField(form, "Participants Must Provide Presence", this.participantsMustProvidePresence);
        this.userMessageRetraction = ChannelConfiguration.getBoolFromField(form, "User Message Retraction", this.userMessageRetraction);
        this.administratorMessageRetractionRights = ChannelConfiguration.getPermissionFromField(form, "Administrator Message Retraction Rights", ChannelNodePermission.ADMINISTRATOR_MESSAGE_RETRACTION_RIGHTS, this.administratorMessageRetractionRights);
        this.participantAdditionByInvitation = ChannelConfiguration.getBoolFromField(form, "Participation Addition by Invitation from Participant", this.participantAdditionByInvitation);
        this.jidVisibility = ChannelConfiguration.getJIDVisibilityFromField(form, "JID Visibility", this.jidVisibility);
        this.privateMessages = ChannelConfiguration.getBoolFromField(form, "Private Messages", this.privateMessages);
        this.mandatoryNicks = ChannelConfiguration.getBoolFromField(form, "Mandatory Nicks", this.mandatoryNicks);
        this.validate();
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (PubSubException ex) {
            return false;
        }
    }

    private void validate() throws PubSubException {
        if (this.owners.isEmpty()) {
            throw new PubSubException(Authorization.NOT_ALLOWED, "There MUST be at least one channel owner!");
        }
        if (Arrays.asList(this.nodesPresent).contains("presence")) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Only participants, information, and jidmap nodes are supported!");
        }
        if (this.openPresence) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Open Presence is not supported!");
        }
        if (this.participantsMustProvidePresence) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Support for presences is not implemented yet!");
        }
        if (this.userMessageRetraction) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Message retraction by users is not supported!");
        }
        if (this.participantAdditionByInvitation) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Invitations are not supported!");
        }
        if (this.jidVisibility == JIDVisibility.maybeVisible) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Support for JID Maybe Visible is not implemented yet!");
        }
    }

    private static Element getField(Element form, String fieldName) {
        return form.findChild(el -> el.getName() == "field" && fieldName.equals(el.getAttributeStaticStr("var")));
    }

    private static String getFieldValue(Element field) {
        Element value = field.findChild(el -> el.getName() == "value");
        return value == null ? null : value.getCData();
    }

    private static List<String> getFieldValues(Element field) {
        List values = field.mapChildren(el -> el.getName() == "value", el -> el.getCData());
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }

    private static List<String> getFieldValues(Element form, String fieldName, List<String> defValue) {
        Element field = ChannelConfiguration.getField(form, fieldName);
        if (field == null) {
            return defValue;
        }
        return ChannelConfiguration.getFieldValues(field);
    }

    private static String[] getFieldValues(Element form, String fieldName, String[] defValue) {
        Element field = ChannelConfiguration.getField(form, fieldName);
        if (field == null) {
            return defValue;
        }
        return (String[])ChannelConfiguration.getFieldValues(field).toArray(String[]::new);
    }

    private static boolean getBoolFromField(Element form, String fieldName, boolean defValue) {
        Element field = ChannelConfiguration.getField(form, fieldName);
        if (field == null) {
            return defValue;
        }
        String value = ChannelConfiguration.getFieldValue(field);
        return "true".equals(value) || "1".equals(value);
    }

    private static JIDVisibility getJIDVisibilityFromField(Element form, String fieldName, JIDVisibility defValue) throws PubSubException {
        Element field = ChannelConfiguration.getField(form, fieldName);
        if (field == null) {
            return defValue;
        }
        String value = ChannelConfiguration.getFieldValue(field);
        if (value == null) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Missing value for field " + fieldName);
        }
        if ((value = value.trim()).isEmpty()) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Missing value for field " + fieldName);
        }
        try {
            return JIDVisibility.parse(value);
        }
        catch (IllegalArgumentException ex) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Invalid value 'value' for field " + fieldName);
        }
    }

    private static ChannelNodePermission getPermissionFromField(Element form, String fieldName, List<ChannelNodePermission> acceptedValues, ChannelNodePermission defValue) throws PubSubException {
        Element field = ChannelConfiguration.getField(form, fieldName);
        if (field == null) {
            return defValue;
        }
        String value = ChannelConfiguration.getFieldValue(field);
        if (value == null) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Missing value for field " + fieldName);
        }
        if ((value = value.trim()).isEmpty()) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Missing value for field " + fieldName);
        }
        try {
            return ChannelNodePermission.valueOf(value);
        }
        catch (IllegalArgumentException ex) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Invalid value 'value' for field " + fieldName);
        }
    }

    private static Date getDateFromField(Element form, String fieldName, Date defValue) throws PubSubException {
        try {
            Element field = ChannelConfiguration.getField(form, fieldName);
            if (field == null) {
                return defValue;
            }
            String value = ChannelConfiguration.getFieldValue(field);
            if (value == null) {
                return null;
            }
            if ((value = value.trim()).isEmpty()) {
                return null;
            }
            return timestampHelper.parseTimestamp(value);
        }
        catch (ParseException ex) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Incorrect date in field " + fieldName, (Exception)ex);
        }
    }

    private static BareJID getBareJIDFromField(Element form, String fieldName, BareJID defValue) throws PubSubException {
        try {
            Element field = ChannelConfiguration.getField(form, fieldName);
            if (field == null) {
                return defValue;
            }
            return ChannelConfiguration.convertStringToBareJID(ChannelConfiguration.getFieldValue(field));
        }
        catch (TigaseStringprepException ex) {
            throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Incorrect JID in field " + fieldName, (Exception)((Object)ex));
        }
    }

    private static Set<BareJID> getListOfBareJIDsFromField(Element form, String fieldName, Set<BareJID> defValue) throws PubSubException {
        Element field = ChannelConfiguration.getField(form, fieldName);
        if (field == null) {
            return defValue;
        }
        List<String> values = ChannelConfiguration.getFieldValues(field);
        HashSet<BareJID> result = new HashSet<BareJID>();
        for (String value : values) {
            try {
                BareJID jid = ChannelConfiguration.convertStringToBareJID(value);
                if (jid == null) continue;
                result.add(jid);
            }
            catch (TigaseStringprepException ex) {
                throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Incorrect JID '" + value + "' in field " + fieldName, (Exception)((Object)ex));
            }
        }
        return result;
    }

    private static BareJID convertStringToBareJID(String value) throws TigaseStringprepException {
        if (value == null) {
            return null;
        }
        String tmp = value.trim();
        if (tmp.isEmpty()) {
            return null;
        }
        return BareJID.bareJIDInstance((String)tmp);
    }
}

