/*
 * Decompiled with CFR 0.152.
 */
package tigase.spam.filters;

import java.util.logging.Level;
import tigase.server.Packet;
import tigase.spam.SpamFilter;
import tigase.stats.StatisticsList;
import tigase.xmpp.XMPPResourceConnection;

public abstract class AbstractSpamFilter
implements SpamFilter {
    private long avgProcessingTime = 0L;
    private long filteredMessages = 0L;
    private long spamMessages = 0L;
    private long totalProcessingTime = 0L;

    @Override
    public boolean filter(Packet packet, XMPPResourceConnection session) {
        long start = System.currentTimeMillis();
        ++this.filteredMessages;
        boolean result = this.filterPacket(packet, session);
        long time = System.currentTimeMillis() - start;
        this.avgProcessingTime = (this.avgProcessingTime + time) / 2L;
        this.totalProcessingTime += time;
        if (!result) {
            ++this.spamMessages;
        }
        return result;
    }

    @Override
    public void getStatistics(String name, StatisticsList list) {
        if (list.checkLevel(Level.FINE)) {
            list.add(name, this.getId() + "/Filtered packets", this.filteredMessages, Level.FINE);
            list.add(name, this.getId() + "/Spam messages", this.spamMessages, Level.FINE);
            list.add(name, this.getId() + "/Average processing time", this.avgProcessingTime, Level.FINE);
            list.add(name, this.getId() + "/Total processing time", this.totalProcessingTime, Level.FINE);
        }
    }

    protected abstract boolean filterPacket(Packet var1, XMPPResourceConnection var2);

    public String toString() {
        return this.getId();
    }
}

