/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.rtbl;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import tigase.server.rtbl.RTBLRepository;
import tigase.util.Algorithms;
import tigase.xmpp.jid.BareJID;

public class RTBL {
    private static final Logger logger = Logger.getLogger(RTBL.class.getCanonicalName());
    private final RTBLRepository.Key key;
    private final String hash;
    private final CopyOnWriteArraySet<String> blockedHashes;

    public RTBL(RTBLRepository.Key key, String hash) {
        this(key, hash, new CopyOnWriteArraySet<String>());
    }

    public RTBL(RTBLRepository.Key key, String hash, Set<String> hashes) {
        this.key = key;
        this.hash = hash;
        this.blockedHashes = new CopyOnWriteArraySet<String>(hashes);
    }

    public RTBL(BareJID jid, String node, String hash, Set<String> hashes) {
        this(new RTBLRepository.Key(jid, node), hash, hashes);
    }

    public BareJID getJID() {
        return this.key.getJid();
    }

    public String getNode() {
        return this.key.getNode();
    }

    public RTBLRepository.Key getKey() {
        return this.key;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isBlocked(BareJID jid) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.hash);
            if (this.isBlocked(jid.getDomain(), md)) {
                return true;
            }
            md.reset();
            if (this.isBlocked(jid.toString(), md)) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.warning("No hashing mechanism " + this.hash + " required by RTBL (" + this.key + ")");
        }
        return false;
    }

    private boolean isBlocked(String jid, MessageDigest md) {
        String hash = Algorithms.bytesToHex((byte[])md.digest(jid.getBytes(StandardCharsets.UTF_8)));
        return this.blockedHashes.contains(hash);
    }

    public Set<String> getBlocked() {
        return this.blockedHashes;
    }

    public String toString() {
        return this.key.toString() + ", hash: " + this.hash + ", blocked: " + this.blockedHashes;
    }
}

