/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.importexport;

import java.io.Writer;
import java.nio.file.Path;
import java.util.Map;
import java.util.logging.Logger;
import tigase.db.UserRepository;
import tigase.db.util.importexport.AbstractImporterExtension;
import tigase.db.util.importexport.ImporterExtension;
import tigase.db.util.importexport.RepositoryManagerExtensionBase;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

public class JabberIqPrivateExtension
extends RepositoryManagerExtensionBase {
    private static final Logger log = Logger.getLogger(JabberIqPrivateExtension.class.getSimpleName());

    @Override
    public void exportDomainData(String domain, Writer writer) throws Exception {
    }

    @Override
    public void exportUserData(Path userDirPath, BareJID user, Writer writer) throws Exception {
        UserRepository userRepository = this.getRepository(UserRepository.class, user.getDomain());
        String[] keys = userRepository.getKeys(user, "jabber:iq:private");
        if (keys != null) {
            writer.append("<query xmlns='jabber:iq:private'>");
            for (String key : keys) {
                String data = userRepository.getData(user, key);
                if (data == null) continue;
                writer.append(data);
            }
            writer.append("</query>");
        }
    }

    @Override
    public ImporterExtension startImportUserData(BareJID userJid, String name, Map<String, String> attrs) throws Exception {
        if ("query".equals(name) && "jabber:iq:private".equals(attrs.get("xmlns"))) {
            log.finest("importing user " + userJid + " jabber:iq:private...");
            return new JabberIqPrivateImporterExtension(this.getRepository(UserRepository.class, userJid.getDomain()), userJid);
        }
        return null;
    }

    public static class JabberIqPrivateImporterExtension
    extends AbstractImporterExtension {
        private final UserRepository userRepository;
        private final BareJID user;

        public JabberIqPrivateImporterExtension(UserRepository userRepository, BareJID user) {
            this.userRepository = userRepository;
            this.user = user;
        }

        @Override
        public boolean handleElement(Element item) throws Exception {
            this.userRepository.setData(this.user, "jabber:iq:private", item.getName() + item.getXMLNS(), item.toString());
            return true;
        }
    }
}

