/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.importexport;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.db.AbstractAuthRepositoryWithCredentials;
import tigase.db.AuthRepository;
import tigase.db.UserRepository;
import tigase.db.util.importexport.ImportXMLHandler;
import tigase.db.util.importexport.ImporterExtension;
import tigase.db.util.importexport.RepositoryHolder;
import tigase.db.util.importexport.RepositoryManagerExtension;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostJDBCRepository;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class Importer {
    private static final Logger log = Logger.getLogger(Importer.class.getSimpleName());
    private static final SimpleParser parser = new SimpleParser();
    private final RepositoryHolder repositoryHolder;
    private final VHostJDBCRepository vhostRepository;
    private final Path rootPath;
    private State state = State.begining;
    private String domain;
    private BareJID user;
    private Stack<Element> readElements = new Stack();
    private Stack<String> elementStack = new Stack();
    private final List<RepositoryManagerExtension> extensions;
    private ImporterExtension activeExtension = null;
    private int usersCount = 0;

    public Importer(RepositoryHolder repositoryHolder, VHostJDBCRepository vhostRepository, List<RepositoryManagerExtension> extensions, Path rootPath) {
        this.repositoryHolder = repositoryHolder;
        this.vhostRepository = vhostRepository;
        this.rootPath = rootPath;
        this.extensions = extensions;
    }

    protected void startElement(String name, Map<String, String> attrs) {
        boolean handled;
        block36: {
            this.elementStack.push(name);
            if (name.equals("xi:include")) {
                String path = attrs.get("href");
                try {
                    this.process(this.rootPath.resolve(path));
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
            switch (this.state) {
                case begining: {
                    boolean ex;
                    boolean bl = ex = (switch (name) {
                        case "server-data" -> {
                            this.state = State.serverData;
                            yield true;
                        }
                        default -> false;
                    });
                    break;
                }
                case serverData: {
                    boolean ex;
                    boolean bl = ex = (switch (name) {
                        case "host" -> {
                            this.state = State.host;
                            this.domain = attrs.get("jid");
                            this.usersCount = 0;
                            log.info("importing domain " + this.domain + " data...");
                            if (this.vhostRepository.getItem(this.domain) == null) {
                                VHostItem item = this.vhostRepository.getItemInstance();
                                item.setKey(this.domain);
                                this.vhostRepository.addItem(item);
                            }
                            yield true;
                        }
                        default -> false;
                    });
                    break;
                }
                case host: {
                    boolean ex;
                    boolean bl = ex = (switch (name) {
                        case "user" -> {
                            boolean var7_13;
                            this.state = State.user;
                            this.user = BareJID.bareJIDInstanceNS((String)attrs.get("name"), (String)this.domain);
                            log.info("importing user " + this.user + " data...");
                            try {
                                UserRepository userRepository = this.repositoryHolder.getRepository(UserRepository.class, this.user.getDomain());
                                if (!userRepository.userExists(this.user)) {
                                    userRepository.addUser(this.user);
                                }
                                AuthRepository.AccountStatus accountStatus = Optional.ofNullable(attrs.get("tigase:status")).map(AuthRepository.AccountStatus::valueOf).orElse(AuthRepository.AccountStatus.active);
                                AuthRepository authRepository = this.repositoryHolder.getRepository(AbstractAuthRepositoryWithCredentials.class, this.user.getDomain());
                                authRepository.setAccountStatus(this.user, accountStatus);
                            }
                            catch (Throwable ex) {
                                throw new RuntimeException(ex);
                            }
                            yield var7_13 = true;
                        }
                        default -> {
                            boolean var7_13;
                            yield var7_13 = false;
                        }
                    });
                    break;
                }
                default: {
                    boolean ex;
                    boolean bl = handled = (ex = false);
                }
            }
            if (!handled) {
                try {
                    if (this.activeExtension == null) {
                        for (RepositoryManagerExtension extension : this.extensions) {
                            this.activeExtension = this.extensionStartImport(extension, name, attrs);
                            if (this.activeExtension == null) continue;
                            handled = true;
                            break block36;
                        }
                        break block36;
                    }
                    handled = this.activeExtension.startElement(name, attrs);
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if (!handled) {
            Element el = new Element(name);
            el.setAttributes(attrs);
            this.readElements.push(el);
        }
    }

    private ImporterExtension extensionStartImport(RepositoryManagerExtension extension, String name, Map<String, String> attrs) throws Exception {
        return switch (this.state) {
            case State.host -> extension.startImportDomainData(this.domain, name, attrs);
            case State.user -> extension.startImportUserData(this.user, name, attrs);
            default -> null;
        };
    }

    protected void elementCData(String cdata) {
        if (!this.readElements.isEmpty()) {
            this.readElements.peek().addCData(cdata);
        }
    }

    private boolean processReadElement(ThrowingFunction<Element, Boolean> func) throws Exception {
        if (this.readElements.size() == 1) {
            Element el = this.readElements.pop();
            return func.apply(el);
        }
        return false;
    }

    protected boolean endElement(String name) {
        try {
            if (name.equals(this.elementStack.peek())) {
                if (name.equals("xi:include")) {
                    this.elementStack.pop();
                    return true;
                }
                if (this.activeExtension != null) {
                    boolean handled = this.activeExtension.endElement(name);
                    if (!handled) {
                        if (!this.readElements.isEmpty()) {
                            Element el = this.readElements.pop();
                            if (this.readElements.isEmpty()) {
                                if (!this.activeExtension.handleElement(el)) {
                                    log.warning("read unknown element: " + el);
                                }
                            } else {
                                this.readElements.peek().addChild((XMLNodeIfc)el);
                            }
                        } else {
                            this.activeExtension.close();
                            this.activeExtension = null;
                        }
                    }
                } else {
                    boolean handled;
                    block1 : switch (this.state) {
                        case serverData: {
                            boolean bl;
                            switch (name) {
                                case "server-data": {
                                    this.state = State.begining;
                                    bl = true;
                                    break block1;
                                }
                            }
                            bl = false;
                            break;
                        }
                        case host: {
                            boolean bl;
                            switch (name) {
                                case "host": {
                                    this.state = State.serverData;
                                    log.info("imported domain " + this.domain + " with " + this.usersCount + " users");
                                    this.usersCount = 0;
                                    this.domain = null;
                                    bl = true;
                                    break block1;
                                }
                            }
                            bl = false;
                            break;
                        }
                        case user: {
                            boolean bl;
                            switch (name) {
                                case "user": {
                                    this.state = State.host;
                                    log.fine("imported user " + this.user);
                                    ++this.usersCount;
                                    this.user = null;
                                    bl = true;
                                    break block1;
                                }
                                case "query": {
                                    bl = this.processReadElement(query -> switch (query.getXMLNS()) {
                                        case "jabber:iq:roster" -> {
                                            this.saveRoster((Element)query);
                                            yield true;
                                        }
                                        default -> false;
                                    });
                                    break block1;
                                }
                                case "vCard": {
                                    bl = this.processReadElement(vcard -> switch (vcard.getXMLNS()) {
                                        case "vcard-temp" -> {
                                            UserRepository userRepository = this.repositoryHolder.getRepository(UserRepository.class, this.user.getDomain());
                                            userRepository.setData(this.user, "public/vcard-temp", "vCard", vcard.toString());
                                            yield true;
                                        }
                                        default -> false;
                                    });
                                    break block1;
                                }
                            }
                            bl = false;
                            break;
                        }
                        default: {
                            boolean bl = handled = false;
                        }
                    }
                    if (!handled && !this.readElements.isEmpty()) {
                        String el = this.readElements.pop();
                        if (!this.readElements.isEmpty()) {
                            Element parentEl = this.readElements.peek();
                            if (parentEl != null) {
                                parentEl.addChild((XMLNodeIfc)el);
                            }
                        } else {
                            log.warning("read unknown element: " + (Element)el);
                        }
                    }
                }
                this.elementStack.pop();
                return true;
            }
            log.severe("found close tag for " + name + " without start element at: " + this.elementStack.stream().toList());
            return false;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private void saveRoster(Element query) throws Exception {
        List children = query.findChildren(el -> "item".equals(el.getName()));
        ArrayList<RosterElement> roster = new ArrayList<RosterElement>();
        if (children != null) {
            for (Element child : children) {
                List groups = child.mapChildren(el -> "group".equals(el.getName()), el -> el.getCData());
                RosterElement re = new RosterElement(JID.jidInstanceNS((String)child.getAttributeStaticStr("jid")), child.getAttributeStaticStr("name"), groups == null ? null : (String[])groups.toArray(String[]::new));
                re.setSubscription(Importer.subscriptionType(child));
                Optional.ofNullable(child.getChild("channel", "urn:xmpp:mix:roster:0")).map(el -> el.getAttributeStaticStr("participant-id")).ifPresent(re::setMixParticipantId);
                roster.add(re);
            }
        }
        String rosterStr = roster.stream().map(RosterElement::getRosterElement).map(Element::toString).collect(Collectors.joining());
        UserRepository userRepository = this.repositoryHolder.getRepository(UserRepository.class, this.user.getDomain());
        if (rosterStr.isEmpty()) {
            userRepository.removeData(this.user, "roster");
        } else {
            userRepository.setData(this.user, "roster", rosterStr);
        }
        log.finest("importing user " + this.user + " roster...");
    }

    private static RosterAbstract.SubscriptionType subscriptionType(Element rosterItem) {
        return Importer.subscriptionType(rosterItem.getAttributeStaticStr("subscription"), rosterItem.getAttributeStaticStr("ask"), Boolean.parseBoolean(rosterItem.getAttributeStaticStr("approved")));
    }

    private static RosterAbstract.SubscriptionType subscriptionType(String subscr, String ask, boolean approved) {
        RosterAbstract.SubscriptionType type = RosterAbstract.SubscriptionType.none;
        if (subscr != null) {
            try {
                type = RosterAbstract.SubscriptionType.valueOf(subscr);
                boolean subscribe = "subscribe".equals(ask);
                if (approved) {
                    type = switch (type) {
                        case RosterAbstract.SubscriptionType.to -> RosterAbstract.SubscriptionType.to_pre_approved;
                        case RosterAbstract.SubscriptionType.none -> {
                            if (subscribe) {
                                yield RosterAbstract.SubscriptionType.none_pending_out_pre_approved;
                            }
                            yield RosterAbstract.SubscriptionType.none_pre_approved;
                        }
                        default -> type;
                    };
                }
                type = switch (type) {
                    case RosterAbstract.SubscriptionType.none -> RosterAbstract.SubscriptionType.none_pending_out;
                    case RosterAbstract.SubscriptionType.from -> RosterAbstract.SubscriptionType.from_pending_out;
                    default -> type;
                };
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return type;
    }

    public void process(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            this.process(reader);
        }
    }

    public void process(BufferedReader reader) throws IOException {
        ImportXMLHandler importXMLHandler = new ImportXMLHandler(this);
        while (reader.ready()) {
            String data = reader.readLine();
            parser.parse((SimpleHandler)importXMLHandler, data);
        }
    }

    static enum State {
        begining,
        serverData,
        host,
        user;

    }

    static interface ThrowingFunction<IN, OUT> {
        public OUT apply(IN var1) throws Exception;
    }
}

