/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import tigase.auth.SaslInvalidLoginExcepion;
import tigase.auth.XmppSaslException;
import tigase.auth.callbacks.AuthorizationIdCallback;
import tigase.auth.callbacks.ReplaceServerKeyCallback;
import tigase.auth.callbacks.ServerKeyCallback;
import tigase.auth.mechanisms.AbstractSasl;

public class SaslXTOKEN
extends AbstractSasl {
    public static final String NAME = "XTOKEN-HMAC-SHA-256";
    private static final SecureRandom secureRandom = new SecureRandom();
    private Step step = Step.firstMessage;

    public static byte[] generateSecretKey() {
        byte[] data = new byte[32];
        secureRandom.nextBytes(data);
        return data;
    }

    SaslXTOKEN(Map<? super String, ?> props, CallbackHandler callbackHandler) {
        super(props, callbackHandler);
    }

    @Override
    public String getMechanismName() {
        return NAME;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (response.length <= 64 || response[32] != 0 || response[65] != 0) {
            throw new XmppSaslException(XmppSaslException.SaslError.malformed_request, "Invalid token format - too short");
        }
        byte[] data = Arrays.copyOfRange(response, 0, 32);
        byte[] token = Arrays.copyOfRange(response, 33, 65);
        String authcid = new String(Arrays.copyOfRange(response, 66, response.length), StandardCharsets.UTF_8);
        NameCallback nc = new NameCallback("Authentication identity", authcid);
        AuthorizationIdCallback ai = new AuthorizationIdCallback("Authorization identity", null);
        ServerKeyCallback vtc = new ServerKeyCallback(null);
        this.handleCallbacks(nc, ai, vtc);
        if (vtc.getServerKey() == null) {
            throw new SaslInvalidLoginExcepion(XmppSaslException.SaslError.not_authorized, nc.getName(), PASSWORD_NOT_VERIFIED_MSG);
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(vtc.getServerKey(), "SHA-256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKeySpec);
            byte[] hmac = mac.doFinal(data);
            boolean proofMatch = Arrays.equals(hmac, token);
            if (!proofMatch) {
                throw new SaslInvalidLoginExcepion(XmppSaslException.SaslError.not_authorized, authcid, PASSWORD_NOT_VERIFIED_MSG);
            }
            String authorizationJID = ai.getAuthzId() == null ? nc.getName() : ai.getAuthzId();
            AuthorizeCallback ac = new AuthorizeCallback(nc.getName(), authorizationJID);
            this.handleCallbacks(ac);
            if (!ac.isAuthorized()) {
                throw new SaslInvalidLoginExcepion(XmppSaslException.SaslError.invalid_authzid, nc.getName(), this.getMechanismName() + ": " + authcid + " is not authorized to act as " + authorizationJID);
            }
            this.authorizedId = ac.getAuthorizedID();
            ReplaceServerKeyCallback rtc = new ReplaceServerKeyCallback();
            this.handleCallbacks(rtc);
            this.complete = true;
            byte[] authzidData = this.authorizedId.getBytes(StandardCharsets.UTF_8);
            if (rtc.getNewServerKey() != null) {
                byte[] result = new byte[authzidData.length + 1 + rtc.getNewServerKey().length];
                System.arraycopy(authzidData, 0, result, 0, authzidData.length);
                result[authzidData.length] = 0;
                System.arraycopy(rtc.getNewServerKey(), 0, result, authzidData.length + 1, rtc.getNewServerKey().length);
                return result;
            }
            return authzidData;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new SaslInvalidLoginExcepion(XmppSaslException.SaslError.invalid_authzid, nc.getName(), this.getMechanismName() + ": " + ex.getMessage());
        }
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizedId;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return null;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return null;
    }

    static enum Step {
        firstMessage,
        secondMessage,
        finished;

    }
}

