/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.mechanisms;

import java.util.Collection;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import tigase.auth.mechanisms.AbstractSaslSCRAM;
import tigase.xmpp.XMPPResourceConnection;

public class SaslSCRAMPlus
extends AbstractSaslSCRAM {
    public static final String NAME = "SCRAM-SHA-1-PLUS";
    protected static final String ALGO = "SHA1";

    public static boolean containsScramPlus(Collection<String> mechanisms) {
        for (String name : mechanisms) {
            if (!name.startsWith("SCRAM-") || !name.endsWith("-PLUS")) continue;
            return true;
        }
        return false;
    }

    public static boolean isAvailable(XMPPResourceConnection session) {
        return session.getSessionData("TLS_UNIQUE_ID_KEY") != null || session.getSessionData("LOCAL_CERTIFICATE_KEY") != null;
    }

    public SaslSCRAMPlus(Map<? super String, ?> props, CallbackHandler callbackHandler) {
        super(NAME, ALGO, props, callbackHandler);
    }

    SaslSCRAMPlus(Map<? super String, ?> props, CallbackHandler callbackHandler, String once) {
        super(NAME, ALGO, props, callbackHandler, once);
    }

    @Override
    protected void checkRequestedBindType(AbstractSaslSCRAM.BindType requestedBindType) throws SaslException {
        switch (requestedBindType) {
            case n: {
                throw new SaslException("Invalid request for SCRAM-SHA-1-PLUS");
            }
            case y: {
                throw new SaslException("Server supports PLUS. Please use 'p'");
            }
        }
    }
}

