/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.impl;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import tigase.auth.AuthRepositoryAware;
import tigase.auth.DomainAware;
import tigase.auth.SessionAware;
import tigase.auth.XmppSaslException;
import tigase.auth.callbacks.AuthorizationIdCallback;
import tigase.auth.callbacks.ReplaceServerKeyCallback;
import tigase.auth.callbacks.ServerKeyCallback;
import tigase.auth.credentials.Credentials;
import tigase.auth.credentials.entries.XTokenCredentialsEntry;
import tigase.auth.mechanisms.AbstractSasl;
import tigase.auth.mechanisms.SaslXTOKEN;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.BareJID;

public class XTokenCallbackHandler
implements CallbackHandler,
AuthRepositoryAware,
DomainAware,
SessionAware {
    protected String domain;
    protected BareJID jid = null;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected AuthRepository repo;
    private boolean loggingInForbidden = false;
    private XMPPResourceConnection session;
    private String credentialId;
    private XTokenCredentialsEntry entry;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Callback: {0}", callbacks[i].getClass().getSimpleName());
            }
            this.handleCallback(callbacks[i]);
        }
    }

    @Override
    public void setAuthRepository(AuthRepository repo) {
        this.repo = repo;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public void setSession(XMPPResourceConnection session) {
        this.session = session;
    }

    protected void handleAuthorizeCallback(AuthorizeCallback authCallback) {
        String authenId = authCallback.getAuthenticationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authenId: {0}", authenId);
        }
        if (this.loggingInForbidden) {
            authCallback.setAuthorized(false);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "User {0} is disabled", this.jid);
            }
            return;
        }
        String authorId = authCallback.getAuthorizationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authorId: {0}", authorId);
        }
        authCallback.setAuthorized(true);
        this.session.removeSessionData("authentication-jid");
    }

    protected void handleCallback(Callback callback) throws UnsupportedCallbackException, IOException {
        if (callback instanceof RealmCallback) {
            this.handleRealmCallback((RealmCallback)callback);
        } else if (callback instanceof NameCallback) {
            this.handleNameCallback((NameCallback)callback);
        } else if (callback instanceof AuthorizationIdCallback) {
            this.handleAuthorizationIdCallback((AuthorizationIdCallback)callback);
        } else if (callback instanceof ServerKeyCallback) {
            this.handleServerKeyCallback((ServerKeyCallback)callback);
        } else if (callback instanceof AuthorizeCallback) {
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        } else if (callback instanceof ReplaceServerKeyCallback) {
            this.handleReplaceServerKeyCallback((ReplaceServerKeyCallback)callback);
        } else {
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }

    protected void handleNameCallback(NameCallback nc) throws IOException {
        this.credentialId = "default";
        BareJID jid = BareJID.bareJIDInstanceNS((String)nc.getDefaultName());
        if (jid.getLocalpart() == null || !this.domain.equalsIgnoreCase(jid.getDomain())) {
            jid = BareJID.bareJIDInstanceNS((String)nc.getDefaultName(), (String)this.domain);
        }
        this.setJid(jid);
        nc.setName(jid.toString());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "NameCallback: {0}", this.credentialId);
        }
    }

    protected void handleRealmCallback(RealmCallback rc) throws IOException {
        String realm = this.domain;
        if (realm != null) {
            rc.setText(realm);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "RealmCallback: {0}", realm);
        }
    }

    protected void handleServerKeyCallback(ServerKeyCallback pc) throws IOException {
        try {
            Credentials credentials = this.repo.getCredentials(this.jid, this.credentialId);
            this.log.log(Level.FINE, "Fetched credentials for: " + this.jid + " with credentialsId: " + this.credentialId + ", credentials: " + credentials);
            this.entry = (XTokenCredentialsEntry)credentials.getEntryForMechanism("XTOKEN-HMAC-SHA-256");
            boolean bl = this.loggingInForbidden = !credentials.canLogin();
            if (this.loggingInForbidden) {
                throw XmppSaslException.getExceptionFor(credentials.getAccountStatus());
            }
            pc.setServerKey(this.entry.getSecretKey());
        }
        catch (SaslException e) {
            this.log.log(Level.FINE, "User inactive: " + e);
            throw e;
        }
        catch (Exception ex) {
            this.log.log(Level.FINE, "Could not retrieve credentials for user " + this.jid + " with credentialId " + this.credentialId, ex);
        }
    }

    private void handleAuthorizationIdCallback(AuthorizationIdCallback callback) throws XmppSaslException {
        if (!AbstractSasl.isAuthzIDIgnored() && callback.getAuthzId() != null && !callback.getAuthzId().equals(this.jid.toString())) {
            try {
                this.credentialId = this.jid.getLocalpart();
                this.setJid(BareJID.bareJIDInstance((String)callback.getAuthzId()));
            }
            catch (TigaseStringprepException ex) {
                this.log.warning("Malformed AuthorizationId: " + ex.getMessage());
                throw new XmppSaslException(XmppSaslException.SaslError.invalid_authzid);
            }
        } else {
            this.credentialId = "default";
            callback.setAuthzId(this.jid.toString());
        }
    }

    private void handleReplaceServerKeyCallback(ReplaceServerKeyCallback callback) throws XmppSaslException {
        try {
            byte[] data = SaslXTOKEN.generateSecretKey();
            this.repo.updateCredential(this.jid, this.credentialId, "XTOKEN", "t=" + Base64.encode((byte[])data) + ",o=false");
            callback.setNewServerKey(data);
        }
        catch (TigaseDBException e) {
            throw new XmppSaslException(XmppSaslException.SaslError.temporary_auth_failure);
        }
    }

    private void setJid(BareJID jid) {
        this.jid = jid;
        if (jid != null) {
            this.session.putSessionData("authentication-jid", jid);
        }
    }
}

