/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.mam.util;

import java.io.Writer;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.util.importexport.Exporter;
import tigase.server.Message;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.ExtendedQuery;
import tigase.xmpp.mam.MAMItemHandler;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.Query;

public class MAMRepositoryManagerExtensionHelper {
    private static Logger log = Logger.getLogger(MAMRepositoryManagerExtensionHelper.class.getCanonicalName());

    public static void exportDataFromRepository(MAMRepository mamRepository, BareJID repoJID, BareJID askingJID, Writer archiveWriter) throws Exception {
        MAMRepositoryManagerExtensionHelper.exportDataFromRepository(mamRepository, repoJID, askingJID, null, archiveWriter);
    }

    public static void exportDataFromRepository(MAMRepository mamRepository, BareJID repoJID, BareJID askingJID, final BiConsumer<MAMRepository.Item, Element> outputModifier, final Writer archiveWriter) throws Exception {
        archiveWriter.append("<archive xmlns='urn:xmpp:pie:0#mam' xmlns:xi='http://www.w3.org/2001/XInclude'>");
        Object query = mamRepository.newQuery(repoJID);
        query.setComponentJID(JID.jidInstance((BareJID)repoJID));
        query.setQuestionerJID(JID.jidInstance((BareJID)askingJID));
        query.setXMLNS("urn:xmpp:mam:2");
        Exporter.getExportMAMSinceValue().ifPresent(arg_0 -> query.setStart(arg_0));
        query.getRsm().setMax(Exporter.getExportMAMBatchSize().intValue());
        final AtomicReference lastItem = new AtomicReference();
        int batchNo = 0;
        Integer itemsToExport = null;
        while (true) {
            mamRepository.queryItems(query, new MAMItemHandler(){

                @Override
                public void itemFound(Query query, MAMRepository.Item item) {
                    lastItem.set(item);
                    Element result = this.prepareResult(query, item);
                    if (result != null) {
                        if (outputModifier != null) {
                            outputModifier.accept(item, result);
                        }
                        try {
                            archiveWriter.append(result.toString());
                        }
                        catch (Throwable ex) {
                            log.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                }
            });
            if (lastItem.get() == null) break;
            if (itemsToExport == null) {
                itemsToExport = query.getRsm().getCount();
            }
            if (itemsToExport != null) {
                int completed = Math.min(++batchNo * Exporter.getExportMAMBatchSize(), itemsToExport);
                int percent = completed * 100 / itemsToExport;
                if (batchNo > 1 || percent < 100) {
                    log.info("exported MAM archive for " + repoJID + " batch no. " + batchNo + ", " + percent + "%...");
                }
            }
            if (query instanceof ExtendedQuery) {
                ExtendedQuery extendedQuery = (ExtendedQuery)query;
                extendedQuery.setAfterId(((MAMRepository.Item)lastItem.get()).getId());
            } else {
                query.getRsm().setAfter(((MAMRepository.Item)lastItem.get()).getId());
            }
            lastItem.set(null);
        }
        archiveWriter.append("</archive>");
    }

    public static abstract class AbstractImporterExtension
    extends tigase.db.util.importexport.AbstractImporterExtension {
        @Override
        public boolean handleElement(Element element) throws Exception {
            if (!"result".equals(element.getName())) {
                return false;
            }
            String stanzaId = Optional.ofNullable(element.getAttributeStaticStr("id")).orElseThrow();
            Element forwardedEl = Optional.ofNullable(element.findChild(el -> "forwarded".equals(el.getName()) && "urn:xmpp:forward:0".equals(el.getXMLNS()))).orElseThrow();
            Element messageEl = Optional.ofNullable(forwardedEl.findChild(el -> "message".equals(el.getName()))).orElseThrow();
            Date timestamp = Optional.ofNullable(forwardedEl.findChild(el -> "delay".equals(el.getName()) && "urn:xmpp:delay".equals(el.getXMLNS()))).map(delay -> delay.getAttributeStaticStr("stamp")).map(this::parseTimestamp).orElseThrow();
            Message message = new Message(messageEl);
            return this.handleMessage(message, stanzaId, timestamp, element);
        }

        protected abstract boolean handleMessage(Message var1, String var2, Date var3, Element var4) throws Exception;
    }
}

