/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.push;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.cluster.strategy.ConnectionRecordIfc;
import tigase.component.PacketWriter;
import tigase.db.AuthRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.map.ClusterMapFactory;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.util.cache.LRUConcurrentCache;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.vhosts.VHostItemImpl;
import tigase.xml.Element;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.impl.JabberIqPrivacy;
import tigase.xmpp.impl.annotation.AnnotatedXMPPProcessor;
import tigase.xmpp.impl.push.AbstractPushNotifications;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="push-presence", parent=SessionManager.class, active=false)
public class PushPresence
extends AnnotatedXMPPProcessor
implements Initializable,
UnregisterAware {
    private static final Logger log = Logger.getLogger(PushPresence.class.getCanonicalName());
    @ConfigField(desc="Presence show value for accounts with push devices")
    private PresenceStatus presenceStatus = PresenceStatus.xa;
    @ConfigField(desc="Push presence resource name")
    private String resourceName = "push";
    @Inject
    private AuthRepository authRepository;
    @Inject
    private UserRepository userRepository;
    @Inject
    private EventBus eventBus;
    @Inject
    private AbstractPushNotifications pushNotifications;
    @Inject(bean="sess-man")
    private SessionManagerHandler sessionManager;
    @Inject
    private PacketWriter packetWriter;
    @Inject(nullAllowed=true)
    private ClusteringStrategyIfc<ConnectionRecordIfc> strategy;
    private Map<BareJID, Boolean> pushAvailability;
    private final JID offlineConnectionId = JID.jidInstanceNS((String)"push-offline-conn", (String)DNSResolverFactory.getInstance().getDefaultHost());
    private final LRUConcurrentCache<BareJID, Set<BareJID>> rosterSubscribedFromCache = new LRUConcurrentCache(10000);
    private final SessionManagerHandler offlineSessionManagerHandler = new SessionManagerHandler(){

        @Override
        public JID getComponentId() {
            return null;
        }

        @Override
        public void handleLogin(BareJID userId, XMPPResourceConnection conn) {
        }

        @Override
        public void handleDomainChange(String domain, XMPPResourceConnection conn) {
        }

        @Override
        public void handleLogout(BareJID userId, XMPPResourceConnection conn) {
        }

        @Override
        public void handlePresenceSet(XMPPResourceConnection conn) {
        }

        @Override
        public void handleResourceBind(XMPPResourceConnection conn) {
        }

        @Override
        public boolean isLocalDomain(String domain, boolean includeComponents) {
            return false;
        }
    };
    private RosterAbstract rosterUtil = RosterFactory.getRosterImplementation(true);

    @Override
    public void initialize() {
        this.pushAvailability = ClusterMapFactory.get().createMap("push-availability", BareJID.class, Boolean.class, new String[0]);
        this.pushNotifications.setPushDevicesPresence(this);
        if (this.eventBus != null) {
            this.eventBus.registerAll(this);
        }
    }

    @Override
    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll(this);
        }
    }

    protected void setRosterUtil(RosterAbstract rosterUtil) {
        this.rosterUtil = rosterUtil;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    protected boolean isPushAvailable(BareJID userJid) throws TigaseDBException {
        Boolean value = this.pushAvailability.get(userJid);
        if (value == null) {
            value = !this.pushNotifications.getPushServices(userJid).isEmpty();
            this.pushAvailability.put(userJid, value);
        }
        return value;
    }

    private boolean shouldNodeGeneratePresence(BareJID userJid) {
        if (this.strategy == null) {
            return true;
        }
        Set<ConnectionRecordIfc> records = this.strategy.getConnectionRecords(userJid);
        if (records != null) {
            ArrayList<String> nodes = new ArrayList<String>();
            nodes.add(this.sessionManager.getComponentId().getDomain());
            for (ConnectionRecordIfc record : records) {
                String node = record.getNode().getDomain();
                if (nodes.contains(node)) continue;
                nodes.add(node);
            }
            nodes.sort(String::compareTo);
            String selectedNode = (String)nodes.get(userJid.hashCode() % nodes.size());
            return this.sessionManager.getComponentId().getDomain().equals(selectedNode);
        }
        return true;
    }

    public void processPresenceToOffline(JID recipient, JID sender, StanzaType stanzaType, Consumer<Packet> packetConsumer) {
        if (stanzaType != StanzaType.probe) {
            return;
        }
        this.processPresenceProbe(recipient, sender, packetConsumer);
    }

    public void processPresenceProbe(JID recipient, JID sender, Consumer<Packet> packetConsumer) {
        if (recipient == null || recipient.getResource() != null || sender == null) {
            return;
        }
        try {
            if (!this.isPushAvailable(recipient.getBareJID())) {
                return;
            }
            if (!this.shouldNodeGeneratePresence(recipient.getBareJID())) {
                return;
            }
            if (!this.getSubscribedWithFrom(recipient.getBareJID()).contains(sender.getBareJID())) {
                return;
            }
            this.sendPresenceFormPushDevices(recipient.getBareJID(), true, List.of(sender.getBareJID()), packetConsumer);
        }
        catch (TigaseDBException ex) {
            log.log(Level.FINEST, "failed to fetch push devices for jid " + recipient.getBareJID(), ex);
        }
    }

    private Packet createPresenceForPushDevices(boolean hasPushDevices) throws TigaseStringprepException {
        Element presenceEl = new Element("presence", new Element[]{new Element("priority", "-1")}, null, null);
        presenceEl.setXMLNS("jabber:client");
        if (!hasPushDevices) {
            presenceEl.setAttribute("type", StanzaType.unavailable.toString());
        } else {
            switch (this.presenceStatus) {
                case unavailable: {
                    presenceEl.setAttribute("type", StanzaType.unavailable.name());
                    break;
                }
                case available: {
                    break;
                }
                default: {
                    presenceEl.withElement("show", null, this.presenceStatus.name());
                }
            }
        }
        return Packet.packetInstance(presenceEl);
    }

    private void sendPresenceFormPushDevices(BareJID userJid, boolean hasPushDevices, Collection<BareJID> recipients, Consumer<Packet> packetConsumer) {
        try {
            JID from = JID.jidInstance((BareJID)userJid, (String)this.resourceName);
            Packet presence = this.createPresenceForPushDevices(hasPushDevices);
            for (BareJID jid : recipients) {
                Packet clone = presence.copyElementOnly();
                clone.initVars(from, JID.jidInstance((BareJID)jid));
                packetConsumer.accept(clone);
            }
        }
        catch (TigaseStringprepException ex) {
            log.log(Level.FINEST, "failed to prepare JID for push presence", ex);
        }
    }

    public void broadcastPresenceFromPushDevices(BareJID userJid, boolean hasPushDevices, Consumer<Packet> packetConsumer) {
        this.sendPresenceFormPushDevices(userJid, hasPushDevices, this.getSubscribedWithFrom(userJid), packetConsumer);
    }

    public void pushAvailabilityChanged(BareJID userJid, boolean newValue, Consumer<Packet> packetConsumer) {
        this.pushAvailability.put(userJid, newValue);
        this.broadcastPresenceFromPushDevices(userJid, newValue, packetConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BareJID> getSubscribedWithFrom(BareJID userJid) {
        CopyOnWriteArraySet<BareJID> jids = (CopyOnWriteArraySet<BareJID>)this.rosterSubscribedFromCache.get((Object)userJid);
        if (jids == null) {
            jids = new CopyOnWriteArraySet<BareJID>();
            this.rosterSubscribedFromCache.put((Object)userJid, jids);
            CopyOnWriteArraySet<BareJID> copyOnWriteArraySet = jids;
            synchronized (copyOnWriteArraySet) {
                XMPPResourceConnection session = this.createOfflineXMPPResourceConnection(userJid);
                try {
                    JID[] buddies = this.rosterUtil.getBuddies(session, RosterAbstract.FROM_SUBSCRIBED);
                    if (buddies != null) {
                        for (JID buddy : buddies) {
                            jids.add(buddy.getBareJID());
                        }
                    }
                }
                catch (TigaseDBException | NotAuthorizedException ex) {
                    log.log(Level.FINEST, "failed to fetch buddies subscribed 'from' for jid " + userJid, ex);
                }
            }
        }
        return jids;
    }

    @HandleEvent
    public void handleRosterModified(RosterAbstract.RosterModifiedEvent event) {
        block10: {
            BareJID userJid = event.getUserJid().getBareJID();
            if (!this.shouldNodeGeneratePresence(userJid)) {
                return;
            }
            try {
                if (this.isPushAvailable(userJid)) {
                    Set jids = (Set)this.rosterSubscribedFromCache.get((Object)userJid);
                    switch (event.getSubscription()) {
                        case from: 
                        case from_pending_out: 
                        case both: {
                            if (jids != null) {
                                jids.add(event.getJid().getBareJID());
                            }
                            this.sendPresenceFormPushDevices(userJid, true, List.of(event.getJid().getBareJID()), this.packetWriter::write);
                            break;
                        }
                        case to: 
                        case none: {
                            if (jids != null) {
                                jids.remove(event.getJid().getBareJID());
                            }
                            this.sendPresenceFormPushDevices(userJid, false, List.of(event.getJid().getBareJID()), this.packetWriter::write);
                        }
                    }
                }
            }
            catch (TigaseDBException ex) {
                if (!log.isLoggable(Level.FINEST)) break block10;
                log.log(Level.FINEST, "failed to check for registered push devices for user " + userJid, ex);
            }
        }
    }

    private XMPPResourceConnection createOfflineXMPPResourceConnection(BareJID userJid) {
        try {
            JabberIqPrivacy.OfflineResourceConnection session = new JabberIqPrivacy.OfflineResourceConnection(this.offlineConnectionId, this.userRepository, this.authRepository, this.offlineSessionManagerHandler);
            VHostItemImpl vhost = new VHostItemImpl(userJid.getDomain());
            session.setDomain(vhost);
            session.authorizeJID(userJid, false);
            XMPPSession parentSession = new XMPPSession(userJid.getLocalpart());
            session.setParentSession(parentSession);
            return session;
        }
        catch (TigaseStringprepException ex) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "creation of temporary session for offline user " + userJid + " failed", ex);
            }
            return null;
        }
    }

    static enum PresenceStatus {
        chat,
        available,
        away,
        xa,
        dnd,
        unavailable;

    }
}

