/*
 * Decompiled with CFR 0.152.
 */
package tigase.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import tigase.map.CollectionWrapper;
import tigase.map.SetWrapper;

class DMap<K, V>
implements Map<K, V> {
    final Class<K> keyClass;
    final DMapListener listener;
    final ConcurrentHashMap<K, V> map = new ConcurrentHashMap();
    final String uid;
    final Class<V> valueClass;

    public DMap(String uid, DMapListener listener, Class<K> keyClass, Class<V> valueClass) {
        this.listener = listener;
        this.uid = uid;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    @Override
    public void clear() {
        this.listener.onClear(this);
        this.map.clear();
    }

    public void clearNoEvent() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new SetWrapper<Map.Entry<K, V>>(this.map.entrySet());
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    public String getUid() {
        return this.uid;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new SetWrapper(this.map.keySet());
    }

    @Override
    public V put(K key, V value) {
        this.listener.onPut(this, key, value);
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.listener.onPutAll(this, m);
        this.map.putAll(m);
    }

    public void putNoEvent(K key, V value) {
        this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.listener.onRemove(this, key);
        return this.map.remove(key);
    }

    public V removeNoEvent(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Collection<V> values() {
        return new CollectionWrapper<V>(this.map.values());
    }

    static interface DMapListener {
        public void onClear(DMap var1);

        public void onPut(DMap var1, Object var2, Object var3);

        public void onPutAll(DMap var1, Map<?, ?> var2);

        public void onRemove(DMap var1, Object var2);
    }
}

