/*
 * Decompiled with CFR 0.152.
 */
package tigase.kernel.core;

import java.util.logging.Logger;
import tigase.kernel.KernelException;
import tigase.kernel.beans.BeanFactory;
import tigase.kernel.core.BeanConfig;
import tigase.kernel.core.DependencyManager;
import tigase.kernel.core.Kernel;

public class BeanConfigBuilder {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final String beanName;
    private final DependencyManager dependencyManager;
    private final Kernel kernel;
    private BeanConfig beanConfig;
    private Object beanInstance;
    private Class<?> clazz;
    private BeanConfig factoryBeanConfig;

    BeanConfigBuilder(Kernel kernel, DependencyManager dependencyManager, String beanName) {
        this.kernel = kernel;
        this.dependencyManager = dependencyManager;
        this.beanName = beanName;
    }

    public BeanConfigBuilder asClass(Class<?> cls) {
        this.clazz = cls;
        if (this.beanConfig != null) {
            this.throwException(new KernelException("Class or instance is already defined for bean '" + this.beanName + "'"));
        }
        this.beanConfig = this.dependencyManager.createBeanConfig(this.kernel, this.beanName, cls);
        return this;
    }

    public BeanConfigBuilder asInstance(Object bean) {
        if (this.beanConfig != null) {
            this.throwException(new KernelException("Class or instance is already defined for bean '" + this.beanName + "'"));
        }
        this.beanConfig = this.dependencyManager.createBeanConfig(this.kernel, this.beanName, bean.getClass());
        this.beanInstance = bean;
        return this;
    }

    public void exec() {
        this.execWithoutInject();
        this.kernel.registerLinks(this.beanName);
        this.kernel.injectIfRequired(this.beanConfig);
    }

    public BeanConfig execWithoutInject() {
        if (this.beanConfig == null) {
            this.log.warning("Bean " + this.clazz + " cannot be registered, because Kernel cannot create configuration for this bean.");
            this.kernel.currentlyUsedConfigBuilder = null;
            return null;
        }
        this.beanConfig = this.kernel.registerBean(this.beanConfig, this.factoryBeanConfig, this.beanInstance);
        return this.beanConfig;
    }

    public BeanConfigBuilder exportable() {
        if (this.beanConfig == null) {
            this.log.warning("Bean " + this.clazz + " cannot be configured as exportable, because Kernel cannot create configuration for this bean." + this);
        }
        this.beanConfig.setExportable(true);
        return this;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public BeanConfigBuilder setActive(boolean active) {
        if (this.beanConfig != null) {
            if (active) {
                this.beanConfig.setState(null);
            } else {
                this.beanConfig.setState(BeanConfig.State.inactive);
            }
        }
        return this;
    }

    public BeanConfigBuilder setPinned(boolean pinned) {
        if (this.beanConfig != null) {
            this.beanConfig.setPinned(pinned);
        }
        return this;
    }

    public BeanConfigBuilder setSource(BeanConfig.Source source) {
        if (this.beanConfig != null) {
            this.beanConfig.setSource(source);
        }
        return this;
    }

    public BeanConfigBuilder registeredBy(BeanConfig parent) {
        if (parent != null && this.beanConfig != null) {
            this.beanConfig.addRegisteredBy(parent);
        }
        return this;
    }

    public BeanConfigBuilder withFactory(Class<? extends BeanFactory> beanFactoryClass) {
        if (this.beanInstance != null) {
            this.throwException(new KernelException("Cannot register factory to bean '" + this.beanName + "' registered as instance."));
        }
        if (this.factoryBeanConfig != null) {
            this.throwException(new KernelException("Factory for bean '" + this.beanName + "' is already registered."));
        }
        this.factoryBeanConfig = this.dependencyManager.createBeanConfig(this.kernel, this.beanName + "#FACTORY", beanFactoryClass);
        this.beanConfig.setFactory(this.factoryBeanConfig);
        return this;
    }

    protected void throwException(KernelException e) {
        this.kernel.currentlyUsedConfigBuilder = null;
        throw e;
    }
}

