/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import tigase.annotations.TigaseDeprecated;
import tigase.cert.CertificateEntry;
import tigase.io.CertificateContainer;

public interface CertificateContainerIfc {
    public static final String CERTIFICATE_CONTAINER_CLASS_KEY = "cert-container-class";
    public static final String CERTIFICATE_CONTAINER_CLASS_VAL = CertificateContainer.class.getCanonicalName();

    @Deprecated
    @TigaseDeprecated(since="8.4.0", removeIn="9.0.0", note="Method with tigase.io.CertificateContainerIfc.CertificateEntity should be used")
    public void addCertificates(Map<String, String> var1) throws CertificateParsingException;

    public void addCertificates(CertificateEntity var1) throws CertificateParsingException;

    public KeyManager[] createCertificate(String var1) throws NoSuchAlgorithmException, CertificateException, SignatureException, NoSuchProviderException, InvalidKeyException, IOException, UnrecoverableKeyException, KeyStoreException;

    public String getDefCertAlias();

    public CertificateEntry getCertificateEntry(String var1);

    public KeyManager[] getKeyManagers(String var1);

    public TrustManager[] getTrustManagers();

    public KeyStore getTrustStore();

    public void init(Map<String, Object> var1);

    public record CertificateEntity(String certificatePem, String alias, boolean storePermanently, boolean useAsDefault) {
        public CertificateEntity {
            Objects.requireNonNull(certificatePem);
            Objects.requireNonNull(alias);
        }

        CertificateEntity withAlias(String alias) {
            return new CertificateEntity(this.certificatePem, alias, this.storePermanently, this.useAsDefault);
        }

        CertificateEntity withDefaultAlias() {
            return new CertificateEntity(this.certificatePem, "default", this.storePermanently, this.useAsDefault);
        }
    }
}

