/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util.importexport;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.jdbc.DataRepositoryImpl;
import tigase.db.util.SchemaManager;

public class DataSourceHelper {
    private final Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private final Map<String, SchemaManager.DataSourceInfo> dataSourceInfos;

    public DataSourceHelper(List<SchemaManager.DataSourceInfo> dataSourceInfos) {
        this.dataSourceInfos = dataSourceInfos.stream().collect(Collectors.toMap(SchemaManager.DataSourceInfo::getName, Function.identity()));
    }

    public DataSource getDefault() throws RepositoryException {
        return this.get("default");
    }

    public DataSource get(String name) throws RepositoryException {
        SchemaManager.DataSourceInfo info = this.dataSourceInfos.get(name);
        if (info == null) {
            int idx = name.indexOf(46);
            if (idx > 0) {
                return this.get(name.substring(idx + 1));
            }
            return this.getDefault();
        }
        return this.get(info);
    }

    public DataSource get(SchemaManager.DataSourceInfo dataSourceInfo) throws RepositoryException {
        DataSource dataSource = this.dataSourceMap.get(dataSourceInfo.getName());
        if (dataSource == null) {
            dataSource = new DataRepositoryImpl();
            dataSource.initialize(dataSourceInfo.getResourceUri());
            this.dataSourceMap.put(dataSourceInfo.getName(), dataSource);
        }
        return dataSource;
    }

    public <R> R createRepository(SchemaManager.RepoInfo repoInfo) throws RepositoryException, InstantiationException, IllegalAccessException {
        DataSource dataSource = this.get(repoInfo.getDataSource().getName());
        Object repo = repoInfo.getImplementation().newInstance();
        ((DataSourceAware)repo).setDataSource(dataSource);
        return (R)repo;
    }
}

