/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.util;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.auth.CredentialsDecoderBean;
import tigase.auth.CredentialsEncoderBean;
import tigase.component.DSLBeanConfigurator;
import tigase.conf.ConfigBuilder;
import tigase.conf.ConfigHolder;
import tigase.conf.ConfigWriter;
import tigase.db.AbstractAuthRepositoryWithCredentials;
import tigase.db.AuthRepository;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.util.DBSchemaLoader;
import tigase.db.util.SchemaManager;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.core.Kernel;
import tigase.osgi.util.ClassUtilBean;
import tigase.util.Version;
import tigase.util.reflection.ReflectionHelper;
import tigase.util.ui.console.CommandlineParameter;
import tigase.util.ui.console.ParameterParser;
import tigase.xmpp.jid.BareJID;

public abstract class SchemaLoader<P extends Parameters> {
    protected static final Logger log = Logger.getLogger(SchemaLoader.class.getName());
    private String type;

    private static List<CommandlineParameter> getDbTypeDependentParameters(String type) {
        SchemaLoader loader = SchemaLoader.newInstance(type);
        return loader.getCommandlineParameters();
    }

    public static List<CommandlineParameter> getMainCommandlineParameters(boolean forceNotRequired) {
        String[] supportedTypes = (String[])SchemaLoader.getAllSupportedTypesStream().map(TypeInfo::getName).sorted().toArray(String[]::new);
        return Arrays.asList(new CommandlineParameter.Builder("T", DBSchemaLoader.PARAMETERS_ENUM.DATABASE_TYPE.getName()).description("Database server type").options(supportedTypes).valueDependentParametersProvider(SchemaLoader::getDbTypeDependentParameters).required(!forceNotRequired).build());
    }

    public static Stream<TypeInfo> getAllSupportedTypesStream() {
        return SchemaLoader.getSchemaLoaderInstances().map(SchemaLoader::getSupportedTypes).flatMap(Collection::stream).map(TypeInfo.class::cast).sorted();
    }

    public static List<TypeInfo> getAllSupportedTypes() {
        List<TypeInfo> supportedTypes = SchemaLoader.getAllSupportedTypesStream().collect(Collectors.toList());
        log.log(Level.WARNING, "All supported types: " + supportedTypes);
        return supportedTypes;
    }

    public static Optional<TypeInfo> getSupportedTypeForName(String name) {
        if (name == null) {
            return SchemaLoader.getDefaultSupportedTypeForName();
        }
        return SchemaLoader.getAllSupportedTypesStream().filter(type -> type.getName().equals(name)).findAny();
    }

    public static Optional<TypeInfo> getDefaultSupportedTypeForName() {
        return SchemaLoader.getAllSupportedTypesStream().findFirst();
    }

    private static Stream<Class<?>> getSchemaLoaderClasses() {
        return ClassUtilBean.getInstance().getAllClasses().stream().filter(SchemaLoader.class::isAssignableFrom).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers()));
    }

    private static Stream<SchemaLoader> getSchemaLoaderInstances() {
        return SchemaLoader.getSchemaLoaderClasses().map(clazz -> {
            SchemaLoader loader = null;
            try {
                loader = (SchemaLoader)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.log(Level.WARNING, "Error creating instance", e);
            }
            return loader;
        }).filter(Objects::nonNull);
    }

    public static void main(String[] args) {
        ParameterParser parser = new ParameterParser(true);
        parser.addOptions(SchemaLoader.getMainCommandlineParameters(false));
        Properties properties = null;
        if (null == args || args.length == 0 || (properties = parser.parseArgs(args)) == null) {
            System.out.println(parser.getHelp());
            System.exit(0);
        } else {
            System.out.println("properties: " + properties);
        }
        String type = properties.getProperty(DBSchemaLoader.PARAMETERS_ENUM.DATABASE_TYPE.getName());
        SchemaLoader dbHelper = SchemaLoader.newInstance(type);
        Object params = dbHelper.createParameters();
        params.setProperties(properties);
        dbHelper.execute((Parameters)params);
    }

    public static SchemaLoader newInstance(String type) {
        if (type == null) {
            throw new RuntimeException("Missing dbType property");
        }
        SchemaLoader schemaLoader = SchemaLoader.getSchemaLoaderInstances().filter(instance -> instance.isSupported(type)).findAny().get();
        schemaLoader.setType(type);
        return schemaLoader;
    }

    public static SchemaLoader newInstanceForURI(String uri) {
        int idx = uri.indexOf(":");
        if (idx < 0) {
            throw new RuntimeException("Unsupported URI");
        }
        String type = uri.substring(0, idx);
        if ("jdbc".equals(type) || "jtds".equals(type)) {
            return SchemaLoader.newInstanceForURI(uri.substring(idx + 1));
        }
        return SchemaLoader.newInstance(type);
    }

    public abstract P createParameters();

    public abstract void execute(Parameters var1);

    public abstract void init(P var1, Optional<SchemaManager.RootCredentialsCache> var2);

    public void init(P props) {
        this.init(props, Optional.empty());
    }

    public abstract List<TypeInfo> getSupportedTypes();

    public boolean isSupported(String dbType) {
        return this.getSupportedTypes().stream().map(TypeInfo::getName).anyMatch(typeName -> typeName.equals(dbType));
    }

    public abstract String getDBUri();

    public abstract List<CommandlineParameter> getSetupOptions();

    public abstract List<CommandlineParameter> getCommandlineParameters();

    public abstract Result validateDBConnection();

    public abstract Result validateDBExists();

    public abstract Result postInstallation();

    protected String getConfigString() throws IOException {
        String dataSourceUri = this.getDBUri();
        ConfigBuilder builder = new ConfigBuilder();
        builder.withBean(ds -> ds.name("dataSource").withBean(def -> def.name("default").with("uri", dataSourceUri)));
        try (StringWriter writer = new StringWriter();){
            new ConfigWriter().write(writer, (Map<String, Object>)builder.build());
            String string = writer.toString();
            return string;
        }
    }

    public Result printInfo() {
        Object configStr = null;
        try {
            configStr = this.getConfigString();
        }
        catch (IOException ex) {
            configStr = "Failure: " + ex.getMessage();
        }
        Logger.getLogger(this.getClass().getCanonicalName()).log(Level.INFO, "\n\nDatabase " + ConfigHolder.TDSL_CONFIG_FILE_DEF + " configuration:\n{0}\n", new Object[]{configStr});
        return Result.ok;
    }

    public abstract Result addXmppAdminAccount(SchemaManager.SchemaInfo var1);

    public abstract Result setComponentVersion(String var1, String var2);

    public abstract Optional<Version> getComponentVersionFromDb(String var1);

    public abstract Result loadSchemaFile(String var1);

    public abstract Result shutdown();

    public Result loadCommonSchema() {
        return this.loadSchema(new SchemaManager.SchemaInfo("common", "Common Schema", true, Collections.emptyList()), "0.0.3");
    }

    public abstract Result loadSchema(SchemaManager.SchemaInfo var1, String var2);

    public abstract Optional<Version> getMinimalRequiredComponentVersionForUpgrade(SchemaManager.SchemaInfo var1);

    public abstract Result destroyDataSource();

    protected <T extends DataSource> Result addUsersToRepository(SchemaManager.SchemaInfo schemaInfo, T dataSource, Class<T> dataSourceClass, List<BareJID> jids, String password, Logger log) {
        return this.getDataSourceAwareClassesForSchemaInfo(schemaInfo, dataSourceClass).filter(AuthRepository.class::isAssignableFrom).filter(AbstractAuthRepositoryWithCredentials.class::isAssignableFrom).map(this::instantiateClass).map(this.initializeDataSourceAwareFunction(dataSource, log)).map(AuthRepository.class::cast).map(this::initializeAuthRepository).filter(Objects::nonNull).findAny().map(this.addUsersToRepositoryFunction(jids, password, log)).orElse(Result.error);
    }

    protected <DS extends DataSource> Stream<Class<DataSourceAware<DS>>> getDataSourceAwareClassesForSchemaInfo(SchemaManager.SchemaInfo schema, Class<DS> dataSourceIfc) {
        return schema.getRepositories().stream().map(SchemaManager.RepoInfo::getImplementation).filter(DataSourceAware.class::isAssignableFrom).filter(clazz -> ReflectionHelper.classMatchesClassWithParameters(clazz, DataSourceAware.class, new Type[]{dataSourceIfc})).map(clazz -> clazz);
    }

    protected <DSIFC extends DataSource, DS extends DSIFC> Stream<DataSourceAware> getInitializedDataSourceAwareForSchemaInfo(SchemaManager.SchemaInfo schema, Class<DSIFC> dataSourceIfc, DS dataSource, Logger log) {
        return this.getDataSourceAwareClassesForSchemaInfo(schema, dataSourceIfc).map(this::instantiateClass).map(this.initializeDataSourceAwareFunction((DataSource)dataSource, log));
    }

    protected AuthRepository initializeAuthRepository(AuthRepository authRepository) {
        if (authRepository instanceof AbstractAuthRepositoryWithCredentials) {
            AbstractAuthRepositoryWithCredentials repo = (AbstractAuthRepositoryWithCredentials)authRepository;
            Kernel kernel = new Kernel("SchemaLoader");
            kernel.registerBean(DefaultTypesConverter.class).exportable().exec();
            kernel.registerBean(DSLBeanConfigurator.class).exportable().exec();
            kernel.getInstance(DSLBeanConfigurator.class).setProperties(new HashMap<String, Object>());
            kernel.registerBean(CredentialsEncoderBean.class).exec();
            kernel.registerBean(CredentialsDecoderBean.class).exec();
            CredentialsEncoderBean encoderBean = kernel.getInstance(CredentialsEncoderBean.class);
            CredentialsDecoderBean decoderBean = kernel.getInstance(CredentialsDecoderBean.class);
            repo.setCredentialsCodecs(encoderBean, decoderBean);
        }
        return authRepository;
    }

    protected <T extends DataSource> Function<DataSourceAware<T>, DataSourceAware<T>> initializeDataSourceAwareFunction(T dataSource, Logger log) {
        return repo -> {
            try {
                repo.setDataSource(dataSource);
                return repo;
            }
            catch (Exception ex) {
                log.log(Level.WARNING, ex.getMessage());
                return null;
            }
        };
    }

    protected Function<AuthRepository, Result> addUsersToRepositoryFunction(List<BareJID> jids, String pwd, Logger log) {
        return authRepository -> {
            if (authRepository == null) {
                return Result.error;
            }
            return jids.stream().map(jid -> {
                try {
                    try {
                        authRepository.getAccountStatus((BareJID)jid);
                        log.log(Level.WARNING, "Skipping user " + jid + " creation, user already exists!");
                        return Result.skipped;
                    }
                    catch (UserNotFoundException ex) {
                        authRepository.addUser((BareJID)jid, pwd);
                        return Result.ok;
                    }
                }
                catch (TigaseDBException ex) {
                    log.log(Level.WARNING, ex.getMessage());
                    return Result.warning;
                }
            }).reduce(Result.ok, (r1, r2) -> {
                if (r1 == Result.error || r2 == Result.error) {
                    return Result.error;
                }
                if (r1 == Result.warning || r2 == Result.warning) {
                    return Result.warning;
                }
                if (r1 == Result.skipped || r2 == Result.skipped) {
                    return Result.skipped;
                }
                return Result.ok;
            });
        };
    }

    protected <T> T instantiateClass(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Failed to create instance of " + clazz.getCanonicalName());
            return null;
        }
    }

    protected String getType() {
        return this.type;
    }

    private void setType(String type) {
        TypeInfo info = SchemaLoader.getAllSupportedTypesStream().filter(typeInfo -> type.equals(typeInfo.getName())).findFirst().get();
        if (!info.isAvailable()) {
            throw new RuntimeException("Driver for " + info.getLabel() + " (" + info.getName() + ") is missing due to missing class: " + info.getDriverClassName());
        }
        this.type = type;
    }

    public static class TypeInfo
    implements Comparable<TypeInfo> {
        private final String name;
        private final String label;
        private final String driverClassName;
        private final String warning;
        private final int ordinal;
        final Comparator<TypeInfo> typeInfoComparator = Comparator.comparing(TypeInfo::getOrdinal).thenComparing(TypeInfo::getName);

        public TypeInfo(String name, String label, String driverClassName) {
            this(name, label, driverClassName, null);
        }

        public TypeInfo(int ordinal, String name, String label, String driverClassName) {
            this(ordinal, name, label, driverClassName, null);
        }

        public TypeInfo(String name, String label, String driverClassName, String warning) {
            this(Integer.MAX_VALUE, name, label, driverClassName, warning);
        }

        public TypeInfo(int ordinal, String name, String label, String driverClassName, String warning) {
            this.ordinal = ordinal;
            this.name = name;
            this.label = label;
            this.driverClassName = driverClassName;
            this.warning = warning;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public String getWarning() {
            return this.warning;
        }

        public boolean isAvailable() {
            try {
                this.getClass().getClassLoader().loadClass(this.driverClassName);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }

        @Override
        public int compareTo(TypeInfo o) {
            return this.typeInfoComparator.compare(this, o);
        }

        protected String getDriverClassName() {
            return this.driverClassName;
        }

        public String toString() {
            return this.name + " (" + this.ordinal + ")";
        }
    }

    public static interface Parameters {
        public void parseUri(String var1);

        public void setProperties(Properties var1);

        public List<BareJID> getAdmins();

        public String getAdminPassword();

        public void setAdmins(List<BareJID> var1, String var2);

        public void setDbRootCredentials(String var1, String var2);

        default public boolean isDbRootAsk() {
            return false;
        }

        default public void setDbRootAsk(boolean value) {
        }

        default public void setSchemaDirectory(String schemaDirectory) {
        }

        public Level getLogLevel();

        public void setLogLevel(Level var1);

        public boolean isForceReloadSchema();

        public void setForceReloadSchema(boolean var1);
    }

    public static enum Result {
        ok,
        error,
        warning,
        skipped;

    }
}

