/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.comp;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.TigaseDBException;
import tigase.db.beans.SDRepositoryBean;
import tigase.db.comp.ComponentRepository;
import tigase.db.comp.ComponentRepositoryDataSourceAware;
import tigase.db.comp.RepositoryChangeListenerIfc;
import tigase.db.comp.RepositoryItem;

public abstract class AbstractSDComponentRepositoryBean<Item extends RepositoryItem>
extends SDRepositoryBean<ComponentRepositoryDataSourceAware<Item, DataSource>>
implements ComponentRepository<Item> {
    @Override
    public void setRepository(ComponentRepositoryDataSourceAware<Item, DataSource> repository) {
        ComponentRepositoryDataSourceAware oldRepo = (ComponentRepositoryDataSourceAware)this.getRepository();
        super.setRepository(repository);
        if (oldRepo != this.getRepository() && oldRepo != null) {
            oldRepo.destroy();
        }
    }

    @Override
    public void addRepoChangeListener(RepositoryChangeListenerIfc<Item> repoChangeListener) {
        ((ComponentRepositoryDataSourceAware)this.getRepository()).addRepoChangeListener(repoChangeListener);
    }

    @Override
    public void removeRepoChangeListener(RepositoryChangeListenerIfc<Item> repoChangeListener) {
        ((ComponentRepositoryDataSourceAware)this.getRepository()).removeRepoChangeListener(repoChangeListener);
    }

    @Override
    public void addItem(Item item) throws TigaseDBException {
        ((ComponentRepositoryDataSourceAware)this.getRepository()).addItem(item);
    }

    @Override
    public void addItemNoStore(Item item) {
        ((ComponentRepositoryDataSourceAware)this.getRepository()).addItemNoStore(item);
    }

    @Override
    public Collection<Item> allItems() throws TigaseDBException {
        return this.getRepository() != null ? ((ComponentRepositoryDataSourceAware)this.getRepository()).allItems() : Collections.emptySet();
    }

    @Override
    public boolean contains(String key) {
        return ((ComponentRepositoryDataSourceAware)this.getRepository()).contains(key);
    }

    @Override
    public void destroy() {
        ((ComponentRepositoryDataSourceAware)this.getRepository()).destroy();
    }

    @Override
    @Deprecated
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
    }

    @Override
    public Item getItem(String key) {
        return ((ComponentRepositoryDataSourceAware)this.getRepository()).getItem(key);
    }

    @Override
    public Item getItemInstance() {
        return ((ComponentRepositoryDataSourceAware)this.getRepository()).getItemInstance();
    }

    @Override
    public void reload() throws TigaseDBException {
        ((ComponentRepositoryDataSourceAware)this.getRepository()).reload();
    }

    @Override
    public void removeItem(String key) throws TigaseDBException {
        ((ComponentRepositoryDataSourceAware)this.getRepository()).removeItem(key);
    }

    @Override
    public void removeItemNoStore(String key) {
        ((ComponentRepositoryDataSourceAware)this.getRepository()).removeItemNoStore(key);
    }

    @Override
    @Deprecated
    public void setProperties(Map<String, Object> properties) {
    }

    @Override
    public int size() {
        return ((ComponentRepositoryDataSourceAware)this.getRepository()).size();
    }

    @Override
    public void store() throws TigaseDBException {
        ((ComponentRepositoryDataSourceAware)this.getRepository()).store();
    }

    @Override
    public String validateItem(Item item) {
        return ((ComponentRepositoryDataSourceAware)this.getRepository()).validateItem(item);
    }

    @Override
    public void setAutoloadTimer(long delay) {
    }

    @Override
    public Iterator<Item> iterator() {
        return ((ComponentRepositoryDataSourceAware)this.getRepository()).iterator();
    }

    @Override
    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        ((ComponentRepositoryDataSourceAware)this.getRepository()).initRepository(resource_uri, params);
    }

    public String toString() {
        Collection<Item> items;
        try {
            items = this.allItems();
        }
        catch (TigaseDBException ex) {
            items = Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder("RepoItems");
        if (!items.isEmpty()) {
            sb.append(", size=").append(items.size());
            String itemsString = items.toString();
            sb.append(", items=").append(itemsString.substring(0, Math.min(itemsString.length(), 1024)));
            if (itemsString.length() > 1024) {
                sb.append("...");
            }
        }
        return sb.toString();
    }
}

