/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import tigase.auth.CredentialsDecoderBean;
import tigase.auth.CredentialsEncoderBean;
import tigase.auth.credentials.Credentials;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.xmpp.jid.BareJID;

public class PlainCredentialsEntry
implements Credentials.Entry {
    private final String password;

    public PlainCredentialsEntry(String password) {
        this.password = password;
    }

    @Override
    public String getMechanism() {
        return "PLAIN";
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean verifyPlainPassword(String plain) {
        return this.password == plain || this.password.equals(plain);
    }

    @Bean(name="PLAIN", parent=CredentialsEncoderBean.class, active=false)
    public static class Encoder
    implements Credentials.Encoder<PlainCredentialsEntry> {
        @ConfigField(desc="Mechanism name")
        private String name;

        @Override
        public String encode(BareJID user, String password) {
            return password;
        }

        @Override
        public String encode(BareJID user, PlainCredentialsEntry entry) {
            return entry.getPassword();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    @Bean(name="PLAIN", parent=CredentialsDecoderBean.class, active=true)
    public static class Decoder
    implements Credentials.Decoder<PlainCredentialsEntry> {
        @ConfigField(desc="Mechanism name")
        private String name;

        @Override
        public PlainCredentialsEntry decode(BareJID user, String value) {
            return new PlainCredentialsEntry(value);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

