/*
 * Decompiled with CFR 0.152.
 */
package tigase.auth.credentials.entries;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.annotations.TigaseDeprecated;
import tigase.auth.CredentialsDecoderBean;
import tigase.auth.CredentialsEncoderBean;
import tigase.auth.credentials.Credentials;
import tigase.kernel.beans.Bean;
import tigase.util.Algorithms;
import tigase.xmpp.jid.BareJID;

@Deprecated
@TigaseDeprecated(since="8.4.0", removeIn="9.0.0", note="SCRAM should be used for maximum security; it's possible to migrate to SCRAM seamlessly")
public class MD5UserIdPasswordCredentialsEntry
implements Credentials.Entry {
    private static final Logger log = Logger.getLogger(MD5UserIdPasswordCredentialsEntry.class.getCanonicalName());
    private final String passwordHash;
    private final BareJID user;

    public MD5UserIdPasswordCredentialsEntry(BareJID user, String passwordHash) {
        this.user = user;
        this.passwordHash = passwordHash;
    }

    @Override
    public String getMechanism() {
        return "MD5-USERID-PASSWORD";
    }

    @Override
    public boolean verifyPlainPassword(String plain) {
        try {
            byte[] hash = MessageDigest.getInstance("MD5").digest((this.user.toString() + plain).getBytes(StandardCharsets.UTF_8));
            return this.passwordHash.equalsIgnoreCase(Algorithms.bytesToHex((byte[])hash));
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "failed to verify password digest", ex);
            return false;
        }
    }

    @Bean(name="MD5-USERID-PASSWORD", parent=CredentialsEncoderBean.class, active=false)
    public static class Encoder
    implements Credentials.Encoder<MD5UserIdPasswordCredentialsEntry> {
        @Override
        public String encode(BareJID user, MD5UserIdPasswordCredentialsEntry entry) {
            return entry.passwordHash;
        }

        @Override
        public String encode(BareJID user, String password) {
            try {
                byte[] hash = MessageDigest.getInstance("MD5").digest((user.toString() + password).getBytes(StandardCharsets.UTF_8));
                return Algorithms.bytesToHex((byte[])hash);
            }
            catch (Exception ex) {
                throw new RuntimeException("failed to generate password hash", ex);
            }
        }

        @Override
        public String getName() {
            return "MD5-USERID-PASSWORD";
        }
    }

    @Bean(name="MD5-USERID-PASSWORD", parent=CredentialsDecoderBean.class, active=false)
    public static class Decoder
    implements Credentials.Decoder<MD5UserIdPasswordCredentialsEntry> {
        @Override
        public MD5UserIdPasswordCredentialsEntry decode(BareJID user, String value) {
            return new MD5UserIdPasswordCredentialsEntry(user, value);
        }

        @Override
        public String getName() {
            return "MD5-USERID-PASSWORD";
        }
    }
}

