/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.jetty.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.security.Password;
import tigase.http.AuthProvider;
import tigase.xmpp.jid.BareJID;

public class TigasePlainLoginService
implements LoginService {
    private static final Logger log = Logger.getLogger(TigasePlainLoginService.class.getCanonicalName());
    private DefaultIdentityService identityService = new DefaultIdentityService();
    private AuthProvider authProvider = null;

    public TigasePlainLoginService(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    public String getName() {
        return "TigasePlain";
    }

    public UserIdentity login(String s, Object o, ServletRequest request) {
        AuthProvider.JWTPayload payload;
        if (request instanceof HttpServletRequest && (payload = this.authProvider.authenticateWithCookie((HttpServletRequest)request)) != null) {
            return this.newUserIdentity(payload.subject());
        }
        String cred = null;
        if (o instanceof String) {
            cred = (String)o;
        }
        if (o instanceof Password) {
            cred = ((Password)o).toString();
        }
        if (cred != null) {
            BareJID jid = BareJID.bareJIDInstanceNS((String)s);
            boolean authOk = false;
            try {
                authOk = this.getAuthProvider().checkCredentials(s, cred);
            }
            catch (Exception ex) {
                log.log(Level.FINE, "not authorized used = " + jid, ex);
            }
            if (authOk) {
                return this.newUserIdentity(jid);
            }
        }
        return null;
    }

    private UserIdentity newUserIdentity(BareJID jid) {
        AbstractLoginService.UserPrincipal p = new AbstractLoginService.UserPrincipal(jid.toString(), null);
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)p);
        subject.setReadOnly();
        ArrayList<String> roles = new ArrayList<String>(Arrays.asList("user"));
        if (this.getAuthProvider().isAdmin(jid)) {
            roles.add("admin");
        }
        return this.getIdentityService().newUserIdentity(subject, (Principal)p, roles.toArray(new String[0]));
    }

    public boolean validate(UserIdentity userIdentity) {
        return true;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService2) {
        this.identityService = (DefaultIdentityService)identityService2;
    }

    public void logout(UserIdentity userIdentity) {
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }
}

