/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.cluster;

import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.cluster.MixComponentClustered;
import tigase.mix.cluster.StrategyIfc;
import tigase.mix.model.MixRepository;
import tigase.mix.model.Participant;
import tigase.pubsub.exceptions.PubSubException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

@Bean(name="mixRepository", parent=MixComponentClustered.class, active=true)
public class MixRepositoryClustered<T>
extends MixRepository<T> {
    @Inject
    private StrategyIfc strategy;

    public void itemWritten(BareJID serviceJID, String node, String id, String publisher, Element item, String uuid) {
        super.itemWritten(serviceJID, node, id, publisher, item, uuid);
        if ("urn:xmpp:mix:nodes:config".equals(node)) {
            this.strategy.channelConfigurationChanged(serviceJID, item);
        }
    }

    public void updateChannelConfiguration(BareJID serviceJID, Element item) {
        super.updateChannelConfiguration(serviceJID, item);
    }

    protected Participant updateParticipant(BareJID channelJID, String participantId, BareJID participantJID, String nick) throws PubSubException, RepositoryException {
        Participant participant = super.updateParticipant(channelJID, participantId, participantJID, nick);
        this.strategy.invalidateChannelParticipant(channelJID, participantId);
        return participant;
    }

    public void removeParticipant(BareJID channelJID, String participantID) throws RepositoryException {
        super.removeParticipant(channelJID, participantID);
        this.strategy.invalidateChannelParticipant(channelJID, participantID);
    }

    public void invalidateChannelParticipant(BareJID channelJID, String participantID) throws RepositoryException {
        super.invalidateChannelParticipant(channelJID, participantID);
    }
}

