/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository;

import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Stream;
import tigase.db.util.importexport.AbstractImporterExtension;
import tigase.db.util.importexport.DataSourceHelper;
import tigase.db.util.importexport.Exporter;
import tigase.db.util.importexport.RepositoryHolder;
import tigase.db.util.importexport.RepositoryManager;
import tigase.db.util.importexport.RepositoryManagerExtensionBase;
import tigase.kernel.core.Kernel;
import tigase.muc.Affiliation;
import tigase.muc.MUCConfig;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.muc.history.AbstractHistoryProvider;
import tigase.muc.history.ExtendedMAMRepository;
import tigase.muc.repository.IMucDAO;
import tigase.muc.repository.JDBCMucDAO;
import tigase.server.Message;
import tigase.util.Algorithms;
import tigase.util.Base64;
import tigase.util.datetime.TimestampHelper;
import tigase.util.ui.console.CommandlineParameter;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.mam.util.MAMRepositoryManagerExtensionHelper;

public class MUCRepositoryManagerExtension
extends RepositoryManagerExtensionBase {
    private static TimestampHelper TIMESTAMP_FORMATTER = new TimestampHelper();
    private static final Logger log = Logger.getLogger(MUCRepositoryManagerExtension.class.getSimpleName());
    private final CommandlineParameter INCLUDE_MUC = new CommandlineParameter.Builder(null, "include-muc").type(Boolean.class).description("Include MUC component data").defaultValue("false").requireArguments(false).build();

    public Stream<CommandlineParameter> getExportParameters() {
        return Stream.concat(super.getExportParameters(), Stream.of(this.INCLUDE_MUC, Exporter.EXPORT_MAM_SINCE, Exporter.EXPORT_MAM_BATCH_SIZE));
    }

    public Stream<CommandlineParameter> getImportParameters() {
        return Stream.concat(super.getImportParameters(), Stream.of(this.INCLUDE_MUC));
    }

    public void initialize(Kernel kernel, DataSourceHelper dataSourceHelper, RepositoryHolder repositoryHolder, Path rootPath) {
        super.initialize(kernel, dataSourceHelper, repositoryHolder, rootPath);
        repositoryHolder.registerPrepFn(JDBCMucDAO.class, mucDAO -> {
            try {
                Field f = JDBCMucDAO.class.getDeclaredField("mucConfig");
                f.setAccessible(true);
                f.set(mucDAO, new MUCConfig());
                f = JDBCMucDAO.class.getDeclaredField("roomFactory");
                f.setAccessible(true);
                f.set(mucDAO, new Room.RoomFactoryImpl());
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
            return mucDAO;
        });
    }

    public void exportDomainData(String domain, Writer domainWriter) throws Exception {
        if (RepositoryManager.isSet((CommandlineParameter)this.INCLUDE_MUC)) {
            log.info("exporting MUC component data...");
            Path mucPath = this.getRootPath().resolve("muc." + domain + ".xml");
            this.exportInclude(domainWriter, mucPath, writer -> {
                writer.append("<muc xmlns='tigase:xep-0227:muc:0'>\n");
                IMucDAO mucDAO = (IMucDAO)this.getRepository(IMucDAO.class, domain);
                AbstractHistoryProvider historyProvider = (AbstractHistoryProvider)this.getRepository(AbstractHistoryProvider.class, domain);
                for (BareJID roomJid : mucDAO.getRoomsJIDList()) {
                    if (!roomJid.getDomain().endsWith(domain)) continue;
                    log.fine("exporting " + roomJid + " data...");
                    RoomWithId room = mucDAO.getRoom(roomJid);
                    if (room == null || room.getId() == null) continue;
                    Path roomPath = mucPath.resolveSibling(roomJid.getDomain()).resolve(roomJid.getLocalpart() + ".xml");
                    this.exportInclude((Writer)writer, roomPath, roomWriter -> this.exportRoom(mucDAO, historyProvider, roomJid, room, (Writer)roomWriter));
                }
                writer.append("</muc>");
            });
        }
    }

    private void exportRoom(IMucDAO mucDAO, AbstractHistoryProvider historyProvider, BareJID roomJid, RoomWithId room, Writer writer) throws Exception {
        String encodedAvatar;
        writer.append("<room jid=\"").append(roomJid.toString()).append("\"");
        if (room.getCreationDate() != null) {
            writer.append(" createdAt=\"").append(TIMESTAMP_FORMATTER.format(room.getCreationDate())).append("\"");
        }
        if (room.getCreatorJid() != null) {
            writer.append(" createdBy=\"").append(room.getCreatorJid().toString()).append("\"");
        }
        writer.append(">");
        writer.append("<config>");
        RoomConfig config = room.getConfig();
        writer.append(config.getAsElement().toString());
        writer.append("</config>");
        Map<BareJID, RoomAffiliation> affs = mucDAO.getAffiliations(room);
        if (affs != null && !affs.isEmpty()) {
            writer.append("<affiliations>");
            for (Map.Entry<BareJID, RoomAffiliation> e : affs.entrySet()) {
                RoomAffiliation aff = e.getValue();
                writer.append("<affiliation jid=\"").append(e.getKey().toString()).append("\" affiliation=\"").append(aff.getAffiliation().name()).append("\"");
                if (aff.getRegisteredNickname() != null) {
                    writer.append(" nick=\"").append(XMLUtils.escape((String)aff.getRegisteredNickname())).append("\"");
                }
                writer.append(" persistent=\"").append(String.valueOf(aff.isPersistentOccupant())).append("\"/>");
            }
            writer.append("</affiliations>");
        }
        if ((encodedAvatar = mucDAO.getRoomAvatar(room)) != null && encodedAvatar.length() > 0) {
            Element vCard = new Element("vCard", new String[]{"xmlns"}, new String[]{"vcard-temp"});
            String[] items = encodedAvatar.split(";");
            Element photo = new Element("PHOTO");
            photo.addChild((XMLNodeIfc)new Element("TYPE", items[0]));
            photo.addChild((XMLNodeIfc)new Element("BINVAL", items[1]));
            vCard.addChild((XMLNodeIfc)photo);
            writer.append(vCard.toString());
        }
        if (historyProvider instanceof MAMRepository) {
            MAMRepository mamRepository = (MAMRepository)historyProvider;
            log.info("exporting room " + roomJid + " history...");
            MAMRepositoryManagerExtensionHelper.exportDataFromRepository((MAMRepository)mamRepository, (BareJID)roomJid, (BareJID)roomJid, (mamItem, result) -> {
                ExtendedMAMRepository.Item item = (ExtendedMAMRepository.Item)mamItem;
                JID sender = item.getSenderJID();
                if (sender != null) {
                    result.addAttribute("sender", sender.toString());
                }
            }, (Writer)writer);
        }
        writer.append("</room>");
    }

    public void exportUserData(Path userDirPath, BareJID user, Writer writer) throws Exception {
    }

    public tigase.db.util.importexport.ImporterExtension startImportDomainData(String domain, String name, Map<String, String> attrs) throws Exception {
        if (!"muc".equals(name)) {
            return null;
        }
        if (!"tigase:xep-0227:muc:0".equals(attrs.get("xmlns"))) {
            return null;
        }
        IMucDAO mucDAO = (IMucDAO)this.getRepository(IMucDAO.class, domain);
        AbstractHistoryProvider historyProvider = (AbstractHistoryProvider)this.getRepository(AbstractHistoryProvider.class, domain);
        return new ImporterExtension(mucDAO, historyProvider, RepositoryManager.isSet((CommandlineParameter)this.INCLUDE_MUC));
    }

    private static class ImporterExtension
    extends AbstractImporterExtension {
        private final AbstractHistoryProvider historyProvider;
        private final boolean includeMUC;
        private final Room.RoomFactory roomFactory = new Room.RoomFactoryImpl();
        private final IMucDAO mucDAO;
        private State state = State.root;
        private BareJID room;
        private Date createdAt;
        private BareJID createdBy;
        private tigase.db.util.importexport.ImporterExtension activeExtension;
        private int depth = 0;

        private ImporterExtension(IMucDAO mucDAO, AbstractHistoryProvider historyProvider, boolean includeMUC) {
            this.mucDAO = mucDAO;
            this.includeMUC = includeMUC;
            this.historyProvider = historyProvider;
            if (includeMUC) {
                log.info("importing MUC component data...");
            }
        }

        public boolean startElement(String name, Map<String, String> attrs) throws Exception {
            if (!this.includeMUC) {
                ++this.depth;
                return true;
            }
            if (this.activeExtension != null) {
                return this.activeExtension.startElement(name, attrs);
            }
            return switch (this.state) {
                case State.root -> {
                    if ("room".equals(name)) {
                        this.room = BareJID.bareJIDInstance((String)attrs.get("jid"));
                        this.createdAt = Optional.ofNullable(attrs.get("createdAt")).map(arg_0 -> ((ImporterExtension)this).parseTimestamp(arg_0)).orElseThrow();
                        this.createdBy = Optional.ofNullable(attrs.get("createdBy")).map(BareJID::bareJIDInstanceNS).orElseThrow();
                        this.state = State.room;
                        yield true;
                    }
                    yield false;
                }
                case State.room -> {
                    switch (name) {
                        case "archive": {
                            RoomWithId r = this.mucDAO.getRoom(this.room);
                            this.activeExtension = new HistoryImporterExtension(this.historyProvider, r);
                            this.state = State.archive;
                            yield true;
                        }
                        case "affiliations": {
                            this.state = State.affiliations;
                            yield true;
                        }
                    }
                    yield false;
                }
                case State.affiliations -> {
                    if ("affiliation".equals(name)) {
                        RoomWithId r = this.mucDAO.getRoom(this.room);
                        BareJID jid = BareJID.bareJIDInstance((String)attrs.get("jid"));
                        Affiliation affiliation = Affiliation.valueOf(attrs.get("affiliation"));
                        String registeredNickname = XMLUtils.unescape((String)attrs.get("nick"));
                        boolean persistent = Boolean.parseBoolean(attrs.get("persistent"));
                        this.mucDAO.setAffiliation(r, jid, RoomAffiliation.from(affiliation, persistent, registeredNickname));
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public boolean handleElement(Element element) throws Exception {
            if (this.activeExtension != null && this.activeExtension.handleElement(element)) {
                return true;
            }
            return switch (element.getName()) {
                case "config" -> {
                    if (this.state != State.room) {
                        yield false;
                    }
                    log.fine("creating room " + this.room + "...");
                    Element x = Optional.ofNullable(element.findChild(el -> "x".equals(el.getName()) && "jabber:x:data".equals(el.getXMLNS()))).orElseThrow();
                    if (this.mucDAO.getRoom(this.room) == null) {
                        RoomConfig rc = new RoomConfig(this.room);
                        rc.readFromElement(x);
                        RoomWithId<Object> r = this.roomFactory.newInstance(null, rc, this.createdAt, this.createdBy);
                        log.info("creating room " + this.room + "...");
                        this.mucDAO.createRoom(r);
                    } else {
                        log.info("room " + this.room + " already exist, updating room configuration...");
                        RoomConfig rc = new RoomConfig(this.room);
                        rc.readFromElement(x);
                        this.mucDAO.updateRoomConfig(rc);
                    }
                    yield true;
                }
                case "vCard" -> {
                    if (!"vcard-temp".equals(element.getXMLNS())) {
                        yield false;
                    }
                    log.finest("setting room " + this.room + " vcard...");
                    Element photoEl = element.getChild("PHOTO");
                    if (photoEl != null) {
                        Optional<String> typeOpt = Optional.ofNullable(photoEl.getChild("TYPE")).map(Element::getCData);
                        Optional<String> binvalOpt = Optional.ofNullable(photoEl.getChild("BINVAL")).map(Element::getCData);
                        typeOpt.ifPresent(type -> binvalOpt.ifPresent(binval -> {
                            try {
                                RoomWithId r = this.mucDAO.getRoom(this.room);
                                byte[] data = Base64.decode((String)binval);
                                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                                String hash = Algorithms.bytesToHex((byte[])sha.digest(data));
                                this.mucDAO.updateRoomAvatar(r, type + ";" + binval, hash);
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex);
                            }
                        }));
                    }
                    yield true;
                }
                default -> false;
            };
        }

        public boolean endElement(String name) throws Exception {
            if (!this.includeMUC) {
                boolean inside = this.depth > 0;
                --this.depth;
                return inside;
            }
            if (this.activeExtension != null && this.activeExtension.endElement(name)) {
                return true;
            }
            return switch (this.state) {
                default -> throw new IncompatibleClassChangeError();
                case State.root -> false;
                case State.room -> {
                    switch (name) {
                        case "room": {
                            this.state = State.root;
                            log.finest("finished importing room " + this.room);
                            yield true;
                        }
                    }
                    yield false;
                }
                case State.archive -> {
                    switch (name) {
                        case "archive": {
                            log.finest("finished importing room " + this.room + " history");
                            this.activeExtension.close();
                            this.activeExtension = null;
                            this.state = State.room;
                            yield true;
                        }
                    }
                    yield false;
                }
                case State.affiliations -> {
                    switch (name) {
                        case "affiliations": {
                            this.state = State.room;
                            yield true;
                        }
                        case "affiliation": {
                            yield true;
                        }
                    }
                    yield false;
                }
            };
        }

        static enum State {
            root,
            room,
            affiliations,
            archive;

        }
    }

    private static class HistoryImporterExtension
    extends MAMRepositoryManagerExtensionHelper.AbstractImporterExtension {
        private final AbstractHistoryProvider historyProvider;
        private final Room room;

        private HistoryImporterExtension(AbstractHistoryProvider historyProvider, Room room) {
            this.historyProvider = historyProvider;
            this.room = room;
            log.info("importing room " + room.getRoomJID() + " history...");
        }

        protected boolean handleMessage(Message message, String stableId, Date timestamp, Element source) throws Exception {
            ExtendedMAMRepository extendedMAMRepository;
            String senderNickname = message.getStanzaFrom().getResource();
            JID senderJid = JID.jidInstanceNS((String)source.getAttributeStaticStr("sender"));
            message.initVars(null, null);
            Element body = message.getElemChild("body");
            AbstractHistoryProvider abstractHistoryProvider = this.historyProvider;
            if (abstractHistoryProvider instanceof ExtendedMAMRepository && (extendedMAMRepository = (ExtendedMAMRepository)((Object)abstractHistoryProvider)).getItem(this.room.getRoomJID(), stableId) != null) {
                log.finest("found existing message for room " + this.room.getRoomJID() + " with id = " + stableId + ", skipping insert");
                return true;
            }
            this.historyProvider.addMessage(this.room, message.getElement(), body == null ? null : body.getCData(), senderJid, senderNickname, timestamp, stableId);
            return true;
        }
    }
}

