/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules.selfping;

import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.ScheduledTask;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Ghostbuster2;
import tigase.muc.MUCComponent;
import tigase.muc.modules.selfping.Request;
import tigase.xmpp.jid.JID;

@Bean(name="self-pinger-monitor", parent=MUCComponent.class, active=true)
public class SelfPingerMonitor
extends ScheduledTask {
    private static final Logger log = Logger.getLogger(SelfPingerMonitor.class.getName());
    private final Set<Request> requests = ConcurrentHashMap.newKeySet();
    private final Map<String, Request> sentSubrequests = new ConcurrentHashMap<String, Request>();
    @Inject(nullAllowed=true)
    private Ghostbuster2 ghostbuster2;
    private Handler handler;

    static String key(JID jidInstance, String stanzaId) {
        return jidInstance.toString() + ":" + stanzaId;
    }

    public SelfPingerMonitor() {
        super(Duration.ofMinutes(1L), Duration.ofMinutes(1L));
    }

    public Request register(JID jidFrom, JID jidTo, String id) {
        Request r = new Request(this, jidFrom, jidTo, id);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "PRegistering for ping, from: {0}, to: {1}, id: {2}, requests: {3}", new Object[]{jidFrom, jidTo, id, this.requests.size()});
        }
        this.requests.add(r);
        return r;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void registerResponse(JID jid, String stanzaId, Request.Result result) {
        String key = SelfPingerMonitor.key(jid, stanzaId);
        Request req = this.sentSubrequests.get(key);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Registering response self-ping, jid: {0}, stanzaId: {1}, result: {2}, req: {3}, sentSubrequests: {4}", new Object[]{jid, stanzaId, result, req, this.sentSubrequests.size()});
        }
        if (req != null) {
            req.registerResponse(jid, stanzaId, result);
        }
    }

    public void run() {
        HashSet toFinish = new HashSet();
        long tm = System.currentTimeMillis() - 45000L;
        this.requests.forEach(req -> {
            if (req.getTimestampt() <= tm) {
                toFinish.add(req);
            }
        });
        toFinish.forEach(this::finish);
    }

    void kickOut(JID jid) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Kicking out JID: {0}", new Object[]{jid});
        }
        try {
            if (this.ghostbuster2 != null) {
                this.ghostbuster2.kickJIDFromRooms(jid, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void registerSubRequest(String key, Request req) {
        this.sentSubrequests.put(key, req);
    }

    void finish(Request request) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Finishing request: {0}", new Object[]{request});
        }
        this.requests.remove(request);
        long err = request.getResultErrorCounter();
        long oks = request.getResultOkCounter();
        long tms = request.getNoResultCounter();
        ResultStatus st = tms > 0L ? ResultStatus.Timeouts : (err > 0L ? ResultStatus.Errors : ResultStatus.AllSuccess);
        this.handler.finished(request, st);
        this.sentSubrequests.remove(request.getId());
        request.getTimeoutedJIDs().forEach(this::kickOut);
    }

    public static interface Handler {
        public void finished(Request var1, ResultStatus var2);
    }

    public static enum ResultStatus {
        AllSuccess,
        Errors,
        Timeouts;

    }
}

