/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Collection;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="privatemessages", active=true)
public class PrivateMessageModule
extends AbstractMucModule {
    public static final String ID = "privatemessages";
    private static final Criteria CRIT = ElementCriteria.nameType((String)"message", (String)"chat");
    @Inject
    private IMucRepository repository;

    public String[] getFeatures() {
        return null;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet element) throws MUCException {
        try {
            JID senderJID = JID.jidInstance((String)element.getAttributeStaticStr("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttributeStaticStr("to"));
            String recipientNickname = PrivateMessageModule.getNicknameFromJid(JID.jidInstance((String)element.getAttributeStaticStr("to")));
            if (recipientNickname == null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String senderNickname = room.getOccupantsNickname(senderJID);
            Role senderRole = room.getRole(senderNickname);
            if (!this.isAllowedToSendPrivateMessage(room.getConfig(), senderRole)) {
                throw new MUCException(Authorization.NOT_ALLOWED, "Your role is '" + senderRole + "'. You can't send private message.");
            }
            this.validateRTBL(senderJID.getBareJID(), room.getAffiliation(senderNickname).getAffiliation());
            Collection<JID> recipientJids = room.getOccupantsJidsByNickname(recipientNickname);
            if (recipientJids.isEmpty()) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unknown recipient");
            }
            for (JID jid : recipientJids) {
                Element message = element.getElement().clone();
                message.setAttribute("from", JID.jidInstance((BareJID)roomJID, (String)senderNickname).toString());
                message.setAttribute("to", jid.toString());
                Packet p = Packet.packetInstance((Element)message);
                p.setXMLNS("jabber:client");
                this.write(p);
            }
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAllowedToSendPrivateMessage(RoomConfig config, Role role) {
        switch (config.getPrivateMessageACL()) {
            case none: {
                return false;
            }
            case anyone: {
                return role.isSendPrivateMessages();
            }
            case participants: {
                return role.isSendMessagesToAll();
            }
            case moderators: {
                return role == Role.moderator;
            }
        }
        return true;
    }
}

