/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.resolve;

import gg.jte.CodeResolver;
import gg.jte.compiler.IoUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;

public class ResourceCodeResolver
implements CodeResolver {
    private final String root;
    private final ClassLoader classLoader;

    public ResourceCodeResolver(String root) {
        this(root, null);
    }

    public ResourceCodeResolver(String root, ClassLoader classLoader) {
        this.root = root.isEmpty() ? "" : root + "/";
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolve(String name) {
        try (InputStream is = this.getClassLoader().getResourceAsStream(this.root + name);){
            if (is == null) {
                String string2 = null;
                return string2;
            }
            String string = IoUtils.toString(is);
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean exists(String name) {
        return this.getClassLoader().getResource(this.root + name) != null;
    }

    public long getLastModified(String name) {
        URL res = this.getClassLoader().getResource(this.root + name);
        if (res == null) {
            return 0L;
        }
        try {
            return new File(res.toURI()).lastModified();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return 0L;
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }
}

