/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler;

import gg.jte.CodeResolver;
import gg.jte.TemplateConfig;
import gg.jte.TemplateException;
import gg.jte.TemplateNotFoundException;
import gg.jte.compiler.ClassCompiler;
import gg.jte.compiler.ClassDefinition;
import gg.jte.compiler.ClassUtils;
import gg.jte.compiler.CodeGenerator;
import gg.jte.compiler.IoUtils;
import gg.jte.compiler.ParamInfo;
import gg.jte.compiler.TemplateDependency;
import gg.jte.compiler.TemplateParser;
import gg.jte.compiler.TemplateType;
import gg.jte.compiler.extensionsupport.ExtensionConfig;
import gg.jte.compiler.extensionsupport.ExtensionTemplateDescription;
import gg.jte.compiler.java.JavaClassCompiler;
import gg.jte.compiler.java.JavaCodeGenerator;
import gg.jte.extension.api.JteExtension;
import gg.jte.output.FileOutput;
import gg.jte.runtime.ClassInfo;
import gg.jte.runtime.DebugInfo;
import gg.jte.runtime.Template;
import gg.jte.runtime.TemplateLoader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class TemplateCompiler
extends TemplateLoader {
    public static final boolean DEBUG = false;
    private final TemplateConfig config;
    private final CodeResolver codeResolver;
    private final ClassLoader parentClassLoader;
    private final ConcurrentHashMap<String, LinkedHashSet<TemplateDependency>> templateDependencies = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<ParamInfo>> paramOrder = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ClassInfo> templateByClassName = new ConcurrentHashMap();
    private List<String> classPath;

    public TemplateCompiler(TemplateConfig config, CodeResolver codeResolver, Path classDirectory, ClassLoader parentClassLoader) {
        super(classDirectory, config.packageName);
        this.config = config;
        this.codeResolver = codeResolver;
        this.parentClassLoader = parentClassLoader;
    }

    public Template load(String name) {
        this.precompile(Collections.singletonList(name));
        return super.load(name);
    }

    public Template hotReload(String name) {
        LinkedHashSet<ClassDefinition> classDefinitions = this.generate(Collections.singletonList(name), true);
        classDefinitions.removeIf(c -> !c.isChanged());
        if (!classDefinitions.isEmpty()) {
            this.precompileClasses(classDefinitions);
        }
        return super.load(name);
    }

    protected ClassInfo getClassInfo(ClassLoader classLoader, String className) {
        return this.templateByClassName.get(className);
    }

    protected ClassLoader getClassLoader() {
        return this.createClassLoader(this.parentClassLoader);
    }

    public void cleanAll() {
        IoUtils.deleteDirectoryContent(this.classDirectory.resolve(this.config.packageName.replace('.', '/')));
    }

    public List<String> generateAll() {
        LinkedHashSet<ClassDefinition> classDefinitions = this.generate(this.codeResolver.resolveAllTemplateNames(), false);
        return classDefinitions.stream().map(ClassDefinition::getSourceFileName).toList();
    }

    public List<String> precompileAll() {
        return this.precompile(this.codeResolver.resolveAllTemplateNames());
    }

    public List<String> precompile(List<String> names) {
        LinkedHashSet<ClassDefinition> classDefinitions = this.generate(names, false);
        return this.precompileClasses(classDefinitions);
    }

    private List<String> precompileClasses(LinkedHashSet<ClassDefinition> classDefinitions) {
        List<String> classPath = this.getClassPath();
        HashSet<String> extensions = new HashSet<String>();
        String[] files = new String[classDefinitions.size()];
        int i = 0;
        for (ClassDefinition classDefinition : classDefinitions) {
            files[i++] = this.classDirectory.resolve(classDefinition.getSourceFileName()).toFile().getAbsolutePath();
            extensions.add(classDefinition.getExtension());
        }
        ArrayList<String> javaCompilerClassPath = new ArrayList<String>(classPath);
        javaCompilerClassPath.add(this.classDirectory.toAbsolutePath().toString());
        if (extensions.size() == 1) {
            ClassCompiler compiler = this.createCompiler((String)extensions.iterator().next());
            compiler.compile(files, javaCompilerClassPath, this.config, this.classDirectory, this.templateByClassName);
        } else if (extensions.size() > 1) {
            ClassCompiler kotlinCompiler = this.createCompiler("kt");
            kotlinCompiler.compile(files, classPath, this.config, this.classDirectory, this.templateByClassName);
            String[] javaFiles = (String[])Arrays.stream(files).filter(f -> f.endsWith(".java")).toArray(String[]::new);
            ClassCompiler javaCompiler = this.createCompiler("java");
            javaCompiler.compile(javaFiles, javaCompilerClassPath, this.config, this.classDirectory, this.templateByClassName);
        }
        return classDefinitions.stream().map(ClassDefinition::getSourceFileName).toList();
    }

    private List<String> getClassPath() {
        if (this.classPath == null) {
            this.classPath = this.calculateClassPath();
        }
        return this.classPath;
    }

    private List<String> calculateClassPath() {
        if (this.config.classPath != null) {
            return this.config.classPath;
        }
        ArrayList<String> classPath = new ArrayList<String>();
        ClassUtils.resolveClasspathFromClassLoader(this.parentClassLoader, classPath::add);
        return classPath;
    }

    ClassCompiler createCompiler(String extension) {
        if ("kt".equals(extension)) {
            try {
                Class<?> compilerClass = Class.forName("gg.jte.compiler.kotlin.KotlinClassCompiler");
                return (ClassCompiler)compilerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new TemplateException("Failed to create kotlin compiler. To compile .kte files, you need to add gg.jte:jte-kotlin to your project.", (Throwable)e);
            }
        }
        return new JavaClassCompiler();
    }

    private LinkedHashSet<ClassDefinition> generate(List<String> names, boolean trackChanges) {
        LinkedHashSet<ClassDefinition> classDefinitions = new LinkedHashSet<ClassDefinition>();
        for (String string : names) {
            LinkedHashSet<TemplateDependency> dependencies = this.initTemplateDependencies(string);
            ClassInfo templateInfo = this.generateTemplateCall(string, classDefinitions, dependencies, null);
            this.templateDependencies.put(string, dependencies);
            this.templateByClassName.put(templateInfo.name, templateInfo);
        }
        Path resourceDirectory = this.config.resourceDirectory == null ? this.classDirectory : this.config.resourceDirectory;
        for (ClassDefinition classDefinition2 : classDefinitions) {
            Path sourceFile = this.classDirectory.resolve(classDefinition2.getSourceFileName());
            if (trackChanges) {
                String sourceFileContent = IoUtils.toString(sourceFile);
                classDefinition2.setChanged(!classDefinition2.getCode().equals(sourceFileContent));
            }
            try (FileOutput fileOutput = new FileOutput(sourceFile);){
                fileOutput.writeContent(classDefinition2.getCode());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            List<byte[]> textParts = classDefinition2.getBinaryTextParts();
            if (textParts.isEmpty()) continue;
            try {
                Files.createDirectories(resourceDirectory.resolve(classDefinition2.getBinaryTextPartsFileName()).getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            try {
                OutputStream os = Files.newOutputStream(resourceDirectory.resolve(classDefinition2.getBinaryTextPartsFileName()), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                try {
                    for (byte[] textPart : textParts) {
                        os.write(textPart);
                    }
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        List<JteExtension> list = this.config.extensionClasses.entrySet().stream().map(this::loadExtension).toList();
        if (!list.isEmpty()) {
            ExtensionConfig extensionConfig = new ExtensionConfig(this.config, this.classDirectory, this.getClassLoader());
            Set descriptions = classDefinitions.stream().map(classDefinition -> new ExtensionTemplateDescription((ClassDefinition)classDefinition, this.templateByClassName.get(classDefinition.getName()))).collect(Collectors.toSet());
            list.forEach(x -> {
                Collection generated = x.generate(extensionConfig, descriptions);
                System.out.printf("Extension %s generated %d files.%n", x.getClass().getName(), generated.size());
            });
        }
        return classDefinitions;
    }

    private LinkedHashSet<TemplateDependency> initTemplateDependencies(String name) {
        LinkedHashSet<TemplateDependency> templateDependencies = new LinkedHashSet<TemplateDependency>();
        templateDependencies.add(new TemplateDependency(name, this.codeResolver.getLastModified(name)));
        return templateDependencies;
    }

    public ClassInfo generateTemplateCall(String simpleName, String extension, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<TemplateDependency> templateDependencies, DebugInfo debugInfo) {
        String name = this.resolveTemplateName(simpleName, extension);
        try {
            return this.generateTemplateCall(name, classDefinitions, templateDependencies, debugInfo);
        }
        catch (TemplateNotFoundException e) {
            String alternativeName = this.resolveTemplateName(simpleName, "jte".equals(extension) ? "kte" : "jte");
            if (this.codeResolver.exists(alternativeName)) {
                return this.generateTemplateCall(alternativeName, classDefinitions, templateDependencies, debugInfo);
            }
            throw e;
        }
    }

    private String resolveTemplateName(String simpleName, String extension) {
        return simpleName.replace('.', '/') + "." + extension;
    }

    public ClassInfo generateTemplateCall(String name, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<TemplateDependency> templateDependencies, DebugInfo debugInfo) {
        templateDependencies.add(new TemplateDependency(name, this.codeResolver.getLastModified(name)));
        ClassInfo classInfo = new ClassInfo(name, this.config.packageName);
        ClassDefinition classDefinition = new ClassDefinition(classInfo.fullName, classInfo);
        if (classDefinitions.contains(classDefinition)) {
            return classInfo;
        }
        String code = this.resolveCode(name, debugInfo);
        classDefinitions.add(classDefinition);
        CodeGenerator codeGenerator = this.createCodeGenerator(classInfo, classDefinitions, templateDependencies);
        new TemplateParser(code, TemplateType.Template, codeGenerator, this.config).parse();
        classDefinition.setCode(codeGenerator.getCode(), codeGenerator.getBinaryTextParts(), codeGenerator.getParamInfo(), codeGenerator.getImports());
        this.templateByClassName.put(classDefinition.getName(), classInfo);
        return classInfo;
    }

    private CodeGenerator createCodeGenerator(ClassInfo classInfo, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<TemplateDependency> templateDependencies) {
        if ("kte".equals(classInfo.extension)) {
            try {
                Class<?> compilerClass = Class.forName("gg.jte.compiler.kotlin.KotlinCodeGenerator");
                return (CodeGenerator)compilerClass.getConstructor(TemplateCompiler.class, TemplateConfig.class, ConcurrentHashMap.class, ClassInfo.class, LinkedHashSet.class, LinkedHashSet.class).newInstance(new Object[]{this, this.config, this.paramOrder, classInfo, classDefinitions, templateDependencies});
            }
            catch (Exception e) {
                throw new TemplateException("Failed to create kotlin generator. To handle .kte files, you need to add gg.jte:jte-kotlin to your project.", (Throwable)e);
            }
        }
        return new JavaCodeGenerator(this, this.config, this.paramOrder, classInfo, classDefinitions, templateDependencies);
    }

    private String resolveCode(String name, DebugInfo debugInfo) {
        try {
            return this.codeResolver.resolveRequired(name);
        }
        catch (TemplateNotFoundException e) {
            Object message = e.getMessage();
            if (debugInfo != null) {
                message = (String)message + ", referenced at " + debugInfo.name + ":" + debugInfo.line;
            }
            throw new TemplateNotFoundException((String)message);
        }
    }

    public boolean hasChanged(String name) {
        LinkedHashSet<TemplateDependency> dependencies = this.templateDependencies.get(name);
        if (dependencies == null) {
            return false;
        }
        for (TemplateDependency dependency : dependencies) {
            if (this.codeResolver.getLastModified(dependency.getName()) <= dependency.getLastModifiedTimestamp()) continue;
            return true;
        }
        return false;
    }

    public List<String> getTemplatesUsing(String name) {
        TemplateDependency dependency = new TemplateDependency(name, 0L);
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, LinkedHashSet<TemplateDependency>> dependencies : this.templateDependencies.entrySet()) {
            if (!dependencies.getValue().contains(dependency)) continue;
            result.add(dependencies.getKey());
        }
        return result;
    }

    private JteExtension loadExtension(Map.Entry<String, Map<String, String>> extensionSettings) {
        try {
            Class<?> extensionClass = Class.forName(extensionSettings.getKey());
            JteExtension extension = (JteExtension)extensionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return extension.init(extensionSettings.getValue());
        }
        catch (Exception e) {
            throw new TemplateException("Failed to load extension " + extensionSettings.getKey(), (Throwable)e);
        }
    }
}

