/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler;

import gg.jte.compiler.ParamInfo;
import gg.jte.runtime.ClassInfo;
import java.util.List;

public final class ClassDefinition {
    private final String name;
    private final String extension;
    private String code;
    private List<byte[]> binaryTextParts;
    private boolean changed = true;
    private List<ParamInfo> params;
    private List<String> imports;

    public ClassDefinition(String name, ClassInfo classInfo) {
        this.name = name;
        this.extension = "kte".equals(classInfo.extension) ? "kt" : "java";
    }

    public ClassDefinition(String name, String extension) {
        this.name = name;
        this.extension = extension;
    }

    void setCode(String code, List<byte[]> binaryTextParts, List<ParamInfo> params, List<String> imports) {
        this.code = code;
        this.binaryTextParts = binaryTextParts;
        this.params = params;
        this.imports = imports;
    }

    public String getCode() {
        return this.code;
    }

    public List<byte[]> getBinaryTextParts() {
        return this.binaryTextParts;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDefinition that = (ClassDefinition)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.extension.equals(that.extension);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.extension.hashCode();
        return result;
    }

    public String getSourceFileName() {
        return this.getName().replace('.', '/') + "." + this.extension;
    }

    public String getBinaryTextPartsFileName() {
        return this.getName().replace('.', '/') + ".bin";
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public List<ParamInfo> getParams() {
        return this.params;
    }

    public List<String> getImports() {
        return this.imports;
    }
}

