/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.modules;

import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.IMeetLogic;
import tigase.meet.IMeetRepository;
import tigase.meet.Meet;
import tigase.meet.MeetComponent;
import tigase.meet.modules.AbstractModule;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="destroyMeetModule", parent=MeetComponent.class, active=true)
public class DestroyMeetModule
extends AbstractModule {
    private static final Criteria CRITERIA = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"destroy", (String)"tigase:meet:0"));
    private static final String[] FEATURES = new String[]{"tigase:meet:0"};
    @Inject
    private IMeetLogic logic;
    @Inject
    private IMeetRepository meetRepository;

    public String[] getFeatures() {
        return FEATURES;
    }

    public Criteria getModuleCriteria() {
        return CRITERIA;
    }

    @Override
    public CompletableFuture<Packet> processPacket(Packet packet) throws ComponentException, TigaseStringprepException {
        if (StanzaType.set != packet.getType()) {
            throw new ComponentException(Authorization.BAD_REQUEST);
        }
        BareJID meetJid = packet.getStanzaTo().getBareJID();
        JID from = packet.getStanzaFrom();
        Meet meet = this.meetRepository.getMeet(meetJid);
        this.logic.checkPermission(meet, from, IMeetLogic.Action.destroy);
        this.log.log(Level.FINEST, () -> "user " + packet.getStanzaFrom() + " initiated meet " + meetJid + " destruction");
        return ((CompletableFuture)meet.destroy().thenApply(x -> packet.okResult((Element)null, 0))).whenComplete((x, ex) -> {
            if (ex != null) {
                this.log.log(Level.FINEST, (Throwable)ex, () -> "meet " + meetJid + " destruction by " + packet.getStanzaFrom() + " failed");
            } else {
                this.log.log(Level.FINEST, () -> "meet " + meetJid + " destruction by " + packet.getStanzaFrom() + " succeeded");
            }
        });
    }
}

