/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.xml.Element;

public class SSRC {
    private final String ssrc;
    private final List<Parameter> parameters;

    public static SSRC from(Element el) {
        if ("source".equals(el.getName()) && "urn:xmpp:jingle:apps:rtp:ssma:0".equals(el.getXMLNS())) {
            String ssrc = el.getAttributeStaticStr("ssrc");
            if (ssrc == null) {
                ssrc = el.getAttributeStaticStr("id");
            }
            if (ssrc == null) {
                return null;
            }
            List<Parameter> parameters = Optional.ofNullable(el.getChildren()).orElse(Collections.emptyList()).stream().map(Parameter::from).filter(Objects::nonNull).collect(Collectors.toList());
            return new SSRC(ssrc, parameters);
        }
        return null;
    }

    public static List<SSRC> from(String[] lines) {
        Stream<String> ssrcs = Arrays.stream(lines).filter(it -> it.startsWith("a=ssrc:")).map(it -> it.substring("a=ssrc:".length())).map(it -> it.split(" ")[0]).distinct();
        Optional<String> msid = Arrays.stream(lines).filter(it -> it.startsWith("a=msid:")).map(it -> it.substring("a=msid:".length())).findFirst();
        return ssrcs.map(ssrc -> {
            String prefix = "a=ssrc:" + ssrc;
            List<Parameter> parameters = Arrays.stream(lines).filter(it -> it.startsWith(prefix)).map(it -> it.substring(prefix.length())).map(it -> it.split(":")).filter(it -> !it[0].trim().isEmpty()).map(it -> new Parameter(it[0].trim(), Optional.ofNullable(((String[])it).length == 1 ? null : Arrays.stream(it).skip(1L).collect(Collectors.joining(":"))))).collect(Collectors.toList());
            if (parameters.stream().filter(it -> "msid".equals(it.getName())).findAny().isEmpty()) {
                msid.ifPresent(value -> parameters.add(new Parameter("msid", msid)));
            }
            return new SSRC((String)ssrc, parameters);
        }).collect(Collectors.toList());
    }

    public SSRC(String ssrc, List<Parameter> parameters) {
        this.ssrc = ssrc;
        this.parameters = parameters;
    }

    public String getSsrc() {
        return this.ssrc;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Element toElement() {
        Element el = new Element("source");
        el.setXMLNS("urn:xmpp:jingle:apps:rtp:ssma:0");
        el.setAttribute("ssrc", this.ssrc);
        el.setAttribute("id", this.ssrc);
        this.parameters.stream().map(Parameter::toElement).forEach(arg_0 -> ((Element)el).addChild(arg_0));
        return el;
    }

    public List<String> toSDP() {
        return this.parameters.stream().map(it -> "a=ssrc:" + this.ssrc + " " + it.toSDP()).collect(Collectors.toList());
    }

    public static class Parameter {
        private final String name;
        private final Optional<String> value;

        public static Parameter from(Element el) {
            if ("parameter".equals(el.getName())) {
                String name = el.getAttributeStaticStr("name");
                Optional<String> value = Optional.ofNullable(el.getAttributeStaticStr("value"));
                return new Parameter(name, value);
            }
            return null;
        }

        public Parameter(String name, Optional<String> value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getValue() {
            return this.value;
        }

        public Element toElement() {
            Element el = new Element("parameter");
            el.setAttribute("name", this.name);
            this.value.ifPresent(v -> el.setAttribute("value", v));
            return el;
        }

        public String toSDP() {
            if (this.value.isPresent()) {
                return this.name + ":" + this.value.get();
            }
            return this.name;
        }
    }
}

