/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Arrays;
import java.util.Optional;
import tigase.xml.Element;

public class Fingerprint {
    private final String hash;
    private final String value;
    private final Setup setup;

    public static Fingerprint from(Element el) {
        if ("fingerprint".equals(el.getName()) && "urn:xmpp:jingle:apps:dtls:0".equals(el.getXMLNS())) {
            String hash = el.getAttributeStaticStr("hash");
            String value = el.getCData();
            String setup = el.getAttributeStaticStr("setup");
            if (hash == null || value == null || setup == null) {
                return null;
            }
            return new Fingerprint(hash, value, Setup.valueOf(setup));
        }
        return null;
    }

    public Fingerprint(String hash, String value, Setup setup) {
        this.hash = hash;
        this.value = value;
        this.setup = setup;
    }

    public String getHash() {
        return this.hash;
    }

    public String getValue() {
        return this.value;
    }

    public Setup getSetup() {
        return this.setup;
    }

    public Element toElement() {
        Element el = new Element("fingerprint", this.value);
        el.setXMLNS("urn:xmpp:jingle:apps:dtls:0");
        el.setAttribute("hash", this.hash);
        el.setAttribute("setup", this.setup.name());
        return el;
    }

    public static enum Setup {
        actpass,
        active,
        passive;


        public static Optional<Setup> from(String[] lines) {
            return Arrays.stream(lines).filter(it -> it.startsWith("a=setup:")).findFirst().map(it -> it.substring("a=setup:".length())).map(Setup::valueOf);
        }
    }

    public static class FingerprintData {
        private final String hash;
        private final String value;

        public static Optional<FingerprintData> from(String[] lines) {
            return Arrays.stream(lines).filter(it -> it.startsWith("a=fingerprint:")).map(it -> it.substring("a=fingerprint:".length()).split(" ")).filter(it -> ((String[])it).length >= 2).findFirst().map(it -> new FingerprintData(it[0], it[1]));
        }

        public FingerprintData(String hash, String value) {
            this.hash = hash;
            this.value = value;
        }

        public String getHash() {
            return this.hash;
        }

        public String getValue() {
            return this.value;
        }
    }
}

