/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.jingle;

import java.util.Optional;
import java.util.UUID;
import tigase.xml.Element;

public class Candidate {
    private final String component;
    private final String foundation;
    private final int generation;
    private final String id;
    private final String ip;
    private final int network;
    private final int port;
    private final int priority;
    private final ProtocolType protocolType;
    private final Optional<String> relAddr;
    private final Optional<Integer> relPort;
    private final Optional<CandidateType> type;
    private final Optional<String> tcpType;

    public static Candidate from(Element el) {
        if ("candidate".equals(el.getName())) {
            String component = el.getAttributeStaticStr("component");
            String foundation = el.getAttributeStaticStr("foundation");
            String generation = el.getAttributeStaticStr("generation");
            String id = el.getAttributeStaticStr("id");
            if (id == null) {
                id = UUID.randomUUID().toString();
            }
            String ip = el.getAttributeStaticStr("ip");
            String network = el.getAttributeStaticStr("network");
            String port = el.getAttributeStaticStr("port");
            String priority = el.getAttributeStaticStr("priority");
            String protocolType = el.getAttributeStaticStr("protocol");
            if (component == null || foundation == null || generation == null || ip == null || network == null || port == null || priority == null || protocolType == null) {
                return null;
            }
            Optional<String> relAddr = Optional.ofNullable(el.getAttributeStaticStr("rel-addr"));
            Optional<Integer> relPort = Optional.ofNullable(el.getAttributeStaticStr("rel-port")).map(Integer::parseInt);
            Optional<CandidateType> candidateType = Optional.ofNullable(el.getAttributeStaticStr("type")).map(CandidateType::valueOf);
            Optional<String> tcpType = Optional.ofNullable(el.getAttributeStaticStr("tcptype"));
            return new Candidate(component, foundation, Integer.parseInt(generation), id, ip, Integer.parseInt(network), Integer.parseInt(port), Integer.parseInt(priority), ProtocolType.valueOf(protocolType), relAddr, relPort, candidateType, tcpType);
        }
        return null;
    }

    public static Candidate from(String line) {
        int idx = "candidate:".length() + (line.startsWith("a=") ? 2 : 0);
        String[] parts = line.substring(idx).split(" ");
        if (parts.length >= 8) {
            ProtocolType protocolType = ProtocolType.valueOf(parts[2].toLowerCase());
            int priority = Integer.parseInt(parts[3]);
            int port = Integer.parseInt(parts[5]);
            CandidateType type = CandidateType.valueOf(parts[7]);
            Optional<Integer> generation = Optional.empty();
            Optional<String> relAddr = Optional.empty();
            Optional<Integer> relPort = Optional.empty();
            Optional<String> tcpType = Optional.empty();
            int i = 8;
            while (parts.length >= i + 2) {
                switch (parts[i]) {
                    case "tcptype": {
                        tcpType = Optional.ofNullable(parts[i + 1]);
                        break;
                    }
                    case "generation": {
                        generation = Optional.ofNullable(parts[i + 1]).map(Integer::parseInt);
                        break;
                    }
                    case "raddr": {
                        relAddr = Optional.ofNullable(parts[i + 1]);
                        break;
                    }
                    case "rport": {
                        relPort = Optional.ofNullable(parts[i + 1]).map(Integer::parseInt);
                        break;
                    }
                    default: {
                        --i;
                    }
                }
                i += 2;
            }
            return new Candidate(parts[1], parts[0], generation.orElse(0), UUID.randomUUID().toString(), parts[4], 0, port, priority, protocolType, relAddr, relPort, Optional.of(type), tcpType);
        }
        return null;
    }

    public Candidate(String component, String foundation, int generation, String id, String ip, int network, int port, int priority, ProtocolType protocolType, Optional<String> relAddr, Optional<Integer> relPort, Optional<CandidateType> type, Optional<String> tcpType) {
        this.component = component;
        this.foundation = foundation;
        this.generation = generation;
        this.id = id;
        this.ip = ip;
        this.network = network;
        this.port = port;
        this.priority = priority;
        this.protocolType = protocolType;
        this.relAddr = relAddr;
        this.relPort = relPort;
        this.type = type;
        this.tcpType = tcpType;
    }

    public String getComponent() {
        return this.component;
    }

    public String getFoundation() {
        return this.foundation;
    }

    public int getGeneration() {
        return this.generation;
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public int getNetwork() {
        return this.network;
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public ProtocolType getProtocolType() {
        return this.protocolType;
    }

    public Optional<String> getRelAddr() {
        return this.relAddr;
    }

    public Optional<Integer> getRelPort() {
        return this.relPort;
    }

    public Optional<CandidateType> getType() {
        return this.type;
    }

    public Optional<String> getTcpType() {
        return this.tcpType;
    }

    public Element toElement() {
        Element el = new Element("candidate");
        el.setAttribute("component", this.component);
        el.setAttribute("foundation", this.foundation);
        el.setAttribute("generation", String.valueOf(this.generation));
        el.setAttribute("id", this.id);
        el.setAttribute("ip", this.ip);
        el.setAttribute("network", String.valueOf(this.network));
        el.setAttribute("port", String.valueOf(this.port));
        el.setAttribute("protocol", this.protocolType.name());
        el.setAttribute("priority", String.valueOf(this.priority));
        this.relAddr.ifPresent(relAddr -> el.setAttribute("rel-addr", relAddr));
        this.relPort.map(String::valueOf).ifPresent(relPort -> el.setAttribute("rel-port", relPort));
        this.type.map(Enum::name).ifPresent(type -> el.setAttribute("type", type));
        this.tcpType.ifPresent(tcpType -> el.setAttribute("tcptype", tcpType));
        return el;
    }

    public String toSDP() {
        CandidateType type = this.type.orElse(CandidateType.host);
        StringBuilder sb = new StringBuilder();
        sb.append("candidate:").append(this.foundation).append(" ").append(this.component).append(" ").append(this.protocolType.name().toLowerCase()).append(" ").append(this.priority).append(" ").append(this.ip).append(" ").append(this.port).append(" typ ").append(type.name());
        if (type != CandidateType.host) {
            this.relAddr.ifPresent(relAddr -> this.relPort.ifPresent(relPort -> sb.append(" raddr ").append((String)relAddr).append(" rport ").append(relPort)));
        }
        if (this.protocolType == ProtocolType.tcp) {
            this.tcpType.ifPresent(tcpType -> sb.append(" tcptype ").append((String)tcpType));
        }
        sb.append(" generation ").append(this.generation);
        return sb.toString();
    }

    public static enum ProtocolType {
        udp,
        tcp;

    }

    public static enum CandidateType {
        host,
        prlfx,
        relay,
        srflx;

    }
}

