/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus.videoroom;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.JanusSession;
import tigase.meet.janus.videoroom.JanusVideoRoomPlugin;

public class LocalSubscriber {
    private static final Logger log = Logger.getLogger(LocalSubscriber.class.getCanonicalName());
    private final JanusVideoRoomPlugin videoRoomPlugin;
    private final Object roomId;
    private boolean subscribed = false;
    private Listener listener;

    public LocalSubscriber(JanusVideoRoomPlugin videoRoomPlugin, Object roomId) {
        this.videoRoomPlugin = videoRoomPlugin;
        this.roomId = roomId;
    }

    public JanusSession getSession() {
        return this.videoRoomPlugin.getSession();
    }

    public CompletableFuture<JSEP> joinAsSubscriber(Long privateId, long publisherId, List<JanusVideoRoomPlugin.Stream> streams) {
        String transaction = this.videoRoomPlugin.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", joining room as subscriber..");
        return ((CompletableFuture)this.videoRoomPlugin.execute("join", transaction, this.roomId, generator -> {
            generator.writeStringField("ptype", "subscriber");
            if (privateId != null) {
                generator.writeNumberField("private_id", privateId.longValue());
            }
            generator.writeFieldName("streams");
            generator.writeStartArray();
            for (JanusVideoRoomPlugin.Stream stream : streams) {
                stream.write(generator);
            }
            generator.writeEndArray();
        }, null).thenApply(content -> {
            this.subscribed = true;
            log.log(Level.FINER, () -> this.toString() + " updated subscribed streams: " + content.data.get("streams"));
            return content.jsep;
        })).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", failed to join room as subscriber!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", joined room as subscriber.");
                if (x != null) {
                    this.listener.receivedSubscriberSDP((JSEP)x);
                }
            }
        });
    }

    public CompletableFuture<JSEP> subscribe(List<JanusVideoRoomPlugin.Stream> streams) {
        if (!this.subscribed) {
            return this.joinAsSubscriber(null, streams.stream().mapToLong(JanusVideoRoomPlugin.Stream::getFeed).findFirst().getAsLong(), streams);
        }
        String transaction = this.videoRoomPlugin.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", subscribing streams " + streams + "..");
        return ((CompletableFuture)this.videoRoomPlugin.execute("subscribe", transaction, this.roomId, generator -> {
            generator.writeFieldName("streams");
            generator.writeStartArray();
            for (JanusVideoRoomPlugin.Stream stream : streams) {
                stream.write(generator);
            }
            generator.writeEndArray();
        }, null).thenApply(x -> x.jsep)).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", failed to subscribe streams!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", subscribed streams.");
                if (x != null) {
                    this.listener.receivedSubscriberSDP((JSEP)x);
                }
            }
        });
    }

    public CompletableFuture<JSEP> unsubscribe(long publisherId) {
        String transaction = this.videoRoomPlugin.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", unsubscribing streams with feed " + publisherId + "..");
        return ((CompletableFuture)this.videoRoomPlugin.execute("unsubscribe", transaction, this.roomId, generator -> {
            generator.writeFieldName("streams");
            generator.writeStartArray();
            new JanusVideoRoomPlugin.Stream(publisherId, null).write(generator);
            generator.writeEndArray();
        }, null).thenApply(content -> content.jsep)).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", failed to unsubscribed streams!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", unsubscribed streams.");
                if (x != null) {
                    this.listener.receivedSubscriberSDP((JSEP)x);
                }
            }
        });
    }

    public CompletableFuture<Void> start(JSEP jsep) {
        String transaction = this.videoRoomPlugin.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", starting stream..");
        return ((CompletableFuture)this.videoRoomPlugin.execute("start", transaction, this.roomId, generator -> {}, jsep).thenApply(content -> {
            if ("event".equals(content.getVideoRoom()) && "ok".equals(content.data.get("started"))) {
                return null;
            }
            throw new UnsupportedOperationException("Unexpected response: " + content);
        })).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", failed to start stream!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", stream started.");
            }
        });
    }

    public CompletableFuture<Void> sendCandidate(JanusPlugin.Candidate candidate) {
        String transaction = this.videoRoomPlugin.getSession().nextTransactionId();
        log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", sending candidate " + candidate + "..");
        return this.videoRoomPlugin.sendTrickle(transaction, candidate).whenComplete((x, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.toString() + ", transaction " + transaction + ", failed to send candidate!");
            } else {
                log.log(Level.FINER, () -> this.toString() + ", transaction " + transaction + ", candidate sent.");
            }
        });
    }

    public void handleEvent(JanusVideoRoomPlugin.Content content) {
        if ("updated".equals(content.getVideoRoom()) && content.data.containsKey("streams")) {
            log.log(Level.FINER, () -> this.toString() + " updated subscribed streams: " + content.data.get("streams"));
            if (content.jsep != null) {
                this.listener.receivedSubscriberSDP(content.jsep);
            }
        }
    }

    public void receivedCandidate(JanusPlugin.Candidate candidate) {
        this.listener.receivedSubscriberCandidate(candidate);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public static interface Listener {
        public void receivedSubscriberSDP(JSEP var1);

        public void receivedSubscriberCandidate(JanusPlugin.Candidate var1);
    }
}

