/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus;

import java.net.Socket;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.meet.IMeetRepository;
import tigase.meet.MeetComponent;
import tigase.meet.janus.JanusConnection;
import tigase.meet.janus.JanusPluginsRegister;

@Bean(name="janus", parent=MeetComponent.class, active=true)
public class JanusService
implements Initializable,
UnregisterAware {
    @ConfigField(desc="URI for connect to Janus", alias="uri")
    private String uri;
    @ConfigField(desc="Janus session timeout", alias="session-timeout")
    private Duration sessionTimeout = Duration.of(60L, ChronoUnit.SECONDS);
    private HttpClient client;
    private JanusPluginsRegister pluginsRegister = new JanusPluginsRegister();
    private ScheduledExecutorService executorService;
    @Inject(nullAllowed=true)
    private IMeetRepository meetRepository;
    private static final Logger log = Logger.getLogger(JanusService.class.getCanonicalName());

    public void initialize() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new DummyTrustManager()}, null);
            this.client = HttpClient.newBuilder().sslContext(sslContext).build();
            this.executorService = Executors.newScheduledThreadPool(4);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeUnregister() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public CompletableFuture<JanusConnection> newConnection() {
        JanusConnection connection = new JanusConnection(this.pluginsRegister, this.executorService, this.sessionTimeout);
        log.log(Level.FINER, () -> connection.logPrefix() + ", creating connection..");
        return ((CompletableFuture)this.client.newWebSocketBuilder().subprotocols("janus-protocol", new String[0]).buildAsync(URI.create(this.uri), connection).thenApply(webSocket -> {
            connection.setWebSocket((WebSocket)webSocket);
            return connection;
        })).whenComplete((conn, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> connection.logPrefix() + ", connection creation failed.");
            } else {
                log.log(Level.FINER, () -> connection.logPrefix() + ", connection created.");
            }
        });
    }

    static class DummyTrustManager
    extends X509ExtendedTrustManager {
        DummyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

