/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet.janus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.meet.janus.JanusException;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.JanusPluginsRegister;
import tigase.meet.janus.JanusSession;

public class JanusConnection
implements WebSocket.Listener {
    private static final Logger log = Logger.getLogger(JanusConnection.class.getCanonicalName());
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final String id = UUID.randomUUID().toString();
    private WebSocket webSocket;
    private StringBuilder sb = new StringBuilder();
    private ConcurrentHashMap<String, CompletableFuture<Void>> sendTransactions = new ConcurrentHashMap();
    private ConcurrentHashMap<String, CompletableFuture<Map<String, Object>>> executeTransactions = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, JanusSession> activeSessions = new ConcurrentHashMap();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final JanusPluginsRegister pluginsRegister;
    private final ScheduledExecutorService executorService;
    private final Duration sessionTimeout;

    public JanusConnection(JanusPluginsRegister pluginsRegister, ScheduledExecutorService executorService, Duration sessionTimeout) {
        this.pluginsRegister = pluginsRegister;
        this.executorService = executorService;
        this.sessionTimeout = sessionTimeout;
    }

    public void close() {
        CompletableFuture.allOf((CompletableFuture[])this.activeSessions.values().stream().map(session -> session.destroy()).toArray(CompletableFuture[]::new)).handle((x, ex) -> this.withContext(webSocket -> webSocket.sendClose(1000, "ok")));
    }

    public String getId() {
        return this.id;
    }

    public String nextTransactionId() {
        return UUID.randomUUID().toString();
    }

    protected void setWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public String logPrefix(String transaction) {
        return this.logPrefix() + ", transaction " + transaction;
    }

    public CompletableFuture<JanusSession> createSession() {
        String transaction = this.nextTransactionId();
        log.log(Level.FINER, () -> this.logPrefix(transaction) + ", creating session..");
        CompletableFuture<JanusSession> future = new CompletableFuture<JanusSession>();
        ((CompletableFuture)this.execute("create", transaction, generator -> {}).thenApply(data -> new JanusSession(this, (Map)data.get("data")))).whenComplete((session, ex) -> {
            if (ex != null) {
                log.log(Level.WARNING, (Throwable)ex, () -> this.logPrefix(transaction) + ", session creation failed.");
                future.completeExceptionally((Throwable)ex);
            } else {
                this.activeSessions.put(session.getSessionId(), (JanusSession)session);
                log.log(Level.FINER, () -> session.logPrefix(transaction) + " session created.");
                session.scheduleKeepAlive(this.executorService, this.sessionTimeout);
                future.complete((JanusSession)session);
            }
        });
        return future;
    }

    public CompletableFuture<Void> destroySession(JanusSession session) {
        String transaction = this.nextTransactionId();
        log.log(Level.FINER, () -> session.logPrefix(transaction) + " destroying ..");
        return ((CompletableFuture)this.execute("destroy", transaction, generator -> generator.writeNumberField("session_id", session.getSessionId())).whenComplete((x, ex) -> {
            if (ex != null) {
                String msg = ex.getMessage();
                if (msg != null && msg.startsWith("458 - ")) {
                    return;
                }
                log.log(Level.WARNING, (Throwable)ex, () -> session.logPrefix(transaction) + " destruction failed!");
            } else {
                log.log(Level.FINER, () -> session.logPrefix(transaction) + " destroyed");
            }
        })).thenApply(x -> null);
    }

    public String getPluginId(Class<? extends JanusPlugin> plugin) {
        return this.pluginsRegister.getPluginId(plugin);
    }

    public CompletableFuture<Map<String, Object>> getInfo() {
        return this.execute("info", this.nextTransactionId(), generator -> {});
    }

    public CompletableFuture<Map<String, Object>> execute(String janus, String transaction, RequestGenerator requestGenerator) {
        CompletionStage future = new CompletableFuture().whenComplete((result, ex) -> this.executeTransactions.remove(transaction));
        try {
            this.executeTransactions.put(transaction, (CompletableFuture<Map<String, Object>>)future);
            this.sendInternal(janus, transaction, requestGenerator);
        }
        catch (IOException | InterruptedException | ExecutionException ex2) {
            this.executeTransactions.remove(transaction);
            ((CompletableFuture)future).completeExceptionally(ex2);
        }
        return future;
    }

    public CompletableFuture<Void> send(String janus, String transaction, RequestGenerator requestGenerator) {
        CompletionStage future = new CompletableFuture().whenComplete((result, ex) -> this.sendTransactions.remove(transaction));
        try {
            this.sendTransactions.put(transaction, (CompletableFuture<Void>)future);
            this.sendInternal(janus, transaction, requestGenerator);
        }
        catch (IOException | InterruptedException | ExecutionException ex2) {
            ((CompletableFuture)future).completeExceptionally(ex2);
        }
        return future;
    }

    private void sendInternal(String janus, String transaction, RequestGenerator requestGenerator) throws IOException, ExecutionException, InterruptedException {
        StringWriter w = new StringWriter();
        JsonGenerator generator = jsonFactory.createGenerator((Writer)w);
        generator.writeStartObject();
        generator.writeStringField("janus", janus);
        generator.writeStringField("transaction", transaction);
        requestGenerator.accept(generator);
        generator.writeEndObject();
        generator.close();
        String str = w.toString();
        log.log(Level.FINEST, () -> this.logPrefix() + ", sending request: " + str);
        this.withContext(webSocket -> webSocket.sendText(str, true)).get();
    }

    public String logPrefix() {
        return "connection " + this.getId();
    }

    private <T> CompletableFuture<T> withContext(Function<WebSocket, CompletableFuture<T>> function) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> ((CompletableFuture)function.apply(this.webSocket)).whenComplete((result, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
            } else {
                future.complete(result);
            }
        }));
        return future;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        log.log(Level.FINEST, () -> this.logPrefix() + ", opened connection");
        webSocket.request(1L);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        log.log(Level.FINEST, () -> this.logPrefix() + ", closed connection");
        webSocket.request(1L);
        return null;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        log.log(Level.WARNING, error, () -> this.logPrefix() + ", exception on connection");
        webSocket.request(1L);
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        log.log(Level.FINEST, () -> this.logPrefix() + ", received binary: " + data);
        webSocket.request(1L);
        return null;
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        this.sb.append(data);
        webSocket.request(1L);
        if (last) {
            log.log(Level.FINEST, () -> this.logPrefix() + ", received message: " + this.sb.toString());
            try {
                Map<String, Object> values = this.decode(this.sb.toString());
                String janus = (String)values.get("janus");
                String transaction = (String)values.get("transaction");
                if (janus == null) {
                    throw new NullPointerException("Received JSON with 'janus' not set!");
                }
                switch (janus) {
                    case "server_info": 
                    case "success": {
                        if (transaction == null) {
                            throw new NullPointerException("Received JSON with 'transaction' not set!");
                        }
                        this.removeExecuteTransaction(transaction).ifPresentOrElse(future -> future.complete(values), () -> log.log(Level.WARNING, () -> this.logPrefix(transaction) + ", received success without matching transaction, payload: " + values));
                        break;
                    }
                    case "error": {
                        if (transaction == null) {
                            throw new NullPointerException("Received JSON with 'transaction' not set!");
                        }
                        JanusException ex = new JanusException((Map)values.get("error"));
                        log.log(Level.WARNING, ex, () -> this.logPrefix(transaction) + ", request failed!");
                        this.removeExecuteTransaction(transaction).ifPresentOrElse(future -> future.completeExceptionally(ex), () -> this.removeSendTransaction(transaction).ifPresentOrElse(future -> future.completeExceptionally(ex), () -> log.log(Level.WARNING, () -> this.logPrefix(transaction) + ", received error without matching transaction, payload: " + values)));
                        break;
                    }
                    case "ack": {
                        if (transaction == null) {
                            throw new NullPointerException("Received JSON with 'transaction' not set!");
                        }
                        this.removeSendTransaction(transaction).ifPresent(future -> future.complete(null));
                        log.log(Level.FINEST, () -> this.logPrefix(transaction) + ", request acknowledged.");
                        break;
                    }
                    case "detached": {
                        log.log(Level.FINEST, () -> this.logPrefix() + ", received detached event: " + values);
                        break;
                    }
                    case "event": {
                        Optional handler = transaction != null ? this.removeExecuteTransaction(transaction) : Optional.empty();
                        log.log(Level.FINEST, () -> this.logPrefix() + ", received event: " + values + ", with handler: " + handler.isPresent());
                        if (handler.isPresent()) {
                            ((CompletableFuture)handler.get()).complete(values);
                            break;
                        }
                        Optional.ofNullable((Long)values.get("session_id")).map(this::getSession).ifPresentOrElse(session -> session.handleEvent(values), () -> log.log(Level.WARNING, () -> this.logPrefix() + ", event for not existing session: " + values));
                        break;
                    }
                    case "trickle": {
                        log.log(Level.FINEST, () -> this.logPrefix() + ", received trickle: " + values);
                        Optional.ofNullable((Long)values.get("session_id")).map(this::getSession).ifPresentOrElse(session -> session.handleTrickle(values), () -> log.log(Level.WARNING, () -> this.logPrefix() + ", trickle for not existing session: " + values));
                        break;
                    }
                    default: {
                        log.log(Level.FINEST, () -> this.logPrefix() + ", received something: " + values);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e, () -> this.logPrefix() + ", JSON processing failed!\n" + this.sb.toString());
            }
            this.sb = new StringBuilder();
        }
        return null;
    }

    protected JanusSession getSession(long id) {
        return this.activeSessions.get(id);
    }

    protected Optional<CompletableFuture<Map<String, Object>>> removeExecuteTransaction(String transactionId) {
        return Optional.ofNullable(this.executeTransactions.get(transactionId));
    }

    protected Optional<CompletableFuture<Void>> removeSendTransaction(String transactionId) {
        return Optional.ofNullable(this.sendTransactions.get(transactionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> decode(String content) throws IOException {
        try (JsonParser parser = jsonFactory.createParser(content);){
            parser.nextToken();
            Map<String, Object> map = this.decode(parser);
            return map;
        }
    }

    protected Map<String, Object> decode(JsonParser parser) throws IOException {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Invalid parser state! state = " + parser.getCurrentToken());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String fieldName = null;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            JsonToken token = parser.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                fieldName = parser.getCurrentName();
                continue;
            }
            result.put(fieldName, this.decodeValue(parser));
        }
        return result;
    }

    protected Object decodeValue(JsonParser parser) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.VALUE_STRING) {
            return parser.getText();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (token == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (token == JsonToken.VALUE_NUMBER_INT) {
            return parser.getNumberValue();
        }
        if (token == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(parser.getFloatValue());
        }
        if (token == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return parser.getEmbeddedObject();
        }
        if (token == JsonToken.START_OBJECT) {
            return this.decode(parser);
        }
        if (token == JsonToken.START_ARRAY) {
            return this.decodeArray(parser);
        }
        throw new IllegalStateException("Unexpected token");
    }

    protected List decodeArray(JsonParser parser) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            list.add(this.decodeValue(parser));
        }
        return list;
    }

    @FunctionalInterface
    public static interface RequestGenerator {
        public void accept(JsonGenerator var1) throws IOException;
    }
}

