/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.converter;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.converter.Converter;
import tigase.db.converter.Convertible;
import tigase.db.converter.QueryExecutor;
import tigase.kernel.beans.Inject;
import tigase.pubsub.Affiliation;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.converter.PubSubNodeEntity;
import tigase.pubsub.repository.converter.PubSubQueries;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xmpp.jid.BareJID;

public class PubSubNodeConverter
implements Convertible<PubSubNodeEntity> {
    private static final Logger log = Logger.getLogger(PubSubNodeConverter.class.getName());
    @Inject
    QueryExecutor queryExecutor;
    private Converter.ConverterProperties properties;
    private PubSubQueries queries;
    @Inject(nullAllowed=false)
    private IPubSubRepository repository;

    static Affiliation decodeAffiliation(String affiliation) {
        return switch (affiliation) {
            case "o" -> Affiliation.owner;
            case "p" -> Affiliation.publisher;
            case "u" -> Affiliation.publish_only;
            case "m" -> Affiliation.member;
            case "c" -> Affiliation.outcast;
            default -> Affiliation.none;
        };
    }

    static Subscription decodeSubscription(String subString) {
        String subValue;
        String[] split = subString.split(":");
        return switch (subValue = split.length > 0 ? split[0] : "") {
            case "s" -> Subscription.subscribed;
            case "p" -> Subscription.pending;
            case "u" -> Subscription.unconfigured;
            default -> Subscription.none;
        };
    }

    static String getParent(String node) {
        if (node == null) {
            return null;
        }
        String parent = null;
        int i = node.lastIndexOf(47);
        if (i > 0) {
            try {
                parent = node.substring(0, i);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return parent;
    }

    static String[] parseArrayValue(String value) {
        String trimmed;
        if (value != null && (trimmed = value.trim()).startsWith("[") && trimmed.endsWith("]")) {
            String content = trimmed.substring(1, value.trim().length() - 1);
            String[] split = content.split("\\s*,\\s*");
            for (int i = 0; i < split.length; ++i) {
                split[i] = split[i].trim();
            }
            return split;
        }
        return null;
    }

    public Optional<String> getMainQuery() {
        return this.queries.getQuery("SELECT host, node, parent, nodeid, ( SELECT COUNT(*) FROM `pubsub_node` WHERE pubsub_node.host = outer_pubsub_node.host AND `node` like CONCAT(outer_pubsub_node.node, '/%')) AS counter FROM pubsub_node as outer_pubsub_node order by host, counter DESC, node");
    }

    public void initialise(Converter.ConverterProperties converterProperties) {
        this.properties = converterProperties;
        this.queries = new PubSubQueries(this.properties.getServerType(), this.properties.getDatabaseType());
    }

    public Optional<PubSubNodeEntity> processResultSet(ResultSet rs) throws Exception {
        String node = null;
        String host = null;
        long node_id = 0L;
        int counter = 0;
        String parent_node = null;
        switch (this.properties.getServerType()) {
            case ejabberd: {
                node = rs.getString("node");
                host = rs.getString("host");
                node_id = rs.getLong("nodeid");
                counter = rs.getInt("counter");
                parent_node = rs.getString("parent");
            }
        }
        if (node != null && host != null && node_id > 0L) {
            BareJID service = BareJID.bareJIDInstance((String)host);
            String parent = parent_node != null && !parent_node.trim().isEmpty() ? parent_node : PubSubNodeConverter.getParent(node);
            NodeType nodeType = counter > 0 ? NodeType.collection : NodeType.leaf;
            PubSubNodeEntity pubSubNodeEntity = new PubSubNodeEntity(service, node, parent, nodeType, node_id);
            List owners = (List)this.queryExecutor.executeQuery("SELECT owner FROM pubsub_node_owner where nodeid = ?", this.getOwner(node_id));
            pubSubNodeEntity.addOwners(owners);
            Map associations = (Map)this.queryExecutor.executeQuery("SELECT jid, affiliation, subscriptions, stateid FROM pubsub_state WHERE nodeid = ?", this.getAssociation(node_id));
            associations.entrySet().stream().filter(entry -> Affiliation.owner.equals((Object)((UserAssociation)entry.getValue()).affiliation)).map(Map.Entry::getKey).forEach(pubSubNodeEntity::addOwner);
            for (Map.Entry association : associations.entrySet()) {
                pubSubNodeEntity.addSubscription((BareJID)association.getKey(), ((UserAssociation)association.getValue()).subscription);
                pubSubNodeEntity.addAffiliation((BareJID)association.getKey(), ((UserAssociation)association.getValue()).affiliation);
            }
            Map configuration = (Map)this.queryExecutor.executeQuery("SELECT name, val FROM pubsub_node_option WHERE nodeid = ?", this.getConfiguration(node_id));
            for (Map.Entry entry2 : configuration.entrySet()) {
                String key = (String)entry2.getKey();
                String value = (String)entry2.getValue();
                this.setNodeConfiguration(pubSubNodeEntity, key, value);
            }
            return Optional.of(pubSubNodeEntity);
        }
        return Optional.empty();
    }

    public boolean storeEntity(PubSubNodeEntity entity) throws Exception {
        if (entity.getOwner().isEmpty()) {
            log.log(Level.FINE, "No owner defined for entity: " + entity);
            throw new IllegalStateException("No owner defined for: " + entity.getNode());
        }
        BareJID owner = entity.getOwner().iterator().next();
        INodeMeta nodeMeta = this.repository.getNodeMeta(entity.getService(), entity.getParent());
        String collection = nodeMeta != null ? entity.getParent() : null;
        entity.getNodeConfig().setCollection(collection);
        this.repository.createNode(entity.getService(), entity.getNode(), owner, entity.getNodeConfig(), entity.getNodeType(), collection);
        IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(entity.getService(), entity.getNode());
        for (UsersAffiliation na : entity.getNodeAffiliations()) {
            nodeAffiliations.addAffiliation(na.getJid(), na.getAffiliation());
        }
        this.repository.update(entity.getService(), entity.getNode(), nodeAffiliations);
        for (BareJID ownerJid : entity.getOwner()) {
            nodeAffiliations.addAffiliation(ownerJid, Affiliation.owner);
        }
        ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(entity.getService(), entity.getNode());
        for (UsersSubscription ns : entity.getNodeSubscriptions()) {
            nodeSubscriptions.addSubscriberJid(ns.getJid(), ns.getSubscription());
        }
        this.repository.update(entity.getService(), entity.getNode(), nodeSubscriptions);
        return true;
    }

    public Map<String, String> getAdditionalQueriesToInitialise() {
        return this.queries.getAllQueriesForServerAndDatabase().orElse(Collections.emptyMap());
    }

    public Optional<Class> getParentBean() {
        return Optional.of(PubSubComponent.class);
    }

    private void setNodeConfiguration(PubSubNodeEntity pubSubNodeEntity, String key, String value) {
        String[] split = PubSubNodeConverter.parseArrayValue(value = !"<<>>".equals(value) ? value : "");
        if (split != null && split.length > 0) {
            pubSubNodeEntity.setConfigValues(key, split);
        } else {
            pubSubNodeEntity.setConfigValue(key, value);
        }
    }

    private QueryExecutor.QueryFunction<PreparedStatement, Map<BareJID, UserAssociation>> getAssociation(Long node_id) {
        return preparedStatement -> {
            ConcurrentHashMap<BareJID, UserAssociation> associations = new ConcurrentHashMap<BareJID, UserAssociation>();
            ResultSet resultSet = null;
            preparedStatement.setString(1, String.valueOf(node_id));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String jidString = resultSet.getString("jid");
                BareJID jid = BareJID.bareJIDInstance((String)jidString);
                String affiliationString = resultSet.getString("affiliation");
                Affiliation affiliation = PubSubNodeConverter.decodeAffiliation(affiliationString);
                String subString = resultSet.getString("subscriptions");
                Subscription subscription = PubSubNodeConverter.decodeSubscription(subString);
                associations.put(jid, new UserAssociation(subscription, affiliation));
            }
            resultSet.close();
            return associations;
        };
    }

    private QueryExecutor.QueryFunction<PreparedStatement, Map<String, String>> getConfiguration(Long node_id) {
        return preparedStatement -> {
            ConcurrentHashMap<String, String> options = new ConcurrentHashMap<String, String>();
            ResultSet resultSet = null;
            preparedStatement.setString(1, String.valueOf(node_id));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                String value = resultSet.getString("val");
                options.put(name, value);
            }
            resultSet.close();
            return options;
        };
    }

    private QueryExecutor.QueryFunction<PreparedStatement, List<BareJID>> getOwner(Long node_id) {
        return preparedStatement -> {
            CopyOnWriteArrayList<BareJID> items = new CopyOnWriteArrayList<BareJID>();
            ResultSet resultSet = null;
            preparedStatement.setString(1, String.valueOf(node_id));
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String ownerString = resultSet.getString("owner");
                BareJID owner = BareJID.bareJIDInstance((String)ownerString);
                items.add(owner);
            }
            resultSet.close();
            return items;
        };
    }

    private class UserAssociation {
        Affiliation affiliation;
        Subscription subscription;

        UserAssociation(Subscription subscription, Affiliation affiliation) {
            this.subscription = subscription;
            this.affiliation = affiliation;
        }
    }
}

