/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.ext.presence.PresenceNodeSubscriptions;
import tigase.pubsub.modules.ext.presence.PresenceNotifierModule;
import tigase.pubsub.modules.ext.presence.PresencePerNodeExtension;
import tigase.pubsub.modules.mam.PubSubQuery;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IExtendedPubSubDAO;
import tigase.pubsub.repository.IExtenedMAMPubSubRepository;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.cached.IAffiliationsCached;
import tigase.pubsub.repository.cached.ISubscriptionsCached;
import tigase.pubsub.repository.cached.Items;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.Cache;
import tigase.pubsub.utils.LRUCacheWithFuture;
import tigase.pubsub.utils.PubSubLogic;
import tigase.stats.Counter;
import tigase.stats.StatisticHolder;
import tigase.stats.StatisticHolderImpl;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.rsm.RSM;

@Bean(name="repository", parent=PubSubComponent.class, active=true)
public class CachedPubSubRepository<T>
implements IPubSubRepository,
IExtenedMAMPubSubRepository,
StatisticHolder,
Initializable,
IItems.IListnener {
    private final ConcurrentHashMap<BareJID, RootCollectionSet> rootCollection = new ConcurrentHashMap();
    @Inject
    protected IPubSubConfig config;
    @Inject
    protected IPubSubDAO<T, DataSource, PubSubQuery> dao;
    protected static Logger log = Logger.getLogger(CachedPubSubRepository.class.getName());
    @Inject
    protected PubSubLogic pubSubLogic;
    protected Cache<NodeKey, Node> nodes;
    private StatisticHolder cacheStats;
    @ConfigField(desc="Delayed load of root nodes collections", alias="delayed-root-collection-loading")
    private boolean delayedRootCollectionLoading = false;
    private long nodes_added = 0L;
    @Inject(nullAllowed=true)
    private PresenceNotifierModule presenceNotifierModule;
    private long repo_writes = 0L;
    private Map<String, StatisticHolder> stats;
    private long updateSubscriptionsCalled = 0L;
    private long writingTime = 0L;
    protected final AtomicLong nodesCount = new AtomicLong(0L);
    @Inject(nullAllowed=true)
    private IPubSubRepository.IListener listener;
    @Inject(nullAllowed=true)
    private NodeAffiliationProvider<T> nodeAffiliationProvider;

    protected boolean isServiceAutoCreated() {
        return this.pubSubLogic.isServiceAutoCreated();
    }

    @Override
    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Addint to root collection, serviceJid: {0}, nodeName: {1}", new Object[]{serviceJid, nodeName});
        }
        if (!this.pubSubLogic.isServiceJidPEP(serviceJid)) {
            this.getRootCollectionSet(serviceJid).add(nodeName);
        }
    }

    @Override
    public void createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException, PubSubException {
        Object nodeId;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Creating node, serviceJid: {0}, nodeName: {1}, ownerJid: {2}, nodeConfig: {3}, nodeType: {4}, collection: {5}", new Object[]{serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collection});
        }
        this.pubSubLogic.checkNodeConfig(nodeConfig);
        long start = System.currentTimeMillis();
        Object collectionId = null;
        if (collection != null && !collection.equals("")) {
            Node collectionNode = this.getNode(serviceJid, collection);
            if (collectionNode == null) {
                throw new RepositoryException("Parent collection does not exists yet!");
            }
            collectionId = collectionNode.getNodeId();
        }
        if (null == (nodeId = this.dao.createNode(serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collectionId, this.isServiceAutoCreated()))) {
            throw new RepositoryException("Creating node failed!");
        }
        IAffiliationsCached nodeAffiliations = this.newNodeAffiliations(serviceJid, nodeName, nodeId, () -> null);
        ISubscriptionsCached nodeSubscriptions = this.newNodeSubscriptions(serviceJid, nodeName, nodeId, () -> null);
        Items<Object> nodeItems = new Items<Object>(nodeId, serviceJid, nodeName, this.dao, this);
        Node<Object> node = new Node<Object>(nodeId, serviceJid, nodeConfig, nodeAffiliations, nodeSubscriptions, nodeItems, ownerJid, new Date());
        NodeKey key = this.createKey(serviceJid, nodeName);
        this.nodes.putIfAbsent(key, node);
        if (collection != null && !collection.equals("")) {
            this.nodeCollectionChanged(serviceJid, nodeName, null, collection);
        }
        long end = System.currentTimeMillis();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Creating node[2], serviceJid: {0}, nodeName: {1}, nodeAffiliations: {2}, nodeSubscriptions: {3}, node: {4}", new Object[]{serviceJid, nodeName, nodeAffiliations, nodeSubscriptions, node});
        }
        ++this.nodes_added;
        this.nodesCount.incrementAndGet();
        this.writingTime += end - start;
    }

    @Override
    public void createService(BareJID serviceJID, boolean isPublic) throws RepositoryException {
        this.dao.createService(serviceJID, isPublic);
    }

    @Override
    public List<BareJID> getServices(BareJID domain, Boolean isPublic) throws RepositoryException {
        return this.dao.getServices(domain, isPublic);
    }

    @Override
    public void deleteNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        NodeKey key = this.createKey(serviceJid, nodeName);
        Node node = this.getNode(serviceJid, nodeName);
        if (node == null) {
            throw new RepositoryException("Node does not exists!");
        }
        this.dao.deleteNode(serviceJid, node.getNodeId());
        node.setDeleted(true);
        this.nodes.remove(key);
        this.nodesCount.decrementAndGet();
    }

    @Override
    public void destroy() {
    }

    public void everyHour() {
        this.cacheStats.everyHour();
        for (StatisticHolder holder : this.stats.values()) {
            holder.everyHour();
        }
    }

    public void everyMinute() {
        this.cacheStats.everyMinute();
        for (StatisticHolder holder : this.stats.values()) {
            holder.everyMinute();
        }
    }

    public void everySecond() {
        this.cacheStats.everySecond();
        for (StatisticHolder holder : this.stats.values()) {
            holder.everySecond();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNodeConfiguration(BareJID serviceJID, String nodeName, Form config) {
        if (config != null) {
            Node node = this.getNodeFromCache(serviceJID, nodeName);
            if (node != null) {
                Node node2 = node;
                synchronized (node2) {
                    node.getNodeConfig().copyFromForm(config);
                }
            }
        } else {
            this.nodes.remove(new NodeKey(serviceJID, nodeName));
        }
    }

    @Override
    public String[] getChildNodes(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        if (node == null) {
            return new String[0];
        }
        String[] children = node.getChildNodes();
        if (children == null) {
            children = this.dao.getChildNodes(serviceJid, nodeName);
            node.setChildNodes(Arrays.asList(children));
        }
        return children;
    }

    @Override
    public IAffiliations getNodeAffiliations(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        return node == null ? null : node.getNodeAffiliations();
    }

    @Override
    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting node config, serviceJid: {0}, nodeName: {1}, node: {2}", new Object[]{serviceJid, nodeName, node});
        }
        try {
            return node == null ? null : node.getNodeConfig().clone();
        }
        catch (CloneNotSupportedException e) {
            log.log(Level.WARNING, "Error getting node config", e);
            return null;
        }
    }

    @Override
    public INodeMeta getNodeMeta(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.getNode(serviceJid, nodeName);
    }

    @Override
    public IItems getNodeItems(BareJID serviceJid, String nodeName) throws RepositoryException {
        NodeKey key = this.createKey(serviceJid, nodeName);
        long start = System.currentTimeMillis();
        Node node = this.getNode(serviceJid, nodeName);
        if (node == null) {
            return null;
        }
        return node.getNodeItems();
    }

    @Override
    public List<IItems.IItem> getNodeItems(BareJID serviceJid, String nodeName, JID requester, Date after, Date before, RSM rsm) throws ComponentException, RepositoryException {
        List<Node<T>> nodes = this.getNodeAndSubnodes(serviceJid, nodeName, node -> this.hasAccessPermission((Node)node, requester, PubSubLogic.Action.retrieveItems), node -> node.getNodeConfig() instanceof LeafNodeConfig);
        if (nodes.isEmpty()) {
            rsm.setIndex(Integer.valueOf(0));
            rsm.setCount(Integer.valueOf(0));
            return Collections.emptyList();
        }
        List nodeIds = nodes.stream().map(node -> node.getNodeId()).collect(Collectors.toList());
        return this.dao.getItems(serviceJid, nodeIds, after, before, rsm, this.getNode(serviceJid, nodeName).getNodeConfig().getCollectionItemsOrdering());
    }

    @Override
    public ISubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        ISubscriptionsCached xx;
        Node node = this.getNode(serviceJid, nodeName);
        ISubscriptionsCached iSubscriptionsCached = xx = node == null ? null : node.getNodeSubscriptions();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting node subscriptions, serviceJid: {0}, nodeName: {1}, node: {2}", new Object[]{serviceJid, nodeName, node});
        }
        if (this.presenceNotifierModule == null || xx == null) {
            return xx;
        }
        PresencePerNodeExtension extension = this.presenceNotifierModule.getPresencePerNodeExtension();
        if (extension != null) {
            return new PresenceNodeSubscriptions(serviceJid, nodeName, xx, extension);
        }
        return xx;
    }

    @Override
    public long getNodesCount(BareJID serviceJID) throws RepositoryException {
        if (serviceJID != null) {
            return this.dao.getNodesCount(serviceJID);
        }
        return this.nodesCount.get();
    }

    @Override
    public IPubSubDAO getPubSubDAO() {
        return this.dao;
    }

    public void setDao(IPubSubDAO<T, DataSource, PubSubQuery> dao) {
        this.dao = dao;
        try {
            this.nodesCount.set(dao.getNodesCount(null));
        }
        catch (RepositoryException ex) {
            this.nodesCount.set(0L);
        }
    }

    @Override
    public String[] getRootCollection(BareJID serviceJid) throws RepositoryException {
        if (this.pubSubLogic.isServiceJidPEP(serviceJid)) {
            return this.dao.getChildNodes(serviceJid, null);
        }
        IPubSubRepository.RootCollectionSetIfc rootCollection = this.getRootCollectionSet(serviceJid);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting root collection, serviceJid: {0}", new Object[]{serviceJid});
        }
        if (rootCollection == null) {
            return null;
        }
        Set<String> nodes = rootCollection.values();
        return nodes.toArray(new String[nodes.size()]);
    }

    public void getStatistics(String name, StatisticsList stats) {
        if (this.nodes.size() > 0) {
            stats.add(name, "Cached nodes", this.nodes.size(), Level.FINE);
        } else {
            stats.add(name, "Cached nodes", this.nodes.size(), Level.FINEST);
        }
        long subscriptionsCount = 0L;
        long affiliationsCount = 0L;
        affiliationsCount += (long)this.nodes.values().map(Node::getNodeAffiliations).mapToInt(IAffiliations::size).sum();
        subscriptionsCount += (long)this.nodes.values().map(Node::getNodeSubscriptions).mapToInt(ISubscriptions::size).sum();
        if (this.updateSubscriptionsCalled > 0L) {
            stats.add(name, "Update subscriptions calls", this.updateSubscriptionsCalled, Level.FINE);
        } else {
            stats.add(name, "Update subscriptions calls", this.updateSubscriptionsCalled, Level.FINEST);
        }
        if (subscriptionsCount > 0L) {
            stats.add(name, "Subscriptions count (in cache)", subscriptionsCount, Level.FINE);
        } else {
            stats.add(name, "Subscriptions count (in cache)", subscriptionsCount, Level.FINEST);
        }
        if (affiliationsCount > 0L) {
            stats.add(name, "Affiliations count (in cache)", affiliationsCount, Level.FINE);
        } else {
            stats.add(name, "Affiliations count (in cache)", affiliationsCount, Level.FINEST);
        }
        if (this.repo_writes > 0L) {
            stats.add(name, "Repository writes", this.repo_writes, Level.FINE);
        } else {
            stats.add(name, "Repository writes", this.repo_writes, Level.FINEST);
        }
        if (this.nodes_added > 0L) {
            stats.add(name, "Added new nodes", this.nodes_added, Level.INFO);
        } else {
            stats.add(name, "Added new nodes", this.nodes_added, Level.FINEST);
        }
        stats.add(name, "Total number of nodes", this.nodesCount.get(), Level.INFO);
        if (this.nodes_added > 0L) {
            stats.add(name, "Total writing time", Utils.longToTime(this.writingTime), Level.INFO);
        } else {
            stats.add(name, "Total writing time", Utils.longToTime(this.writingTime), Level.FINEST);
        }
        if (this.nodes_added + this.repo_writes > 0L) {
            if (this.nodes_added > 0L) {
                stats.add(name, "Average DB write time [ms]", this.writingTime / (this.nodes_added + this.repo_writes), Level.INFO);
            } else {
                stats.add(name, "Average DB write time [ms]", this.writingTime / (this.nodes_added + this.repo_writes), Level.FINEST);
            }
        }
        this.cacheStats.getStatistics(name, stats);
        for (StatisticHolder holder : this.stats.values()) {
            holder.getStatistics(name, stats);
        }
    }

    @Override
    public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
        Map<String, UsersAffiliation> results;
        if (this.nodeAffiliationProvider != null && (results = this.nodeAffiliationProvider.getUserAffiliations(serviceJid, jid)) != null) {
            return results;
        }
        return this.dao.getUserAffiliations(serviceJid, jid);
    }

    @Override
    public Map<BareJID, RosterElement> getUserRoster(BareJID owner) throws RepositoryException {
        return this.dao.getUserRoster(owner);
    }

    @Override
    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID userJid) throws RepositoryException {
        return this.dao.getUserSubscriptions(serviceJid, userJid);
    }

    @Override
    public void init() {
        log.config("Cached PubSubRepository initialising...");
    }

    public void initialize() {
        LRUCacheWithFuture<NodeKey, Node> cache;
        Integer maxCacheSize = this.config.getMaxCacheSize();
        this.cacheStats = cache = new LRUCacheWithFuture<NodeKey, Node>(maxCacheSize);
        this.nodes = cache;
        log.config("Initializing Cached Repository with cache size = " + (Serializable)(maxCacheSize == null ? "OFF" : maxCacheSize));
        this.stats = new ConcurrentHashMap<String, StatisticHolder>();
        this.stats.put("getNodeItems", (StatisticHolder)new StatisticHolderImpl("db/getNodeItems requests"));
    }

    public void queryItems(PubSubQuery query, MAMRepository.ItemHandler<PubSubQuery, MAMRepository.Item> itemHandler) throws RepositoryException, ComponentException {
        BareJID serviceJid = query.getComponentJID().getBareJID();
        JID requester = query.getQuestionerJID();
        Node node = this.getNode(serviceJid, query.getPubsubNode());
        if (node != null && !(node.getNodeConfig() instanceof LeafNodeConfig)) {
            throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED);
        }
        this.pubSubLogic.checkPermission(serviceJid, query.getPubsubNode(), requester, PubSubLogic.Action.retrieveItems);
        this.dao.queryItems(query, node.getNodeId(), itemHandler);
    }

    public PubSubQuery newQuery() {
        return this.dao.newQuery();
    }

    public PubSubQuery newQuery(BareJID jid) {
        return this.dao.newQuery(jid);
    }

    @Override
    public void removeFromRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        IPubSubRepository.RootCollectionSetIfc rootCollectionSet;
        if (!this.pubSubLogic.isServiceJidPEP(serviceJid) && (rootCollectionSet = this.getRootCollectionSet(serviceJid)) != null) {
            rootCollectionSet.remove(nodeName);
        }
    }

    public void setStatisticsPrefix(String prefix) {
    }

    public void statisticExecutedIn(long executionTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(BareJID serviceJid, String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException, PubSubException {
        this.pubSubLogic.checkNodeConfig(nodeConfig);
        Node node = this.getNode(serviceJid, nodeName);
        if (node != null) {
            String oldCollection = node.getNodeConfig().getCollection();
            Node node2 = node;
            synchronized (node2) {
                node.configCopyFrom(nodeConfig);
            }
            log.finest("Node '" + nodeName + "' added to lazy write queue (config)");
            this.saveNode(node, 0);
            String newCollection = nodeConfig.getCollection();
            if (!Objects.equals(oldCollection, newCollection)) {
                this.nodeCollectionChanged(serviceJid, nodeName, oldCollection, newCollection);
            }
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, IAffiliations nodeAffiliations) throws RepositoryException {
        if (nodeAffiliations instanceof IAffiliationsCached) {
            Node node = this.getNode(serviceJid, nodeName);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Updating node affiliations, serviceJid: {0}, nodeName: {1}, node: {2}, nodeAffiliations: {3}", new Object[]{serviceJid, nodeName, node, nodeAffiliations});
            }
            if (node != null) {
                if (node.getNodeAffiliations() != nodeAffiliations) {
                    throw new RuntimeException("INCORRECT");
                }
                log.finest("Node '" + nodeName + "' added to lazy write queue (affiliations), node: " + node);
                this.saveNode(node, 0);
            }
        } else {
            throw new RuntimeException("Wrong class");
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, ISubscriptions nodeSubscriptions) throws RepositoryException {
        ++this.updateSubscriptionsCalled;
        Node node = this.getNode(serviceJid, nodeName);
        if (node != null) {
            log.finest("Node '" + nodeName + "' added to lazy write queue (subscriptions)");
            this.saveNode(node, 0);
        }
    }

    @Override
    public void deleteService(BareJID userJid) throws RepositoryException {
        this.dao.deleteService(userJid);
        this.serviceRemoved(userJid);
    }

    @Override
    public void addMAMItem(BareJID serviceJid, String nodeName, String uuid, Element message, String itemId) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        if (node != null) {
            this.dao.addMAMItem(serviceJid, node.getNodeId(), uuid, message, itemId);
        }
    }

    @Override
    public MAMRepository.Item getMAMItem(BareJID serviceJid, String nodeName, String stableId) throws RepositoryException {
        if (this.dao instanceof IExtendedPubSubDAO) {
            Node node = this.getNode(serviceJid, nodeName);
            if (node != null) {
                return ((IExtendedPubSubDAO)this.dao).getMAMItem(serviceJid, node.getNodeId(), stableId);
            }
            return null;
        }
        throw new RepositoryException("Feature not implemented!");
    }

    @Override
    public void updateMAMItem(BareJID serviceJid, String nodeName, String stableId, Element message) throws RepositoryException {
        if (this.dao instanceof IExtendedPubSubDAO) {
            Node node = this.getNode(serviceJid, nodeName);
            if (node != null) {
                ((IExtendedPubSubDAO)this.dao).updateMAMItem(serviceJid, node.getNodeId(), stableId, message);
            }
        } else {
            throw new RepositoryException("Feature not implemented!");
        }
    }

    @Override
    public boolean validateItem(BareJID serviceJID, String node, String id, String publisher, Element item) throws PubSubException {
        if (this.listener != null) {
            return this.listener.validateItem(serviceJID, node, id, publisher, item);
        }
        return true;
    }

    @Override
    public void itemWritten(BareJID serviceJID, String node, String id, String publisher, Element item, String uuid) {
        if (this.listener != null) {
            this.listener.itemWritten(serviceJID, node, id, publisher, item, uuid);
        }
    }

    @Override
    public void itemDeleted(BareJID serviceJID, String node, String id) {
        if (this.listener != null) {
            this.listener.itemDeleted(serviceJID, node, id);
        }
    }

    protected NodeKey createKey(BareJID serviceJid, String nodeName) {
        return new NodeKey(serviceJid, nodeName);
    }

    protected Node getNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        NodeKey key = this.createKey(serviceJid, nodeName);
        try {
            Node node = this.nodes.computeIfAbsent(key, () -> {
                try {
                    return this.loadNode(serviceJid, nodeName);
                }
                catch (RepositoryException ex) {
                    throw new Cache.CacheException(ex);
                }
            });
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Getting node, serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}", new Object[]{serviceJid, nodeName, key, node});
            }
            return node;
        }
        catch (Cache.CacheException ex) {
            throw new RepositoryException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected Node loadNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        INodeMeta<T> nodeMeta = this.dao.getNodeMeta(serviceJid, nodeName);
        if (nodeMeta == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Getting node[1] -- nodeId null! serviceJid: {0}, nodeName: {1}, nodeId: {2}", new Object[]{serviceJid, nodeName, null});
            }
            return null;
        }
        AbstractNodeConfig nodeConfig = nodeMeta.getNodeConfig();
        if (nodeConfig == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Getting node[2] -- config null! serviceJid: {0}, nodeName: {1}, cfgData: {2}", new Object[]{serviceJid, nodeName, null});
            }
            return null;
        }
        IAffiliationsCached nodeAffiliations = this.newNodeAffiliations(serviceJid, nodeName, nodeMeta.getNodeId(), () -> this.dao.getNodeAffiliations(serviceJid, nodeMeta.getNodeId()));
        ISubscriptionsCached nodeSubscriptions = this.newNodeSubscriptions(serviceJid, nodeName, nodeMeta.getNodeId(), () -> this.dao.getNodeSubscriptions(serviceJid, nodeMeta.getNodeId()));
        Items<T> nodeItems = new Items<T>(nodeMeta.getNodeId(), serviceJid, nodeName, this.dao, this);
        Node<T> node = new Node<T>(nodeMeta.getNodeId(), serviceJid, nodeConfig, nodeAffiliations, nodeSubscriptions, nodeItems, nodeMeta.getCreator(), nodeMeta.getCreationTime());
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting node[2], serviceJid: {0}, nodeName: {1}, node: {2}, nodeAffiliations {3}, nodeSubscriptions: {4}", new Object[]{serviceJid, nodeName, node, nodeAffiliations, nodeSubscriptions});
        }
        return node;
    }

    protected IAffiliationsCached newNodeAffiliations(BareJID serviceJid, String nodeName, T nodeId, IPubSubRepository.RepositorySupplier<Map<BareJID, UsersAffiliation>> affiliationSupplier) throws RepositoryException {
        IAffiliationsCached affiliationsCached;
        if (this.nodeAffiliationProvider != null && (affiliationsCached = this.nodeAffiliationProvider.newNodeAffiliations(serviceJid, nodeName, nodeId, affiliationSupplier)) != null) {
            return affiliationsCached;
        }
        return new NodeAffiliations(affiliationSupplier.get());
    }

    protected ISubscriptionsCached newNodeSubscriptions(BareJID serviceJid, String nodeName, T nodeId, IPubSubRepository.RepositorySupplier<Map<BareJID, UsersSubscription>> subscriptionsSupplier) throws RepositoryException {
        return new NodeSubscriptions(subscriptionsSupplier.get());
    }

    protected Node getNodeFromCache(BareJID serviceJid, String nodeName) {
        NodeKey key = this.createKey(serviceJid, nodeName);
        return this.nodes.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPubSubRepository.RootCollectionSetIfc getRootCollectionSet(BareJID serviceJid) throws RepositoryException {
        RootCollectionSet rootCollection = this.rootCollection.get(serviceJid);
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting root collection, serviceJid: {0}", new Object[]{serviceJid});
        }
        if (rootCollection == null || !rootCollection.checkState(RootCollectionSet.State.initialized)) {
            RootCollectionSet oldRootCollection;
            if (rootCollection == null && (oldRootCollection = this.rootCollection.putIfAbsent(serviceJid, rootCollection = new RootCollectionSet(serviceJid, this))) != null) {
                rootCollection = oldRootCollection;
            }
            if (!this.delayedRootCollectionLoading) {
                RootCollectionSet rootCollectionSet = rootCollection;
                synchronized (rootCollectionSet) {
                    this.loadRootCollections(rootCollection);
                }
            }
        }
        return rootCollection;
    }

    protected void loadRootCollections(RootCollectionSet rootCollection) throws RepositoryException {
        BareJID serviceJid = rootCollection.getServiceJid();
        String[] x = this.dao.getChildNodes(serviceJid, null);
        rootCollection.loadData(x);
    }

    protected List<Node<T>> getNodeAndSubnodes(BareJID serviceJid, String nodeName, Predicate<Node<T>> filterWithSubnodes, Predicate<Node<T>> filter) throws RepositoryException, ComponentException {
        String[] childNodes;
        AbstractNodeConfig nodeConfig;
        ArrayList<Node<T>> result = new ArrayList<Node<T>>();
        Node node = this.getNode(serviceJid, nodeName);
        if (node == null) {
            throw new PubSubException(Authorization.ITEM_NOT_FOUND);
        }
        if (filterWithSubnodes != null && !filterWithSubnodes.test(node)) {
            return Collections.emptyList();
        }
        if (filter != null && filter.test(node)) {
            result.add(node);
        }
        if ((nodeConfig = node.getNodeConfig()) instanceof CollectionNodeConfig && (childNodes = this.getChildNodes(serviceJid, nodeName)) != null) {
            for (String child : childNodes) {
                result.addAll(this.getNodeAndSubnodes(serviceJid, child, filterWithSubnodes, filter));
            }
        }
        return result;
    }

    protected boolean hasAccessPermission(Node node, JID requester, PubSubLogic.Action action) {
        try {
            this.pubSubLogic.checkPermission(node.getServiceJid(), node.getName(), requester, action);
            return true;
        }
        catch (RepositoryException | PubSubException ex) {
            return false;
        }
    }

    protected void serviceRemoved(BareJID userJid) {
        NodeKey[] keys;
        if (this.listener != null) {
            this.listener.serviceRemoved(userJid);
        }
        try {
            this.nodesCount.set(this.dao.getNodesCount(null));
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        if (!this.pubSubLogic.isServiceJidPEP(userJid)) {
            this.rootCollection.remove(userJid);
        }
        boolean isPEP = this.pubSubLogic.isServiceJidPEP(userJid);
        for (NodeKey key : keys = this.nodes.keySet().toArray(new NodeKey[0])) {
            Node node;
            if (userJid.equals((Object)key.serviceJid)) {
                this.nodes.remove(key);
                continue;
            }
            if (!isPEP || (node = this.nodes.get(key)) == null) continue;
            ISubscriptionsCached nodeSubscriptions = node.getNodeSubscriptions();
            nodeSubscriptions.changeSubscription(userJid, Subscription.none);
            nodeSubscriptions.merge();
            IAffiliationsCached nodeAffiliations = node.getNodeAffiliations();
            nodeAffiliations.changeAffiliation(userJid, Affiliation.none);
            nodeAffiliations.merge();
        }
    }

    protected void nodeCollectionChanged(BareJID serviceJid, String nodeName, String oldCollection, String newCollection) {
        Node colNode;
        if (oldCollection != null && !"".equals(oldCollection) && (colNode = this.getNodeFromCache(serviceJid, oldCollection)) != null) {
            colNode.childNodeRemoved(nodeName);
        }
        if (newCollection != null && !"".equals(newCollection) && (colNode = this.getNodeFromCache(serviceJid, newCollection)) != null) {
            colNode.childNodeAdded(nodeName);
        }
    }

    protected void saveNode(Node<T> node, int iteration) throws RepositoryException {
        long start = System.currentTimeMillis();
        ++this.repo_writes;
        try {
            if (node.isDeleted()) {
                return;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Saving node: {0}", new Object[]{node});
            }
            if (node.configNeedsWriting()) {
                String collection = node.getNodeConfig().getCollection();
                Object collectionId = null;
                if (collection != null && !collection.equals("")) {
                    Node node2 = this.getNode(node.getServiceJid(), collection);
                    if (node2 == null) {
                        throw new RepositoryException("Parent collection does not exists yet!");
                    }
                    collectionId = node2.getNodeId();
                }
                this.dao.updateNodeConfig(node.getServiceJid(), node.getNodeId(), node.getNodeConfig().getFormElement().toString(), collectionId);
                node.configSaved();
            }
            if (node.affiliationsNeedsWriting()) {
                Map<BareJID, UsersAffiliation> changedAffiliations = node.getNodeAffiliations().getChanged();
                for (Map.Entry<BareJID, Cloneable> entry : changedAffiliations.entrySet()) {
                    this.dao.updateNodeAffiliation(node.getServiceJid(), node.getNodeId(), node.getName(), (UsersAffiliation)entry.getValue());
                }
                node.affiliationsSaved();
            }
            if (node.subscriptionsNeedsWriting()) {
                Map<BareJID, UsersSubscription> changedSubscriptions = node.getNodeSubscriptions().getChanged();
                for (Map.Entry<BareJID, Cloneable> entry : changedSubscriptions.entrySet()) {
                    UsersSubscription subscription = (UsersSubscription)entry.getValue();
                    if (subscription.getSubscription() == Subscription.none) {
                        this.dao.removeNodeSubscription(node.getServiceJid(), node.getNodeId(), subscription.getJid());
                        continue;
                    }
                    this.dao.updateNodeSubscription(node.getServiceJid(), node.getNodeId(), node.getName(), subscription);
                }
                node.subscriptionsSaved();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem saving pubsub data: ", e);
            node.resetChanges();
            throw new RepositoryException("Problem saving pubsub data", (Throwable)e);
        }
        if (node.needsWriting()) {
            if (iteration >= 10) {
                String msg = "Was not able to save data for node " + node.getName() + " on " + iteration + " iteration, config saved = " + !node.configNeedsWriting() + ", affiliations saved = " + !node.affiliationsNeedsWriting() + ", subscriptions saved = " + !node.subscriptionsNeedsWriting();
                log.log(Level.WARNING, msg);
                throw new RepositoryException("Problem saving pubsub data");
            }
            this.saveNode(node, iteration++);
        }
        long end = System.currentTimeMillis();
        this.writingTime += end - start;
    }

    public static class NodeKey {
        public final String node;
        public final BareJID serviceJid;

        public NodeKey(BareJID serviceJid, String node) {
            this.serviceJid = serviceJid;
            this.node = node;
        }

        public int hashCode() {
            return Objects.hash(this.serviceJid, this.node);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeKey)) {
                return false;
            }
            return this.serviceJid.equals((Object)((NodeKey)obj).serviceJid) && this.node.equals(((NodeKey)obj).node);
        }

        public String toString() {
            return "NodeKey[serviceJid = " + this.serviceJid.toString() + ", node = " + this.node + "]";
        }
    }

    public static interface NodeAffiliationProvider<T> {
        public Map<String, UsersAffiliation> getUserAffiliations(BareJID var1, BareJID var2) throws RepositoryException;

        public IAffiliationsCached newNodeAffiliations(BareJID var1, String var2, T var3, IPubSubRepository.RepositorySupplier<Map<BareJID, UsersAffiliation>> var4) throws RepositoryException;
    }

    public static class RootCollectionSet
    implements IPubSubRepository.RootCollectionSetIfc {
        private static final Logger log = Logger.getLogger(RootCollectionSet.class.getCanonicalName());
        private Set<String> added;
        private CachedPubSubRepository cachedPubSubRepository;
        private Set<String> removed;
        private Set<String> rootCollections;
        private BareJID serviceJid;
        private State state = State.uninitialized;

        public RootCollectionSet(BareJID serviceJid, CachedPubSubRepository cachedPubSubRepository) {
            this.serviceJid = serviceJid;
            this.cachedPubSubRepository = cachedPubSubRepository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(String node) {
            RootCollectionSet rootCollectionSet = this;
            synchronized (rootCollectionSet) {
                switch (this.state) {
                    case initialized: {
                        this.rootCollections.add(node);
                        break;
                    }
                    case loading: {
                        this.added.add(node);
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkState(State state) {
            RootCollectionSet rootCollectionSet = this;
            synchronized (rootCollectionSet) {
                return this.state == state;
            }
        }

        public BareJID getServiceJid() {
            return this.serviceJid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(String node) {
            RootCollectionSet rootCollectionSet = this;
            synchronized (rootCollectionSet) {
                switch (this.state) {
                    case initialized: {
                        this.rootCollections.remove(node);
                        break;
                    }
                    case loading: {
                        this.added.remove(node);
                        this.removed.add(node);
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<String> values() throws IllegalStateException {
            RootCollectionSet rootCollectionSet = this;
            synchronized (rootCollectionSet) {
                switch (this.state) {
                    case initialized: {
                        return this.rootCollections;
                    }
                    case loading: {
                        throw new IllegalStateException(this.state);
                    }
                    case uninitialized: {
                        this.added = new HashSet<String>();
                        this.removed = new HashSet<String>();
                        new Thread(this::startLoadOfData).start();
                        this.state = State.loading;
                        throw new IllegalStateException(this.state);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startLoadOfData() {
            try {
                this.cachedPubSubRepository.loadRootCollections(this);
            }
            catch (Throwable ex) {
                log.log(Level.FINE, "Could not load");
                RootCollectionSet rootCollectionSet = this;
                synchronized (rootCollectionSet) {
                    switch (this.state) {
                        case loading: {
                            this.added = null;
                            this.removed = null;
                            this.state = State.uninitialized;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadData(String[] nodes) {
            RootCollectionSet rootCollectionSet = this;
            synchronized (rootCollectionSet) {
                this.rootCollections = nodes != null ? Collections.synchronizedSet(new HashSet(nodes.length)) : Collections.synchronizedSet(new HashSet());
                if (this.added == null && this.removed == null) {
                    if (nodes != null) {
                        this.rootCollections.addAll(Arrays.asList(nodes));
                    }
                } else {
                    this.rootCollections.addAll(this.added);
                    if (nodes != null) {
                        Arrays.stream(nodes).filter(node -> !this.removed.contains(node)).forEach(this.rootCollections::add);
                    }
                    this.added = null;
                    this.removed = null;
                }
                this.state = State.initialized;
            }
        }

        public static enum State {
            uninitialized,
            loading,
            initialized;

        }

        public static class IllegalStateException
        extends java.lang.IllegalStateException {
            public final State state;

            public IllegalStateException(State state) {
                this.state = state;
            }
        }
    }

    public static class SizedCache<V>
    extends LinkedHashMap<NodeKey, V>
    implements StatisticHolder {
        private static final long serialVersionUID = 1L;
        private Counter hitsCounter = new Counter("cache/hits", Level.FINEST);
        private int maxCacheSize = 1000;
        private Counter requestsCounter = new Counter("cache/requests", Level.FINEST);

        public SizedCache(int maxSize) {
            super(maxSize, 0.1f, true);
            this.maxCacheSize = maxSize;
        }

        public void everyHour() {
            this.requestsCounter.everyHour();
            this.hitsCounter.everyHour();
        }

        public void everyMinute() {
            this.requestsCounter.everyMinute();
            this.hitsCounter.everyMinute();
        }

        public void everySecond() {
            this.requestsCounter.everySecond();
            this.hitsCounter.everySecond();
        }

        @Override
        public V get(Object key) {
            Object val = super.get(key);
            this.requestsCounter.inc();
            if (val != null) {
                this.hitsCounter.inc();
            }
            return val;
        }

        public void getStatistics(String compName, StatisticsList list) {
            this.requestsCounter.getStatistics(compName, list);
            this.hitsCounter.getStatistics(compName, list);
            list.add(compName, "cache/hit-miss ratio per minute", this.requestsCounter.getPerMinute() == 0L ? 0.0f : (float)this.hitsCounter.getPerMinute() / (float)this.requestsCounter.getPerMinute(), Level.FINE);
            list.add(compName, "cache/hit-miss ratio per second", this.requestsCounter.getPerSecond() == 0L ? 0.0f : (float)this.hitsCounter.getPerSecond() / (float)this.requestsCounter.getPerSecond(), Level.FINE);
        }

        public void setStatisticsPrefix(String prefix) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void statisticExecutedIn(long executionTime) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<NodeKey, V> eldest) {
            return this.size() > this.maxCacheSize;
        }
    }
}

